/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.remote.reader;

import com.sun.enterprise.admin.remote.AdminCommandStateImpl;
import com.sun.enterprise.admin.remote.reader.ActionReportJsonProprietaryReader;
import com.sun.enterprise.admin.remote.reader.CliActionReport;
import com.sun.enterprise.admin.remote.reader.ProprietaryReader;
import com.sun.enterprise.admin.util.AdminLoggerInfo;
import com.sun.enterprise.util.io.FileUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import org.glassfish.api.admin.AdminCommandState;

public class AdminCommandStateJsonProprietaryReader
implements ProprietaryReader<AdminCommandState> {
    @Override
    public boolean isReadable(Class<?> type, String mimetype) {
        return type.isAssignableFrom(AdminCommandState.class);
    }

    public AdminCommandState readFrom(HttpURLConnection urlConnection) throws IOException {
        return this.readFrom(urlConnection.getInputStream(), urlConnection.getContentType());
    }

    @Override
    public AdminCommandState readFrom(InputStream is, String contentType) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        FileUtils.copy((InputStream)is, (OutputStream)baos, (long)0L);
        String str = baos.toString("UTF-8");
        try {
            JSONObject json = new JSONObject(str);
            return AdminCommandStateJsonProprietaryReader.readAdminCommandState(json);
        }
        catch (JSONException ex) {
            LoggerRef.logger.log(Level.SEVERE, "NCLS-ADMIN-00011", ex);
            throw new IOException(ex);
        }
    }

    public static AdminCommandStateImpl readAdminCommandState(JSONObject json) throws JSONException {
        String strState = json.optString("state");
        AdminCommandState.State state = strState == null ? null : AdminCommandState.State.valueOf((String)strState);
        boolean emptyPayload = json.optBoolean("empty-payload", true);
        CliActionReport ar = null;
        JSONObject jsonReport = json.optJSONObject("action-report");
        if (jsonReport != null) {
            ar = new CliActionReport();
            ActionReportJsonProprietaryReader.fillActionReport(ar, jsonReport);
        }
        String id = json.optString("id");
        return new AdminCommandStateImpl(state, ar, emptyPayload, id);
    }

    static class LoggerRef {
        private static final Logger logger = AdminLoggerInfo.getLogger();

        LoggerRef() {
        }
    }
}

