/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.osgijavaeebase;

import java.util.Dictionary;
import java.util.Properties;
import org.glassfish.osgijavaeebase.Extender;
import org.glassfish.osgijavaeebase.ExtenderManager;
import org.glassfish.osgijavaeebase.JavaEEExtender;
import org.glassfish.osgijavaeebase.OSGiBundleArchive;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.url.URLStreamHandlerService;

public class OSGiJavaEEActivator
implements BundleActivator {
    private ExtenderManager extenderManager;
    private ServiceRegistration urlHandlerServiceRegistration;
    private ServiceRegistration javaeeExtenderServiceRegistration;

    public void start(BundleContext context) throws Exception {
        this.addURLHandler(context);
        this.extenderManager = new ExtenderManager(context);
        this.extenderManager.start();
        this.addExtender(context);
    }

    public void stop(BundleContext context) throws Exception {
        this.removeExtender();
        this.extenderManager.stop();
        this.removeURLHandler(context);
    }

    private void addExtender(BundleContext context) {
        JavaEEExtender extender = new JavaEEExtender(context);
        this.javaeeExtenderServiceRegistration = context.registerService(Extender.class.getName(), (Object)extender, null);
    }

    private void removeExtender() {
        this.javaeeExtenderServiceRegistration.unregister();
    }

    private void addURLHandler(BundleContext context) {
        Properties p = new Properties();
        p.setProperty("url.handler.protocol", "embeddedjar");
        this.urlHandlerServiceRegistration = context.registerService(URLStreamHandlerService.class.getName(), (Object)new OSGiBundleArchive.EmbeddedJarURLStreamHandlerService(), (Dictionary)p);
    }

    private void removeURLHandler(BundleContext context) {
        if (this.urlHandlerServiceRegistration != null) {
            this.urlHandlerServiceRegistration.unregister();
        }
    }
}

