/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.batch;

import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.util.ColumnFormatter;
import java.util.HashMap;
import java.util.Properties;
import javax.inject.Inject;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.CommandLock;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.RestEndpoint;
import org.glassfish.api.admin.RestEndpoints;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.batch.AbstractListCommand;
import org.glassfish.batch.spi.impl.BatchRuntimeConfiguration;
import org.glassfish.batch.spi.impl.BatchRuntimeHelper;
import org.glassfish.config.support.CommandTarget;
import org.glassfish.config.support.TargetType;
import org.glassfish.hk2.api.PerLookup;
import org.glassfish.internal.api.Target;
import org.jvnet.hk2.annotations.Service;

@Service(name="list-batch-runtime-configuration")
@PerLookup
@CommandLock(value=CommandLock.LockType.NONE)
@I18n(value="list.batch.runtime.configuration")
@ExecuteOn(value={RuntimeType.DAS})
@TargetType(value={CommandTarget.DAS, CommandTarget.STANDALONE_INSTANCE, CommandTarget.CLUSTER})
@RestEndpoints(value={@RestEndpoint(configBean=Domain.class, opType=RestEndpoint.OpType.GET, path="list-batch-runtime-configuration", description="List Batch Runtime Configuration")})
public class ListBatchRuntimeConfiguration
extends AbstractListCommand {
    private static final String DATA_SOURCE_NAME = "dataSourceLookupName";
    private static final String EXECUTOR_SERVICE_NAME = "executorServiceLookupName";
    @Inject
    protected Target targetUtil;
    @Inject
    BatchRuntimeHelper helper;

    @Override
    protected void executeCommand(AdminCommandContext context, Properties extraProps) {
        Config config = this.targetUtil.getConfig(this.target);
        if (config == null) {
            context.getActionReport().setMessage("No such config named: " + this.target);
            context.getActionReport().setActionExitCode(ActionReport.ExitCode.FAILURE);
            return;
        }
        BatchRuntimeConfiguration batchRuntimeConfiguration = (BatchRuntimeConfiguration)config.getExtensionByType(BatchRuntimeConfiguration.class);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(DATA_SOURCE_NAME, batchRuntimeConfiguration.getDataSourceLookupName());
        map.put(EXECUTOR_SERVICE_NAME, batchRuntimeConfiguration.getExecutorServiceLookupName());
        extraProps.put("listBatchRuntimeConfiguration", map);
        ColumnFormatter columnFormatter = new ColumnFormatter(this.getDisplayHeaders());
        Object[] data = new Object[this.getOutputHeaders().length];
        block8: for (int index = 0; index < this.getOutputHeaders().length; ++index) {
            switch (this.getOutputHeaders()[index]) {
                case "dataSourceLookupName": {
                    String val = batchRuntimeConfiguration.getDataSourceLookupName();
                    data[index] = val == null || val.trim().length() == 0 ? BatchRuntimeHelper.getDefaultDataSourceLookupNameForTarget((String)this.target) : val;
                    continue block8;
                }
                case "executorServiceLookupName": {
                    data[index] = batchRuntimeConfiguration.getExecutorServiceLookupName();
                    continue block8;
                }
                default: {
                    throw new IllegalArgumentException("Unknown header: " + this.getOutputHeaders()[index]);
                }
            }
        }
        columnFormatter.addRow(data);
        context.getActionReport().setMessage(columnFormatter.toString());
    }

    @Override
    protected final String[] getAllHeaders() {
        return new String[]{DATA_SOURCE_NAME, EXECUTOR_SERVICE_NAME};
    }

    @Override
    protected final String[] getDefaultHeaders() {
        return this.getAllHeaders();
    }
}

