/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdo.spi.persistence.generator.database;

import com.sun.jdo.spi.persistence.generator.database.DDLTemplateFormatter;
import com.sun.jdo.spi.persistence.generator.database.DatabaseOutputStream;
import com.sun.jdo.spi.persistence.generator.database.MappingPolicy;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.netbeans.modules.dbschema.ColumnElement;
import org.netbeans.modules.dbschema.DBException;
import org.netbeans.modules.dbschema.ForeignKeyElement;
import org.netbeans.modules.dbschema.SchemaElement;
import org.netbeans.modules.dbschema.TableElement;
import org.netbeans.modules.dbschema.UniqueKeyElement;

public class DDLGenerator {
    private static final char SPACE = ' ';
    private static final char START = '(';
    private static final char END = ')';
    private static final String COLUMN_SEPARATOR = ", ";
    private static final String NOT_NULL_STRING = "NOT NULL";
    private static final String NULL_STRING = "NULL";

    public static void generateDDL(SchemaElement schema, String dbVendorName, OutputStream createDDLSql, OutputStream dropDDLSql, OutputStream dropDDLJdbc, OutputStream createDDLJdbc, OutputStream dbStream, boolean dropAndCreateTbl) throws DBException, SQLException, IOException {
        if (schema != null) {
            MappingPolicy mappingPolicy = MappingPolicy.getMappingPolicy(dbVendorName);
            DDLTemplateFormatter.reset(mappingPolicy);
            String schemaName = schema.getName().getName();
            ArrayList<String[]> createAllTblDDL = new ArrayList<String[]>();
            ArrayList<String> createIndexDDL = new ArrayList<String>();
            ArrayList alterAddConstraintsDDL = new ArrayList();
            ArrayList alterDropConstraintsDDL = new ArrayList();
            ArrayList<String> dropAllTblDDL = new ArrayList<String>();
            TableElement[] tables = schema.getTables();
            if (tables != null) {
                for (int ii = 0; ii < tables.length; ++ii) {
                    TableElement table = tables[ii];
                    createAllTblDDL.add(DDLGenerator.createCreateTableDDL(table, mappingPolicy));
                    if (table.getPrimaryKey() != null) {
                        createIndexDDL.add(DDLGenerator.createIndexDDL(table));
                    }
                    alterAddConstraintsDDL.addAll(DDLGenerator.createAddConstraintsDDL(table));
                    alterDropConstraintsDDL.addAll(DDLGenerator.createDropConstraintsDDL(table));
                    dropAllTblDDL.add(DDLGenerator.createDropTableDDL(table));
                }
            }
            String stmtSeparator = mappingPolicy.getStatementSeparator();
            DDLGenerator.generateSQL(createDDLSql, dropDDLSql, dropDDLJdbc, createDDLJdbc, (DatabaseOutputStream)dbStream, createAllTblDDL, createIndexDDL, alterAddConstraintsDDL, alterDropConstraintsDDL, dropAllTblDDL, stmtSeparator, dropAndCreateTbl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void generateSQL(OutputStream createSql, OutputStream dropSql, OutputStream dropTxt, OutputStream createTxt, DatabaseOutputStream dbStream, List createAllTblDDL, List createIndexDDL, List alterAddConstraintsDDL, List alterDropConstraintsDDL, List dropAllTblDDL, String stmtSeparator, boolean dropAndCreateTbl) throws DBException, SQLException {
        PrintStream workStream = null;
        PrintStream txtStream = null;
        try {
            String stmt;
            int i;
            workStream = new PrintStream(dropSql);
            if (dropTxt != null) {
                txtStream = new PrintStream(dropTxt);
            }
            for (i = 0; i < alterDropConstraintsDDL.size(); ++i) {
                String dropConstStmt = (String)alterDropConstraintsDDL.get(i);
                DDLGenerator.writeDDL(workStream, txtStream, stmtSeparator, dropConstStmt);
                if (dbStream == null || !dropAndCreateTbl) continue;
                dbStream.write(dropConstStmt);
            }
            for (i = 0; i < dropAllTblDDL.size(); ++i) {
                String dropTblStmt = (String)dropAllTblDDL.get(i);
                DDLGenerator.writeDDL(workStream, txtStream, stmtSeparator, dropTblStmt);
                if (dbStream == null || !dropAndCreateTbl) continue;
                dbStream.write(dropTblStmt);
            }
            workStream.close();
            if (txtStream != null) {
                txtStream.close();
            }
            workStream = new PrintStream(createSql);
            if (createTxt != null) {
                txtStream = new PrintStream(createTxt);
            }
            for (i = 0; i < createAllTblDDL.size(); ++i) {
                StringBuffer createStmt = new StringBuffer();
                String[] createTbl = (String[])createAllTblDDL.get(i);
                for (int j = 0; j < createTbl.length; ++j) {
                    workStream.println(createTbl[j]);
                    createStmt.append(createTbl[j]);
                }
                workStream.println(stmtSeparator);
                if (txtStream != null) {
                    txtStream.println(createStmt);
                }
                if (dbStream == null) continue;
                dbStream.write(createStmt.toString());
            }
            for (i = 0; i < createIndexDDL.size(); ++i) {
                stmt = (String)createIndexDDL.get(i);
                DDLGenerator.writeDDL(workStream, txtStream, stmtSeparator, stmt);
                if (dbStream == null) continue;
                dbStream.write(stmt);
            }
            for (i = 0; i < alterAddConstraintsDDL.size(); ++i) {
                stmt = (String)alterAddConstraintsDDL.get(i);
                DDLGenerator.writeDDL(workStream, txtStream, stmtSeparator, stmt);
                if (dbStream == null) continue;
                dbStream.write(stmt);
            }
            workStream.close();
            if (txtStream != null) {
                txtStream.close();
            }
            if (dbStream != null) {
                dbStream.flush();
            }
        }
        finally {
            if (workStream != null) {
                workStream.close();
            }
            if (txtStream != null) {
                txtStream.close();
            }
        }
    }

    private static void writeDDL(PrintStream sql, PrintStream txt, String stmtSeparator, String stmt) {
        if (stmt == null || stmt.trim().length() == 0) {
            return;
        }
        sql.println(stmt);
        sql.println(stmtSeparator);
        if (txt != null) {
            txt.println(stmt);
        }
    }

    private static String[] createCreateTableDDL(TableElement table, MappingPolicy mappingPolicy) {
        ArrayList<String> createTblList = new ArrayList<String>();
        String[] oneParam = new String[]{table.getName().getName()};
        createTblList.add(DDLTemplateFormatter.formatCreateTable(oneParam));
        ColumnElement[] columns = table.getColumns();
        String constraint = DDLGenerator.createPrimaryKeyConstraint(table);
        int size = columns.length;
        for (int i = 0; i < size; ++i) {
            StringBuffer columnContent = new StringBuffer();
            columnContent.append(DDLGenerator.getColumnDef(columns[i], mappingPolicy));
            if (i < size - 1 || i == size - 1 && constraint != null) {
                columnContent.append(COLUMN_SEPARATOR);
            }
            createTblList.add(columnContent.toString());
        }
        if (constraint != null) {
            createTblList.add(constraint);
        }
        createTblList.add(mappingPolicy.getCreateTableEnd());
        return createTblList.toArray(new String[createTblList.size()]);
    }

    private static String createIndexDDL(TableElement table) {
        String[] twoParam = new String[]{table.getName().getName(), DDLGenerator.getColumnNames(table.getPrimaryKey().getColumns())};
        return DDLTemplateFormatter.formatCreateIndex(twoParam);
    }

    private static String createDropTableDDL(TableElement table) {
        String[] oneParam = new String[]{table.getName().getName()};
        return DDLTemplateFormatter.formatDropTable(oneParam);
    }

    private static String createPrimaryKeyConstraint(TableElement table) {
        String rc = null;
        UniqueKeyElement pk = table.getPrimaryKey();
        if (pk != null) {
            String[] twoParams = new String[]{pk.getName().getName(), DDLGenerator.getColumnNames(pk.getColumns())};
            rc = DDLTemplateFormatter.formatPKConstraint(twoParams);
        }
        return rc;
    }

    private static List createAddConstraintsDDL(TableElement table) {
        ArrayList<String> alterTblDDL = new ArrayList<String>();
        String[] fourParams = new String[4];
        String[] oneParam = new String[]{table.getName().getName()};
        ForeignKeyElement[] fkeys = table.getForeignKeys();
        if (fkeys != null) {
            String alterTblString = DDLTemplateFormatter.formatAlterTableAddConstraint(oneParam);
            for (int jj = 0; jj < fkeys.length; ++jj) {
                ForeignKeyElement fkey = fkeys[jj];
                fourParams[0] = fkey.getName().getName();
                fourParams[1] = DDLGenerator.getColumnNames(fkey.getLocalColumns());
                fourParams[2] = fkey.getReferencedTable().getName().getName();
                fourParams[3] = DDLGenerator.getColumnNames(fkey.getReferencedColumns());
                StringBuffer alterTblDDLString = new StringBuffer(alterTblString);
                alterTblDDLString.append(' ');
                alterTblDDLString.append(DDLTemplateFormatter.formatFKConstraint(fourParams));
                alterTblDDL.add(alterTblDDLString.toString());
            }
        }
        return alterTblDDL;
    }

    private static List createDropConstraintsDDL(TableElement table) {
        ArrayList<String> alterTbls = new ArrayList<String>();
        String[] twoParams = new String[2];
        twoParams[0] = table.getName().getName();
        ForeignKeyElement[] fkeys = table.getForeignKeys();
        if (fkeys != null) {
            for (int i = 0; i < fkeys.length; ++i) {
                twoParams[1] = fkeys[i].getName().getName();
                String alterTblString = DDLTemplateFormatter.formatAlterTableDropConstraint(twoParams);
                alterTbls.add(alterTblString);
            }
        }
        return alterTbls;
    }

    private static String getColumnDef(ColumnElement column, MappingPolicy mappingPolicy) {
        String lobText;
        int jdbcType = column.getType();
        Integer scale = column.getScale();
        Integer precision = column.getPrecision();
        Integer length = column.getLength();
        String sqlType = mappingPolicy.getSQLTypeName(jdbcType);
        StringBuffer columnContent = new StringBuffer();
        columnContent.append(column.getName().getName());
        columnContent.append(' ');
        columnContent.append(sqlType);
        if (column.isCharacterType() && length != null) {
            columnContent.append('(');
            columnContent.append(length.toString());
            columnContent.append(')');
        } else if (column.isNumericType() && precision != null) {
            columnContent.append('(');
            columnContent.append(precision.toString());
            if (scale != null) {
                columnContent.append(COLUMN_SEPARATOR);
                columnContent.append(scale.toString());
            }
            columnContent.append(')');
        } else if (column.isBlobType() && length != null) {
            columnContent.append('(');
            columnContent.append(length.toString());
            columnContent.append(')');
        }
        if ((jdbcType == 2004 || jdbcType == 2005) && (lobText = mappingPolicy.getLobLogging()) != null && lobText.length() > 0) {
            columnContent.append(' ').append(lobText);
        }
        if (column.isNullable()) {
            String nullText = mappingPolicy.getColumnNullability();
            if (nullText != null && nullText.length() > 0) {
                columnContent.append(' ').append(nullText);
            }
        } else {
            columnContent.append(' ').append(NOT_NULL_STRING);
        }
        return columnContent.toString();
    }

    private static String getColumnNames(ColumnElement[] columns) {
        StringBuffer columnNames = new StringBuffer();
        for (int i = 0; i < columns.length; ++i) {
            if (i > 0) {
                columnNames.append(COLUMN_SEPARATOR);
            }
            columnNames.append(columns[i].getName().getName());
        }
        return columnNames.toString();
    }
}

