/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.parsing;

import org.eclipse.persistence.internal.jpa.parsing.GenerationContext;
import org.eclipse.persistence.internal.jpa.parsing.ParseTree;
import org.eclipse.persistence.internal.jpa.parsing.SelectGenerationContext;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.DeleteAllQuery;
import org.eclipse.persistence.queries.ModifyAllQuery;
import org.eclipse.persistence.queries.ObjectLevelReadQuery;
import org.eclipse.persistence.queries.ReadQuery;
import org.eclipse.persistence.queries.UpdateAllQuery;

public class JPQLParseTree
extends ParseTree {
    public GenerationContext buildContext(ReadQuery readQuery, AbstractSession session) {
        GenerationContext contextForGeneration = super.buildContext(readQuery, session);
        contextForGeneration.setBaseQueryClass(readQuery.getReferenceClass());
        return contextForGeneration;
    }

    private GenerationContext buildSubqueryContext(ReadQuery readQuery, GenerationContext outer) {
        SelectGenerationContext context = new SelectGenerationContext(outer, this);
        context.setBaseQueryClass(readQuery.getReferenceClass());
        return context;
    }

    public GenerationContext populateSubquery(ObjectLevelReadQuery readQuery, GenerationContext outer) {
        GenerationContext innerContext = this.buildSubqueryContext(readQuery, outer);
        this.populateReadQueryInternal(readQuery, innerContext);
        return innerContext;
    }

    public void populateQuery(DatabaseQuery query, AbstractSession session) {
        if (query.isObjectLevelReadQuery()) {
            ObjectLevelReadQuery objectQuery = (ObjectLevelReadQuery)query;
            GenerationContext generationContext = this.buildContext(objectQuery, session);
            this.populateReadQueryInternal(objectQuery, generationContext);
        } else if (query.isUpdateAllQuery()) {
            UpdateAllQuery updateQuery = (UpdateAllQuery)query;
            GenerationContext generationContext = this.buildContext(updateQuery, session);
            this.populateModifyQueryInternal(updateQuery, generationContext);
            this.addUpdatesToQuery(updateQuery, generationContext);
        } else if (query.isDeleteAllQuery()) {
            DeleteAllQuery deleteQuery = (DeleteAllQuery)query;
            GenerationContext generationContext = this.buildContext(deleteQuery, session);
            this.populateModifyQueryInternal(deleteQuery, generationContext);
        }
    }

    private void populateReadQueryInternal(ObjectLevelReadQuery objectQuery, GenerationContext generationContext) {
        if (objectQuery.getReferenceClass() == null) {
            this.adjustReferenceClassForQuery(objectQuery, generationContext);
        }
        this.initBaseExpression(objectQuery, generationContext);
        this.validate(generationContext.getSession(), this.getClassLoader());
        this.applyQueryNodeToQuery(objectQuery, generationContext);
        this.verifySelect(objectQuery, generationContext);
        this.setSelectionCriteriaForQuery(objectQuery, generationContext);
        this.addOrderingToQuery(objectQuery, generationContext);
        this.addGroupingToQuery(objectQuery, generationContext);
        this.addHavingToQuery(objectQuery, generationContext);
        this.addNonFetchJoinAttributes(objectQuery, generationContext);
    }

    private void populateModifyQueryInternal(ModifyAllQuery query, GenerationContext generationContext) {
        if (query.getReferenceClass() == null) {
            this.adjustReferenceClassForQuery(query, generationContext);
        }
        query.setSession(generationContext.getSession());
        this.initBaseExpression(query, generationContext);
        this.validate(generationContext.getSession(), this.getClassLoader());
        this.applyQueryNodeToQuery(query, generationContext);
        this.setSelectionCriteriaForQuery(query, generationContext);
    }
}

