/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.internal;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.ws.rs.RuntimeType;
import org.glassfish.jersey.CommonProperties;
import org.glassfish.jersey.internal.BootstrapConfigurator;
import org.glassfish.jersey.internal.ServiceFinder;

public abstract class AbstractServiceFinderConfigurator<T>
implements BootstrapConfigurator {
    private final Class<T> contract;
    private final RuntimeType runtimeType;

    protected AbstractServiceFinderConfigurator(Class<T> contract, RuntimeType runtimeType) {
        this.contract = contract;
        this.runtimeType = runtimeType;
    }

    protected List<Class<T>> loadImplementations(Map<String, Object> applicationProperties) {
        boolean METAINF_SERVICES_LOOKUP_DISABLE_DEFAULT;
        boolean disableMetaInfServicesLookup = METAINF_SERVICES_LOOKUP_DISABLE_DEFAULT = false;
        if (applicationProperties != null) {
            disableMetaInfServicesLookup = CommonProperties.getValue(applicationProperties, this.runtimeType, "jersey.config.disableMetainfServicesLookup", METAINF_SERVICES_LOOKUP_DISABLE_DEFAULT, Boolean.class);
        }
        if (!disableMetaInfServicesLookup) {
            return Stream.of(ServiceFinder.find(this.contract, true).toClassArray()).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }
}

