/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.extras.addons;

import java.io.IOException;
import java.lang.annotation.Annotation;
import org.glassfish.grizzly.config.ConfigAwareElement;
import org.glassfish.grizzly.config.dom.Http;
import org.glassfish.grizzly.config.dom.NetworkListener;
import org.glassfish.grizzly.filterchain.FilterChainContext;
import org.glassfish.grizzly.http.HttpContent;
import org.glassfish.grizzly.http.server.AddOn;
import org.glassfish.grizzly.http.server.util.Mapper;
import org.glassfish.grizzly.websockets.WebSocketAddOn;
import org.glassfish.grizzly.websockets.WebSocketEngine;
import org.glassfish.grizzly.websockets.WebSocketFilter;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.internal.grizzly.ContextMapper;
import org.jvnet.hk2.annotations.ContractsProvided;
import org.jvnet.hk2.annotations.Service;

@Service(name="websocket")
@ContractsProvided(value={WebSocketAddOnProvider.class, AddOn.class})
public class WebSocketAddOnProvider
extends WebSocketAddOn
implements ConfigAwareElement<Http> {
    private Mapper mapper;

    public void configure(ServiceLocator habitat, NetworkListener networkListener, Http configuration) {
        this.mapper = WebSocketAddOnProvider.getMapper(habitat, networkListener);
        this.setTimeoutInSeconds(Long.parseLong(configuration.getWebsocketsTimeoutSeconds()));
    }

    @Override
    protected WebSocketFilter createWebSocketFilter() {
        return new GlassfishWebSocketFilter(this.mapper, this.getTimeoutInSeconds());
    }

    private static Mapper getMapper(ServiceLocator habitat, NetworkListener listener) {
        int port;
        try {
            port = Integer.parseInt(listener.getPort());
        }
        catch (NumberFormatException e) {
            throw new IllegalStateException("Port number is not integer");
        }
        for (Mapper m : habitat.getAllServices(Mapper.class, new Annotation[0])) {
            if (m.getPort() != port || !(m instanceof ContextMapper)) continue;
            ContextMapper cm = (ContextMapper)m;
            if (!listener.getName().equals(cm.getId())) continue;
            return m;
        }
        return null;
    }

    private static class GlassfishWebSocketFilter
    extends WebSocketFilter {
        private final Mapper mapper;

        public GlassfishWebSocketFilter(Mapper mapper, long wsTimeoutInSeconds) {
            super(wsTimeoutInSeconds);
            this.mapper = mapper;
        }

        @Override
        protected boolean doServerUpgrade(FilterChainContext ctx, HttpContent requestContent) throws IOException {
            return !WebSocketEngine.getEngine().upgrade(ctx, requestContent, this.mapper);
        }
    }
}

