/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.webservices.transport.tcp;

import java.io.UnsupportedEncodingException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.grizzly.Buffer;
import org.glassfish.grizzly.filterchain.FilterChainContext;
import org.glassfish.grizzly.portunif.PUContext;
import org.glassfish.grizzly.portunif.ProtocolFinder;
import org.glassfish.webservices.transport.tcp.LogUtils;

public class WSTCPProtocolFinder
implements ProtocolFinder {
    private static final Logger LOGGER;
    private static final byte[] PROTOCOL_SCHEMA_BYTES;

    public ProtocolFinder.Result find(PUContext puContext, FilterChainContext filterChainContext) {
        Buffer buffer = (Buffer)filterChainContext.getMessage();
        if (buffer.remaining() < PROTOCOL_SCHEMA_BYTES.length) {
            return ProtocolFinder.Result.NEED_MORE_DATA;
        }
        int pos = buffer.position();
        for (int i = 0; i < PROTOCOL_SCHEMA_BYTES.length; ++i) {
            if (buffer.get(pos + i) == PROTOCOL_SCHEMA_BYTES[i]) continue;
            return ProtocolFinder.Result.NOT_FOUND;
        }
        return ProtocolFinder.Result.FOUND;
    }

    static {
        byte[] bytes;
        LOGGER = LogUtils.getLogger();
        try {
            bytes = "vnd.sun.ws.tcp".getBytes("US-ASCII");
        }
        catch (UnsupportedEncodingException e) {
            LOGGER.log(Level.WARNING, "AS-WSSOAPTCP-00002", e);
            bytes = "vnd.sun.ws.tcp".getBytes();
        }
        PROTOCOL_SCHEMA_BYTES = bytes;
    }
}

