/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.amx.impl.mbean;

import com.sun.appserv.server.util.Version;
import com.sun.enterprise.universal.Duration;
import com.sun.enterprise.universal.io.SmartFile;
import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.glassfish.admin.amx.base.BulkAccess;
import org.glassfish.admin.amx.base.DomainRoot;
import org.glassfish.admin.amx.base.Ext;
import org.glassfish.admin.amx.base.Pathnames;
import org.glassfish.admin.amx.base.Query;
import org.glassfish.admin.amx.base.Realms;
import org.glassfish.admin.amx.base.RuntimeRoot;
import org.glassfish.admin.amx.base.Sample;
import org.glassfish.admin.amx.base.Tools;
import org.glassfish.admin.amx.core.AMXValidator;
import org.glassfish.admin.amx.impl.mbean.AMXImplBase;
import org.glassfish.admin.amx.impl.mbean.BulkAccessImpl;
import org.glassfish.admin.amx.impl.mbean.ComplianceMonitor;
import org.glassfish.admin.amx.impl.mbean.ExtImpl;
import org.glassfish.admin.amx.impl.mbean.LoggingImpl;
import org.glassfish.admin.amx.impl.mbean.MonitoringRootImpl;
import org.glassfish.admin.amx.impl.mbean.PathnamesImpl;
import org.glassfish.admin.amx.impl.mbean.QueryMgrImpl;
import org.glassfish.admin.amx.impl.mbean.RealmsImpl;
import org.glassfish.admin.amx.impl.mbean.RuntimeRootImpl;
import org.glassfish.admin.amx.impl.mbean.SampleImpl;
import org.glassfish.admin.amx.impl.mbean.ToolsImpl;
import org.glassfish.admin.amx.impl.util.InjectedValues;
import org.glassfish.admin.amx.impl.util.Issues;
import org.glassfish.admin.amx.impl.util.ObjectNameBuilder;
import org.glassfish.admin.amx.logging.Logging;
import org.glassfish.admin.amx.monitoring.MonitoringRoot;
import org.glassfish.admin.amx.util.AMXLoggerInfo;
import org.glassfish.admin.amx.util.CollectionUtil;
import org.glassfish.admin.amx.util.FeatureAvailability;
import org.glassfish.admin.amx.util.MapUtil;
import org.glassfish.admin.amx.util.jmx.JMXUtil;
import org.glassfish.server.ServerEnvironmentImpl;

public class DomainRootImpl
extends AMXImplBase {
    private final String mAppserverDomainName;
    private final File mInstanceRoot = new File(System.getProperty("com.sun.aas.instanceRoot"));
    private volatile ComplianceMonitor mCompliance = null;
    private static final Logger logger = AMXLoggerInfo.getLogger();

    public DomainRootImpl() {
        super(null, DomainRoot.class);
        this.mAppserverDomainName = this.mInstanceRoot.getName();
    }

    public void stopDomain() {
        this.getDomainRootProxy().getRuntime().stopDomain();
    }

    public ObjectName getQueryMgr() {
        return this.child(Query.class);
    }

    public ObjectName getJ2EEDomain() {
        return this.child("J2EEDomain");
    }

    public ObjectName getMonitoringRoot() {
        return this.child(MonitoringRoot.class);
    }

    public ObjectName getPathnames() {
        return this.child(Pathnames.class);
    }

    public ObjectName getBulkAccess() {
        return this.child(BulkAccess.class);
    }

    @Override
    protected ObjectName preRegisterHook(MBeanServer server, ObjectName selfObjectName) throws Exception {
        Set<ObjectName> existing = JMXUtil.queryAllInDomain(server, selfObjectName.getDomain());
        if (existing.size() != 0) {
            logger.log(Level.INFO, "NCLS-COM-00032", CollectionUtil.toString(existing, ", "));
        }
        return selfObjectName;
    }

    @Override
    public void preRegisterDone() throws Exception {
        super.preRegisterDone();
    }

    @Override
    protected void postRegisterHook(Boolean registrationSucceeded) {
        super.postRegisterHook(registrationSucceeded);
        if (registrationSucceeded.booleanValue()) {
            this.mCompliance = ComplianceMonitor.getInstance(this.getDomainRootProxy());
            this.mCompliance.start();
        }
    }

    public Map<ObjectName, List<String>> getComplianceFailures() {
        Map<ObjectName, List<String>> result = MapUtil.newMap();
        if (this.mCompliance == null) {
            return result;
        }
        Map<ObjectName, AMXValidator.ProblemList> failures = this.mCompliance.getComplianceFailures();
        for (Map.Entry<ObjectName, AMXValidator.ProblemList> me : failures.entrySet()) {
            result.put(me.getKey(), me.getValue().getProblems());
        }
        return result;
    }

    public String getAppserverDomainName() {
        return this.mAppserverDomainName;
    }

    @Override
    protected final void registerChildren() {
        super.registerChildren();
        ObjectName self = this.getObjectName();
        ObjectNameBuilder objectNames = new ObjectNameBuilder(this.getMBeanServer(), self);
        ObjectName childObjectName = null;
        AMXImplBase mbean = null;
        MBeanServer server = this.getMBeanServer();
        childObjectName = objectNames.buildChildObjectName(Pathnames.class);
        mbean = new PathnamesImpl(self);
        this.registerChild(mbean, childObjectName);
        childObjectName = objectNames.buildChildObjectName(Query.class);
        mbean = new QueryMgrImpl(self);
        this.registerChild(mbean, childObjectName);
        childObjectName = objectNames.buildChildObjectName(Logging.class);
        mbean = new LoggingImpl(self, "server");
        this.registerChild(mbean, childObjectName);
        childObjectName = objectNames.buildChildObjectName(Tools.class);
        mbean = new ToolsImpl(self);
        this.registerChild(mbean, childObjectName);
        childObjectName = objectNames.buildChildObjectName(BulkAccess.class);
        mbean = new BulkAccessImpl(self);
        this.registerChild(mbean, childObjectName);
        childObjectName = objectNames.buildChildObjectName(Sample.class);
        mbean = new SampleImpl(self);
        this.registerChild(mbean, childObjectName);
        childObjectName = objectNames.buildChildObjectName(RuntimeRoot.class);
        mbean = new RuntimeRootImpl(self);
        this.registerChild(mbean, childObjectName);
        ObjectName extObjectName = childObjectName = objectNames.buildChildObjectName(Ext.class);
        mbean = new ExtImpl(self);
        this.registerChild(mbean, childObjectName);
        childObjectName = ObjectNameBuilder.buildChildObjectName(server, extObjectName, Realms.class);
        mbean = new RealmsImpl(extObjectName);
        this.registerChild(mbean, childObjectName);
        childObjectName = objectNames.buildChildObjectName(MonitoringRoot.class);
        mbean = new MonitoringRootImpl(self);
        this.registerChild(mbean, childObjectName);
    }

    public boolean getAMXReady() {
        this.waitAMXReady();
        return true;
    }

    public void waitAMXReady() {
        FeatureAvailability.getInstance().waitForFeature("AMXReady", this.getClass().getName());
    }

    public String getDebugPort() {
        Issues.getAMXIssues().notDone("DomainRootImpl.getDebugPort");
        return "9999";
    }

    public String getApplicationServerFullVersion() {
        return Version.getFullVersion();
    }

    public String getInstanceRoot() {
        return SmartFile.sanitize((String)("" + System.getProperty("com.sun.aas.instanceRoot")));
    }

    public String getDomainDir() {
        return SmartFile.sanitize((String)this.mInstanceRoot.toString());
    }

    public String getConfigDir() {
        return this.getDomainDir() + "/config";
    }

    public String getInstallDir() {
        return SmartFile.sanitize((String)("" + System.getProperty("com.sun.aas.installRoot")));
    }

    public Object[] getUptimeMillis() {
        ServerEnvironmentImpl env = InjectedValues.getInstance().getServerEnvironment();
        long elapsed = System.currentTimeMillis() - env.getStartupContext().getCreationTime();
        Duration duration = new Duration(elapsed);
        return new Object[]{elapsed, duration.toString()};
    }
}

