/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.transport.tcp.server.tomcat.grizzly10;

import com.sun.enterprise.web.connector.grizzly.OutputWriter;
import com.sun.enterprise.web.connector.grizzly.ssl.SSLOutputWriter;
import com.sun.enterprise.web.connector.grizzly.ssl.SSLSelectorThread;
import com.sun.enterprise.web.portunif.util.ProtocolInfo;
import java.io.IOException;
import java.net.InetAddress;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.SSLEngine;
import org.apache.tomcat.util.buf.Ascii;

public class HttpRedirector {
    private static final String NEWLINE = "\r\n";
    private final int redirectPort;
    private static String ipAddress = "127.0.0.1";
    private static final String headers = "\r\nConnection:close\r\nCache-control: private\r\n\r\n";
    private static final ByteBuffer SC_FOUND;

    public HttpRedirector(int redirectPort) {
        this.redirectPort = redirectPort;
    }

    public final void redirectSSL(ProtocolInfo protocolInfo) throws IOException {
        String host = this.replacePort(this.parseHost(protocolInfo.byteBuffer));
        if (host == null) {
            host = ipAddress + ":" + this.redirectPort;
        }
        this.redirectSSL(protocolInfo, protocolInfo.isRequestedTransportSecure ? new String("Location: https://" + host) : new String("Location: http://" + host));
    }

    private final void redirectSSL(ProtocolInfo protocolInfo, String httpHeaders) throws IOException {
        SSLOutputWriter.flushChannel((SocketChannel)protocolInfo.socketChannel, (ByteBuffer)SC_FOUND.slice(), (ByteBuffer)protocolInfo.outputBB, (SSLEngine)protocolInfo.sslEngine);
        SSLOutputWriter.flushChannel((SocketChannel)protocolInfo.socketChannel, (ByteBuffer)ByteBuffer.wrap((httpHeaders + protocolInfo.requestURI + headers).getBytes()), (ByteBuffer)protocolInfo.outputBB, (SSLEngine)protocolInfo.sslEngine);
    }

    public final void redirect(ProtocolInfo protocolInfo) throws IOException {
        String host = this.replacePort(this.parseHost(protocolInfo.byteBuffer));
        if (host == null) {
            host = ipAddress + ":" + protocolInfo.socketChannel.socket().getLocalPort();
        }
        this.redirect(protocolInfo, protocolInfo.isRequestedTransportSecure ? new String("Location: https://" + host) : new String("Location: http://" + host));
    }

    private final void redirect(ProtocolInfo protocolInfo, String httpHeaders) throws IOException {
        OutputWriter.flushChannel((SocketChannel)protocolInfo.socketChannel, (ByteBuffer)SC_FOUND.slice());
        OutputWriter.flushChannel((SocketChannel)protocolInfo.socketChannel, (ByteBuffer)ByteBuffer.wrap((httpHeaders + protocolInfo.requestURI + headers).getBytes()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String parseHost(ByteBuffer byteBuffer) {
        boolean isFound = false;
        int curPosition = byteBuffer.position();
        int curLimit = byteBuffer.limit();
        if (byteBuffer.position() == 0) {
            return ipAddress;
        }
        byteBuffer.position(0);
        byteBuffer.limit(curPosition);
        int state = 0;
        int start = 0;
        int end = 0;
        try {
            block14: while (byteBuffer.hasRemaining()) {
                byte c = (byte)Ascii.toLower((int)byteBuffer.get());
                switch (state) {
                    case 0: {
                        if (c == 104) {
                            state = 1;
                            continue block14;
                        }
                        state = 0;
                        continue block14;
                    }
                    case 1: {
                        if (c == 111) {
                            state = 2;
                            continue block14;
                        }
                        state = 0;
                        continue block14;
                    }
                    case 2: {
                        if (c == 115) {
                            state = 3;
                            continue block14;
                        }
                        state = 0;
                        continue block14;
                    }
                    case 3: {
                        if (c == 116) {
                            state = 4;
                            continue block14;
                        }
                        state = 0;
                        continue block14;
                    }
                    case 4: {
                        if (c == 58) {
                            state = 5;
                            continue block14;
                        }
                        state = 0;
                        continue block14;
                    }
                    case 5: {
                        StringBuilder sb = new StringBuilder();
                        while (c != 13 && c != 10) {
                            sb.append((char)c);
                            c = byteBuffer.get();
                        }
                        String string2 = sb.toString().trim();
                        return string2;
                    }
                }
                throw new IllegalArgumentException("Unexpected state");
            }
            String string3 = null;
            return string3;
        }
        catch (BufferUnderflowException bue) {
            String string4 = null;
            return string4;
        }
        finally {
            if (end > 0) {
                byteBuffer.position(start);
                byteBuffer.limit(end);
            } else {
                byteBuffer.limit(curLimit);
                byteBuffer.position(curPosition);
            }
        }
    }

    private void log(Throwable ex) {
        Logger logger = SSLSelectorThread.logger();
        if (logger.isLoggable(Level.WARNING)) {
            logger.log(Level.WARNING, "Redirector", ex);
        }
    }

    private String replacePort(String host) {
        int delim = host.indexOf(58);
        if (delim != -1) {
            return host.substring(0, delim + 1) + this.redirectPort;
        }
        return host + ':' + this.redirectPort;
    }

    static {
        try {
            ipAddress = InetAddress.getLocalHost().getHostName();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        SC_FOUND = ByteBuffer.wrap("HTTP/1.1 302 Moved Temporarily\r\n".getBytes());
    }
}

