/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ejb.base.io;

import com.sun.enterprise.container.common.spi.util.GlassFishInputStreamHandler;
import com.sun.enterprise.container.common.spi.util.SerializableObjectFactory;
import com.sun.logging.LogDomains;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.rmi.Remote;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.enterprise.iiop.api.GlassFishORBHelper;
import org.glassfish.enterprise.iiop.api.ProtocolManager;
import org.glassfish.internal.api.Globals;

public class EJBObjectInputStreamHandler
implements GlassFishInputStreamHandler {
    private static final Logger _ejbLogger = LogDomains.getLogger(EJBObjectInputStreamHandler.class, (String)"javax.enterprise.system.container.ejb");

    public Object resolveObject(Object obj) throws IOException {
        ProtocolManager protocolMgr = this.getProtocolManager();
        try {
            if (protocolMgr != null && protocolMgr.isStub(obj)) {
                protocolMgr.connectObject((Remote)obj);
                return obj;
            }
            if (obj instanceof SerializableObjectFactory) {
                return ((SerializableObjectFactory)obj).createObject();
            }
            return obj;
        }
        catch (IOException ioEx) {
            _ejbLogger.log(Level.SEVERE, "ejb.resolve_object_exception", ioEx);
            throw ioEx;
        }
        catch (Exception ex) {
            _ejbLogger.log(Level.SEVERE, "ejb.resolve_object_exception", ex);
            IOException ioe = new IOException();
            ioe.initCause(ex);
            throw ioe;
        }
    }

    private ProtocolManager getProtocolManager() {
        GlassFishORBHelper orbHelper = (GlassFishORBHelper)Globals.getDefaultHabitat().getService(GlassFishORBHelper.class, new Annotation[0]);
        return orbHelper.isORBInitialized() ? orbHelper.getProtocolManager() : null;
    }
}

