/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.appclient.server.core.jws;

import java.util.HashMap;
import java.util.Map;

public class JavaWebStartState {
    private StateValue currentStateValue = StateValue.STOPPED;
    private final Map<StateValue, Map<Action, Transition>> validTransitions = this.initValidTransitions();

    public void transition(Action action, Runnable task) {
        Transition t = this.validTransitions.get((Object)this.currentStateValue).get((Object)action);
        if (t == null) {
            throw new IllegalStateException(this.currentStateValue.toString() + " : " + action.toString());
        }
        StateValue newStateValue = t.newStateValue;
        if (task != null && !t.isNOOP) {
            task.run();
        }
        this.currentStateValue = newStateValue;
    }

    public boolean isRunning() {
        return this.currentStateValue == StateValue.RUNNING;
    }

    public boolean isSuspended() {
        return this.currentStateValue == StateValue.SUSPENDED;
    }

    private Map<StateValue, Map<Action, Transition>> initValidTransitions() {
        HashMap<StateValue, Map<Action, Transition>> result = new HashMap<StateValue, Map<Action, Transition>>();
        this.addTransitionSet(result, StateValue.STOPPED, new Transition(Action.START, StateValue.RUNNING), new Transition(Action.STOP, StateValue.STOPPED, true));
        this.addTransitionSet(result, StateValue.RUNNING, new Transition(Action.STOP, StateValue.STOPPED), new Transition(Action.SUSPEND, StateValue.SUSPENDED));
        this.addTransitionSet(result, StateValue.SUSPENDED, new Transition(Action.RESUME, StateValue.RUNNING), new Transition(Action.SUSPEND, StateValue.SUSPENDED, true));
        return result;
    }

    private void addTransitionSet(Map<StateValue, Map<Action, Transition>> map, StateValue originalState, Transition ... transitions) {
        Map<Action, Transition> transitionsForState = map.get((Object)originalState);
        if (transitionsForState == null) {
            transitionsForState = new HashMap<Action, Transition>();
            map.put(originalState, transitionsForState);
        }
        for (Transition t : transitions) {
            transitionsForState.put(t.action, t);
        }
    }

    private static class Transition {
        final Action action;
        final StateValue newStateValue;
        final boolean isNOOP;

        Transition(Action action, StateValue newState) {
            this(action, newState, false);
        }

        Transition(Action action, StateValue newState, boolean isNOOP) {
            this.action = action;
            this.newStateValue = newState;
            this.isNOOP = isNOOP;
        }
    }

    public static enum Action {
        START,
        STOP,
        SUSPEND,
        RESUME;

    }

    private static enum StateValue {
        STOPPED,
        RUNNING,
        SUSPENDED;

    }
}

