/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.connectors.jms.system;

import com.sun.appserv.connectors.internal.api.ConnectorRuntimeException;
import com.sun.enterprise.config.serverbeans.Cluster;
import com.sun.enterprise.config.serverbeans.Clusters;
import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.Configs;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.Node;
import com.sun.enterprise.config.serverbeans.Nodes;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.config.serverbeans.Servers;
import com.sun.enterprise.connectors.jms.JMSLoggerInfo;
import com.sun.enterprise.connectors.jms.config.JmsHost;
import com.sun.enterprise.connectors.jms.config.JmsService;
import com.sun.enterprise.connectors.jms.system.JmsHostWrapper;
import com.sun.enterprise.connectors.jms.system.MQUrl;
import com.sun.enterprise.connectors.jms.util.JmsRaUtil;
import com.sun.enterprise.universal.glassfish.ASenvPropertyReader;
import com.sun.enterprise.util.StringUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.logging.LogHelper;
import org.glassfish.internal.api.Globals;
import org.glassfish.internal.api.ServerContext;

public class MQAddressList {
    private static final Logger logger = JMSLoggerInfo.getLogger();
    private String myName = System.getProperty("com.sun.aas.instanceName");
    private List<MQUrl> urlList = new ArrayList<MQUrl>();
    private JmsService jmsService = null;
    private static String nodeHost = null;
    private String targetName = null;
    String dasPropertiesHostName = null;
    Map<String, String> systemProps = null;

    public MQAddressList() {
        this(null);
    }

    public MQAddressList(JmsService service) {
        this(service, MQAddressList.getServerName());
    }

    public MQAddressList(JmsService service, String targetName) {
        if (logger.isLoggable(Level.FINE)) {
            this.logFine(" init" + service + "target " + targetName);
        }
        this.jmsService = service;
        this.targetName = targetName;
    }

    public void setJmsService(JmsService jmsService) {
        this.jmsService = jmsService;
    }

    public void setTargetName(String targetName) {
        this.targetName = targetName;
    }

    public void setInstanceName(String instanceName) {
        this.myName = instanceName;
    }

    public void setup() throws Exception {
        if (this.isClustered() && !this.jmsService.getType().equals("REMOTE")) {
            this.setup(true);
        } else {
            this.setup(false);
        }
    }

    public void setup(boolean isClustered) throws Exception {
        try {
            if (isClustered) {
                if (logger.isLoggable(Level.FINE)) {
                    this.logFine("setting up for cluster " + this.targetName);
                }
                this.setupClusterViewFromRepository();
                this.setupForCluster();
            } else {
                if (logger.isLoggable(Level.FINE)) {
                    this.logFine("setting up for SI/DAS " + this.targetName);
                }
                if (this.isAConfig(this.targetName) || this.isDAS(this.targetName)) {
                    if (logger.isLoggable(Level.FINE)) {
                        this.logFine("performing default setup for DAS/remote clusters/PE instance " + this.targetName);
                    }
                    this.defaultSetup();
                } else {
                    this.logFine("configuring for Standalone EE server instance");
                    this.setupClusterViewFromRepository();
                    this.setupForStandaloneServerInstance();
                }
            }
        }
        catch (ConnectorRuntimeException ce) {
            throw new Exception(ce);
        }
    }

    private void setupClusterViewFromRepository() throws Exception {
        block3: {
            ServerContext context = (ServerContext)Globals.get(ServerContext.class);
            Domain domain = (Domain)Globals.get(Domain.class);
            String serverName = context.getInstanceName();
            Server server = domain.getServerNamed(serverName);
            try {
                nodeHost = this.getNodeHostName(server);
                this.logFine("na host" + nodeHost);
            }
            catch (Exception e) {
                if (logger.isLoggable(Level.FINE)) {
                    logger.log(Level.FINE, "Exception while attempting to get nodeagentHost : " + e.getMessage());
                }
                if (!logger.isLoggable(Level.FINER)) break block3;
                logger.log(Level.FINER, e.getMessage(), e);
            }
        }
    }

    public String getNodeHostName(Server as) throws Exception {
        String nodeRef = as.getNodeRef();
        Nodes nodes = (Nodes)Globals.get(Nodes.class);
        Node node = nodes.getNode(nodeRef);
        if (node != null) {
            String hostName;
            if (node.getNodeHost() != null) {
                return node.getNodeHost();
            }
            if (node.isDefaultLocalNode() && "localhost".equals(hostName = this.getHostNameFromDasProperties())) {
                return System.getProperty("com.sun.aas.hostName");
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getHostNameFromDasProperties() {
        if (this.dasPropertiesHostName != null) {
            return this.dasPropertiesHostName;
        }
        String agentsDirPath = this.getSystemProperty("com.sun.aas.agentRoot");
        if (!StringUtils.ok((String)agentsDirPath)) {
            String installRootPath = this.getSystemProperty("com.sun.aas.installRoot");
            if (!StringUtils.ok((String)installRootPath)) {
                installRootPath = System.getProperty("com.sun.aas.installRoot");
            }
            agentsDirPath = installRootPath + File.separator + "nodes";
        }
        String dasPropsFilePath = agentsDirPath + File.separator + "agent" + File.separator + "config";
        File dasPropsFile = new File(dasPropsFilePath, "das.properties");
        Properties dasprops = new Properties();
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(dasPropsFile);
            dasprops.load(fis);
            fis.close();
            fis = null;
            String string = this.dasPropertiesHostName = dasprops.getProperty("agent.das.host");
            return string;
        }
        catch (IOException iOException) {
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException iOException) {}
            }
        }
        return null;
    }

    protected String getSystemProperty(String propertyName) {
        if (this.systemProps == null) {
            this.systemProps = Collections.unmodifiableMap(new ASenvPropertyReader().getProps());
        }
        return this.systemProps.get(propertyName);
    }

    public String getMasterBroker(String clustername) {
        String masterbrk = null;
        try {
            JmsHost mb = this.getMasterJmsHostInCluster(clustername);
            JmsService js = this.getJmsServiceForMasterBroker(clustername);
            MQUrl url = MQAddressList.createUrl(mb, js);
            masterbrk = url.toString();
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "Master broker obtained is " + masterbrk);
            }
        }
        catch (Exception e) {
            LogHelper.log((Logger)logger, (Level)Level.SEVERE, (String)"AS-JMS-CORE-00021", (Throwable)e, (Object[])new Object[0]);
        }
        return masterbrk;
    }

    private JmsService getJmsServiceForMasterBroker(String clusterName) {
        Domain domain = (Domain)Globals.get(Domain.class);
        Cluster cluster = domain.getClusterNamed(clusterName);
        Server[] buddies = this.getServersInCluster(cluster);
        Config cfg = this.getConfigForServer(buddies[0]);
        return (JmsService)cfg.getExtensionByType(JmsService.class);
    }

    private Config getConfigForServer(Server server) {
        String cfgRef = server.getConfigRef();
        return this.getConfigByName(cfgRef);
    }

    private Config getConfigByName(String cfgRef) {
        Domain domain = (Domain)Globals.get(Domain.class);
        Configs configs = domain.getConfigs();
        List configList = configs.getConfig();
        for (int i = 0; i < configList.size(); ++i) {
            Config config = (Config)configList.get(i);
            if (!config.getName().equals(cfgRef)) continue;
            return config;
        }
        return null;
    }

    private JmsHost getMasterJmsHostInCluster(String clusterName) throws Exception {
        Domain domain = (Domain)Globals.get(Domain.class);
        Cluster cluster = domain.getClusterNamed(clusterName);
        Config config = domain.getConfigNamed(cluster.getConfigRef());
        JmsService jmsService = (JmsService)config.getExtensionByType(JmsService.class);
        Server masterBrokerInstance = null;
        String masterBrokerInstanceName = jmsService.getMasterBroker();
        if (masterBrokerInstanceName != null) {
            masterBrokerInstance = domain.getServerNamed(masterBrokerInstanceName);
        } else {
            Server[] buddies = this.getServersInCluster(cluster);
            if (buddies.length > 0) {
                masterBrokerInstance = buddies[0];
            }
        }
        JmsHost copy = this.getResolvedJmsHost(masterBrokerInstance);
        if (copy != null) {
            return copy;
        }
        throw new RuntimeException("No JMS hosts available to select as Master");
    }

    public Cluster getClusterByName(String clusterName) {
        Domain domain = (Domain)Globals.get(Domain.class);
        Clusters clusters = domain.getClusters();
        List clusterList = clusters.getCluster();
        for (int i = 0; i < clusterList.size(); ++i) {
            Cluster cluster = (Cluster)clusterList.get(i);
            if (!cluster.getName().equals(clusterName)) continue;
            return cluster;
        }
        return null;
    }

    public Server[] getServersInCluster(String clusterName) {
        Cluster cluster = this.getClusterByName(clusterName);
        return this.getServersInCluster(cluster);
    }

    public Server[] getServersInCluster(Cluster cluster) {
        List servers = cluster.getInstances();
        Server[] result = new Server[servers.size()];
        for (int i = 0; i < servers.size(); ++i) {
            result[i] = (Server)servers.get(i);
        }
        return result;
    }

    public boolean isDAS(String targetName) {
        if (this.isAConfig(targetName)) {
            return false;
        }
        return this.getServerByName(targetName).isDas();
    }

    public boolean isAConfig(String targetName) {
        Config config = this.getConfigByName(targetName);
        return config != null;
    }

    private void setupForStandaloneServerInstance() throws Exception {
        if (this.jmsService.getType().equals("REMOTE")) {
            this.logFine("REMOTE Standalone server instance and hence use default setup");
            this.defaultSetup();
        } else {
            this.logFine("LOCAL/EMBEDDED Standalone server instance");
            JmsHost host = this.getResolvedJmsHostForStandaloneServerInstance(this.targetName);
            MQUrl url = this.createUrl(host);
            this.urlList.add(url);
        }
    }

    private void defaultSetup() throws Exception {
        this.logFine("performing defaultsetup");
        JmsService jmsService = (JmsService)Globals.get(JmsService.class);
        List hosts = jmsService.getJmsHost();
        for (int i = 0; i < hosts.size(); ++i) {
            MQUrl url = this.createUrl((JmsHost)hosts.get(i));
            this.urlList.add(url);
        }
    }

    private void setupForCluster() throws Exception {
        Map<String, JmsHost> hostMap = this.getResolvedLocalJmsHostsInMyCluster(true);
        JmsHost jmsHost = hostMap.get(this.myName);
        MQUrl myUrl = this.createUrl(jmsHost, nodeHost);
        this.urlList.add(myUrl);
        hostMap.remove(this.myName);
        for (JmsHost host : hostMap.values()) {
            MQUrl url = this.createUrl(host);
            this.urlList.add(url);
        }
    }

    public Map<String, JmsHost> getResolvedLocalJmsHostsInMyCluster(boolean includeMe) {
        HashMap<String, JmsHost> map = new HashMap<String, JmsHost>();
        Cluster cluster = this.getClusterForServer(this.myName);
        if (cluster != null) {
            Server[] buddies;
            for (Server as : buddies = this.getServersInCluster(cluster)) {
                if (!includeMe && this.myName.equals(as.getName())) continue;
                JmsHost copy = null;
                try {
                    copy = this.getResolvedJmsHost(as);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                map.put(as.getName(), copy);
            }
        }
        return map;
    }

    public Cluster getClusterForServer(String instanceName) {
        Domain domain = (Domain)Globals.get(Domain.class);
        Clusters clusters = domain.getClusters();
        List clusterList = clusters.getCluster();
        for (int i = 0; i < clusterList.size(); ++i) {
            Cluster cluster = (Cluster)clusterList.get(i);
            if (!this.isServerInCluster(cluster, instanceName)) continue;
            return cluster;
        }
        return null;
    }

    private boolean isServerInCluster(Cluster cluster, String instanceName) {
        List instances = cluster.getInstances();
        for (int i = 0; i < instances.size(); ++i) {
            if (!instanceName.equals(((Server)instances.get(i)).getName())) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        Iterator<MQUrl> it = this.urlList.iterator();
        if (it.hasNext()) {
            builder.append(((Object)it.next()).toString());
        }
        while (it.hasNext()) {
            builder.append(",").append(((Object)it.next()).toString());
        }
        String s = builder.toString();
        if (logger.isLoggable(Level.FINE)) {
            this.logFine("toString returns :: " + s);
        }
        return s;
    }

    public void addMQUrl(JmsHost host) {
        MQUrl url = this.createUrl(host);
        this.urlList.add(url);
    }

    public void removeMQUrl(JmsHost host) {
        MQUrl url = this.createUrl(host);
        this.urlList.remove(url);
    }

    public void updateMQUrl(JmsHost host) {
        MQUrl url = this.createUrl(host);
        this.urlList.remove(url);
        this.urlList.add(url);
    }

    private MQUrl createUrl(JmsHost host) {
        return MQAddressList.createUrl(host, this.jmsService);
    }

    private MQUrl createUrl(JmsHost host, String overridedHostName) {
        return MQAddressList.createUrl(host, this.jmsService, overridedHostName);
    }

    public static MQUrl createUrl(JmsHost host, JmsService js) {
        return MQAddressList.createUrl(host, js, null);
    }

    public static MQUrl createUrl(JmsHost host, JmsService js, String overridedHostName) {
        try {
            String name = host.getName();
            String hostName = host.getHost();
            if (overridedHostName != null && !overridedHostName.trim().equals("")) {
                hostName = overridedHostName;
            }
            String port = host.getPort();
            MQUrl url = new MQUrl(name);
            url.setHost(hostName);
            url.setPort(port);
            if (js != null) {
                String service;
                String scheme = js.getMqScheme();
                if (scheme != null && !scheme.trim().equals("")) {
                    url.setScheme(scheme);
                }
                if ((service = js.getMqService()) != null && !service.trim().equals("")) {
                    url.setService(service);
                }
            }
            return url;
        }
        catch (Exception ce) {
            ce.printStackTrace();
            return null;
        }
    }

    private JmsHost getResolvedJmsHostForStandaloneServerInstance(String serverName) throws Exception {
        if (logger.isLoggable(Level.FINE)) {
            this.logFine(" getresolved " + serverName);
        }
        Server serverInstance = this.getServerByName(serverName);
        if (logger.isLoggable(Level.FINE)) {
            this.logFine("serverinstace " + serverInstance);
        }
        JmsHost jmsHost = this.getResolvedJmsHost(serverInstance);
        return jmsHost;
    }

    private Server getServerByName(String serverName) {
        Domain domain = (Domain)Globals.get(Domain.class);
        Servers servers = domain.getServers();
        List serverList = servers.getServer();
        for (int i = 0; i < serverList.size(); ++i) {
            Server server = (Server)serverList.get(i);
            if (!serverName.equals(server.getName())) continue;
            return server;
        }
        return null;
    }

    private JmsHost getResolvedJmsHost(Server as) throws Exception {
        if (as == null) {
            return null;
        }
        if (logger.isLoggable(Level.FINE)) {
            this.logFine("getResolvedJmsHost " + as);
        }
        JmsHost jmsHost = this.getResolvedLocalJmsHostInServer(as);
        JmsHost copy = this.createJmsHostCopy(jmsHost, as);
        String hostName = this.getNodeHostName(as);
        String port = JmsRaUtil.getJMSPropertyValue(as);
        copy.setHost(hostName);
        copy.setPort(port);
        return copy;
    }

    private JmsHost createJmsHostCopy(JmsHost jmsHost, Server server) {
        JmsHostWrapper jmsHostCopy = new JmsHostWrapper();
        try {
            jmsHostCopy.setAdminPassword(jmsHost.getAdminPassword());
            jmsHostCopy.setAdminUserName(jmsHost.getAdminUserName());
            jmsHostCopy.setName(jmsHost.getName());
            jmsHostCopy.setHost(jmsHost.getHost());
            jmsHostCopy.setPort(jmsHost.getPort());
        }
        catch (Exception tfe) {
            tfe.printStackTrace();
        }
        return jmsHostCopy;
    }

    private JmsHost getResolvedLocalJmsHostInServer(Server server) {
        Config config = this.getConfigForServer(server);
        if (config != null) {
            JmsService jmsService = (JmsService)config.getExtensionByType(JmsService.class);
            JmsHost jmsHost = null;
            if (JMSServiceType.LOCAL.toString().equals(jmsService.getType()) || JMSServiceType.EMBEDDED.toString().equals(jmsService.getType())) {
                jmsHost = this.getDefaultJmsHost(jmsService);
            }
            return jmsHost;
        }
        return null;
    }

    public JmsHost getDefaultJmsHost(JmsService jmsService) {
        String defaultJmsHost = jmsService.getDefaultJmsHost();
        List jmsHosts = jmsService.getJmsHost();
        JmsHost jmsHost = null;
        if (defaultJmsHost != null && !defaultJmsHost.equals("") && jmsHosts != null && jmsHosts.size() > 0) {
            for (int i = 0; i < jmsHosts.size(); ++i) {
                if (!defaultJmsHost.equals(((JmsHost)jmsHosts.get(i)).getName())) continue;
                return (JmsHost)jmsHosts.get(i);
            }
        }
        jmsHost = jmsHosts != null && jmsHosts.size() > 0 ? (JmsHost)jmsHosts.get(0) : (JmsHost)Globals.get(JmsHost.class);
        return jmsHost;
    }

    public boolean isClustered() {
        Domain domain = (Domain)Globals.get(Domain.class);
        Clusters clusters = domain.getClusters();
        if (clusters == null) {
            return false;
        }
        List clusterList = clusters.getCluster();
        return JmsRaUtil.isClustered(clusterList, this.myName);
    }

    private static String getServerName() {
        String serverName = System.getProperty("com.sun.aas.instanceName");
        return serverName;
    }

    private void logFine(String s) {
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "MQAddressList :: " + s);
        }
    }

    public int getSize() {
        if (this.urlList != null) {
            return this.urlList.size();
        }
        return 0;
    }

    static enum JMSServiceType {
        LOCAL,
        REMOTE,
        EMBEDDED;

    }
}

