/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.flashlight.statistics.impl;

import java.util.concurrent.atomic.AtomicLong;
import org.glassfish.flashlight.datatree.impl.AbstractTreeNode;
import org.glassfish.flashlight.statistics.Average;
import org.glassfish.flashlight.statistics.TimeStats;
import org.glassfish.flashlight.statistics.factory.AverageFactory;

public abstract class TimeStatsAbstractImpl
extends AbstractTreeNode
implements TimeStats {
    private Average average = AverageFactory.createAverage();
    private AtomicLong lastSampleTime = new AtomicLong(0L);
    protected long startTime = 0L;
    private ThreadLocalTimeStatData individualData = new ThreadLocalTimeStatData();
    protected static final String NEWLINE = System.getProperty("line.separator");

    @Override
    public double getTime() {
        return this.average.getAverage();
    }

    @Override
    public abstract void entry();

    @Override
    public abstract void exit();

    protected void postEntry(long entryTime) {
        if (this.startTime == 0L) {
            this.startTime = entryTime;
        }
        this.setLastSampleTime(entryTime);
        this.individualData.get().setEntryTime(entryTime);
    }

    public void postExit(long exitTime) {
        TimeStatData tsd = this.individualData.get();
        tsd.setExitTime(exitTime);
        this.average.addDataPoint(tsd.getTotalTime());
    }

    @Override
    public long getMinimumTime() {
        return this.average.getMin();
    }

    @Override
    public long getMaximumTime() {
        return this.average.getMax();
    }

    @Override
    public void setTime(long time) {
        this.individualData.get().setTotalTime(time);
        this.average.addDataPoint(time);
    }

    @Override
    public void setReset(boolean reset) {
        this.average.setReset();
        this.individualData.get().setReset();
    }

    @Override
    public long getTimesCalled() {
        return this.average.getSize();
    }

    public long getCount() {
        return this.getTimesCalled();
    }

    public long getMaxTime() {
        return this.getMaximumTime();
    }

    public long getMinTime() {
        return this.getMinimumTime();
    }

    public long getTotalTime() {
        return this.average.getTotal();
    }

    public long getLastSampleTime() {
        return this.lastSampleTime.get();
    }

    public long getStartTime() {
        return this.startTime;
    }

    private void setLastSampleTime(long time) {
        this.lastSampleTime.set(time);
    }

    private static class TimeStatData {
        private long entryTime = 0L;
        private long exitTime = 0L;
        private long totalTime = 0L;

        private TimeStatData() {
        }

        public long getEntryTime() {
            return this.entryTime;
        }

        public void setEntryTime(long entryTime) {
            this.entryTime = entryTime;
        }

        public long getExitTime() {
            return this.exitTime;
        }

        public void setExitTime(long exitTime) {
            this.exitTime = exitTime;
        }

        public long getTotalTime() {
            this.totalTime = this.exitTime - this.entryTime;
            return this.totalTime;
        }

        public void setTotalTime(long totalTime) {
            this.totalTime = totalTime;
        }

        public void setReset() {
            this.entryTime = 0L;
            this.exitTime = 0L;
            this.totalTime = 0L;
        }
    }

    private static class ThreadLocalTimeStatData
    extends ThreadLocal<TimeStatData> {
        private TimeStatData tsd;

        private ThreadLocalTimeStatData() {
        }

        @Override
        protected TimeStatData initialValue() {
            this.tsd = new TimeStatData();
            return this.tsd;
        }

        @Override
        public TimeStatData get() {
            if (this.tsd == null) {
                this.tsd = new TimeStatData();
            }
            return this.tsd;
        }
    }
}

