/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.gogo.runtime.activator;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.felix.gogo.runtime.CommandProcessorImpl;
import org.apache.felix.gogo.runtime.CommandProxy;
import org.apache.felix.gogo.runtime.activator.EventAdminListener;
import org.apache.felix.gogo.runtime.threadio.ThreadIOImpl;
import org.apache.felix.service.command.CommandProcessor;
import org.apache.felix.service.command.CommandSessionListener;
import org.apache.felix.service.command.Converter;
import org.apache.felix.service.threadio.ThreadIO;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.util.tracker.ServiceTracker;

public class Activator
implements BundleActivator {
    protected CommandProcessorImpl processor;
    private ThreadIOImpl threadio;
    private ServiceTracker commandTracker;
    private ServiceTracker converterTracker;
    private ServiceTracker listenerTracker;
    private ServiceRegistration processorRegistration;
    private ServiceRegistration threadioRegistration;
    public static final String CONTEXT = ".context";

    protected ServiceRegistration newProcessor(ThreadIO tio, BundleContext context) {
        this.processor = new CommandProcessorImpl(tio);
        try {
            this.processor.addListener(new EventAdminListener(context));
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            // empty catch block
        }
        this.processor.addConstant(CONTEXT, context);
        this.processor.addCommand("osgi", (Object)this.processor, "addCommand");
        this.processor.addCommand("osgi", (Object)this.processor, "removeCommand");
        this.processor.addCommand("osgi", (Object)this.processor, "eval");
        return context.registerService(CommandProcessor.class.getName(), (Object)this.processor, null);
    }

    public void start(BundleContext context) throws Exception {
        this.threadio = new ThreadIOImpl();
        this.threadio.start();
        this.threadioRegistration = context.registerService(ThreadIO.class.getName(), (Object)this.threadio, null);
        this.processorRegistration = this.newProcessor(this.threadio, context);
        this.commandTracker = this.trackOSGiCommands(context);
        this.commandTracker.open();
        this.converterTracker = new ServiceTracker<Converter, Converter>(context, Converter.class, null){

            public Converter addingService(ServiceReference<Converter> reference) {
                Converter converter = (Converter)super.addingService(reference);
                Activator.this.processor.addConverter(converter);
                return converter;
            }

            public void removedService(ServiceReference<Converter> reference, Converter service) {
                Activator.this.processor.removeConverter(service);
                super.removedService(reference, (Object)service);
            }
        };
        this.converterTracker.open();
        this.listenerTracker = new ServiceTracker<CommandSessionListener, CommandSessionListener>(context, CommandSessionListener.class.getName(), null){

            public CommandSessionListener addingService(ServiceReference<CommandSessionListener> reference) {
                CommandSessionListener listener = (CommandSessionListener)super.addingService(reference);
                Activator.this.processor.addListener(listener);
                return listener;
            }

            public void removedService(ServiceReference<CommandSessionListener> reference, CommandSessionListener service) {
                Activator.this.processor.removeListener(service);
                super.removedService(reference, (Object)service);
            }
        };
        this.listenerTracker.open();
    }

    public void stop(BundleContext context) throws Exception {
        this.processorRegistration.unregister();
        this.threadioRegistration.unregister();
        this.commandTracker.close();
        this.converterTracker.close();
        this.listenerTracker.close();
        this.threadio.stop();
        this.processor.stop();
    }

    private ServiceTracker trackOSGiCommands(BundleContext context) throws InvalidSyntaxException {
        Filter filter = context.createFilter(String.format("(&(%s=*)(%s=*))", "osgi.command.scope", "osgi.command.function"));
        return new ServiceTracker<Object, List<Object>>(context, filter, null){
            private final ConcurrentMap<ServiceReference<Object>, Map<String, CommandProxy>> proxies;
            {
                this.proxies = new ConcurrentHashMap<ServiceReference<Object>, Map<String, CommandProxy>>();
            }

            public List<Object> addingService(ServiceReference<Object> reference) {
                Object scope = reference.getProperty("osgi.command.scope");
                Object function = reference.getProperty("osgi.command.function");
                Object ranking = reference.getProperty("service.ranking");
                ArrayList<Object> commands = new ArrayList<Object>();
                int rank = 0;
                if (ranking != null) {
                    try {
                        rank = Integer.parseInt(ranking.toString());
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                if (scope != null && function != null) {
                    HashMap<String, CommandProxy> proxyMap = new HashMap<String, CommandProxy>();
                    if (function.getClass().isArray()) {
                        for (Object f : (Object[])function) {
                            CommandProxy target = new CommandProxy(this.context, reference, f.toString());
                            proxyMap.put(f.toString(), target);
                            Activator.this.processor.addCommand(scope.toString(), (Object)target, f.toString(), rank);
                            commands.add(target);
                        }
                    } else {
                        CommandProxy target = new CommandProxy(this.context, reference, function.toString());
                        proxyMap.put(function.toString(), target);
                        Activator.this.processor.addCommand(scope.toString(), (Object)target, function.toString(), rank);
                        commands.add(target);
                    }
                    this.proxies.put(reference, proxyMap);
                    return commands;
                }
                return null;
            }

            public void removedService(ServiceReference<Object> reference, List<Object> service) {
                Object scope = reference.getProperty("osgi.command.scope");
                Object function = reference.getProperty("osgi.command.function");
                if (scope != null && function != null) {
                    Map proxyMap = (Map)this.proxies.remove(reference);
                    for (Map.Entry entry : proxyMap.entrySet()) {
                        Activator.this.processor.removeCommand(scope.toString(), (String)entry.getKey(), entry.getValue());
                    }
                }
                super.removedService(reference, service);
            }
        };
    }
}

