/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.appclient.server.core.jws.servedcontent;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import java.util.jar.Attributes;
import org.glassfish.appclient.server.core.jws.servedcontent.ASJarSigner;
import org.glassfish.appclient.server.core.jws.servedcontent.FixedContent;

public class AutoSignedContent
extends FixedContent {
    private static final String JWS_PERMISSIONS_NAME = "Permissions";
    private static final String JWS_PERMISSIONS_VALUE = "all-permissions";
    private static final String JWS_CODEBASE_NAME = "Codebase";
    private static final String JWS_TRUSTED_NAME = "Trusted-Library";
    private static final String JWS_TRUSTED_VALUE = "true";
    private static final String JWS_APP_NAME = "Application-Name";
    private final File unsignedFile;
    private final File signedFile;
    private final String userProvidedAlias;
    private final ASJarSigner jarSigner;
    private final URI relativeURI;
    private final String appName;

    static Attributes createJWSAttrs(URI requestURI, String appName) {
        Attributes attrs = new Attributes(3);
        attrs.putValue(JWS_PERMISSIONS_NAME, JWS_PERMISSIONS_VALUE);
        attrs.putValue(JWS_APP_NAME, appName);
        try {
            URI trimmedURI = new URI(requestURI.getScheme(), null, requestURI.getHost(), requestURI.getPort(), null, null, null);
            attrs.putValue(JWS_CODEBASE_NAME, trimmedURI.toASCIIString());
        }
        catch (URISyntaxException ex) {
            throw new RuntimeException(ex);
        }
        attrs.putValue(JWS_TRUSTED_NAME, JWS_TRUSTED_VALUE);
        return attrs;
    }

    public AutoSignedContent(File unsignedFile, File signedFile, String userProvidedAlias, ASJarSigner jarSigner, String relativeURI, String appName) throws FileNotFoundException {
        if (!unsignedFile.exists() || !unsignedFile.canRead()) {
            throw new FileNotFoundException(unsignedFile.getAbsolutePath());
        }
        this.unsignedFile = unsignedFile;
        this.signedFile = signedFile;
        this.userProvidedAlias = userProvidedAlias;
        this.jarSigner = jarSigner;
        this.relativeURI = URI.create(relativeURI);
        this.appName = appName;
    }

    @Override
    public File file() throws IOException {
        return this.signedFile;
    }

    File unsignedFile() {
        return this.unsignedFile;
    }

    String appName() {
        return this.appName;
    }

    @Override
    public boolean isAvailable(URI requestURI) throws IOException {
        if (!this.isSignedFileReady()) {
            try {
                this.createSignedFile(requestURI);
            }
            catch (Exception e) {
                throw new IOException(e);
            }
        }
        return super.isAvailable(requestURI);
    }

    ASJarSigner jarSigner() {
        return this.jarSigner;
    }

    String userProvidedAlias() {
        return this.userProvidedAlias;
    }

    private boolean isSignedFileReady() {
        return this.signedFile.exists() && this.signedFile.lastModified() >= this.unsignedFile.lastModified();
    }

    private void createSignedFile(URI requestURI) throws Exception {
        ResourceBundle rb;
        if (!this.signedFile.getParentFile().exists() && !this.signedFile.getParentFile().mkdirs() && (rb = ResourceBundle.getBundle(this.getClass().getPackage().getName() + ".LogStrings")) != null) {
            throw new IOException(MessageFormat.format(rb.getString("enterprise.deployment.appclient.errormkdirs"), this.signedFile.getParentFile().getAbsolutePath()));
        }
        Attributes attrs = AutoSignedContent.createJWSAttrs(requestURI, this.appName);
        this.jarSigner.signJar(this.unsignedFile, this.signedFile, this.userProvidedAlias, attrs);
    }

    @Override
    public String toString() {
        return "AutoSignedContent:" + (this.signedFile == null ? "(stream)" : this.signedFile.getAbsolutePath());
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AutoSignedContent other = (AutoSignedContent)obj;
        if (!(this.unsignedFile == other.unsignedFile || this.unsignedFile != null && this.unsignedFile.equals(other.unsignedFile))) {
            return false;
        }
        if (!(this.signedFile == other.signedFile || this.signedFile != null && this.signedFile.equals(other.signedFile))) {
            return false;
        }
        return !(this.userProvidedAlias == null ? other.userProvidedAlias != null : !this.userProvidedAlias.equals(other.userProvidedAlias));
    }

    @Override
    public int hashCode() {
        int hash = 7;
        hash = 83 * hash + (this.unsignedFile != null ? this.unsignedFile.hashCode() : 0);
        hash = 83 * hash + (this.signedFile != null ? this.signedFile.hashCode() : 0);
        hash = 83 * hash + (this.userProvidedAlias != null ? this.userProvidedAlias.hashCode() : 0);
        return hash;
    }
}

