/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.config.manager.spi;

import com.sun.faces.config.WebConfiguration;
import com.sun.faces.spi.AnnotationProvider;
import com.sun.faces.util.FacesLogger;
import com.sun.faces.util.Util;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.bean.ManagedBean;
import javax.faces.component.FacesComponent;
import javax.faces.component.behavior.FacesBehavior;
import javax.faces.convert.FacesConverter;
import javax.faces.event.NamedEvent;
import javax.faces.render.FacesBehaviorRenderer;
import javax.faces.render.FacesRenderer;
import javax.faces.validator.FacesValidator;
import javax.faces.view.facelets.FaceletsResourceResolver;
import javax.servlet.ServletContext;

public abstract class AnnotationScanner
extends AnnotationProvider {
    private static final Logger LOGGER = FacesLogger.CONFIG.getLogger();
    private static final String WILDCARD = "*";
    protected static final Set<String> FACES_ANNOTATIONS;
    protected static final Set<Class<? extends Annotation>> FACES_ANNOTATION_TYPE;
    private boolean isAnnotationScanPackagesSet = false;
    private String[] webInfClassesPackages;
    private Map<String, String[]> classpathPackages;

    public AnnotationScanner(ServletContext sc) {
        super(sc);
        WebConfiguration webConfig = WebConfiguration.getInstance(sc);
        this.initializeAnnotationScanPackages(sc, webConfig);
    }

    private void initializeAnnotationScanPackages(ServletContext sc, WebConfiguration webConfig) {
        if (!webConfig.isSet(WebConfiguration.WebContextInitParameter.AnnotationScanPackages)) {
            return;
        }
        this.isAnnotationScanPackagesSet = true;
        this.classpathPackages = new HashMap<String, String[]>(4);
        this.webInfClassesPackages = new String[0];
        String[] options = webConfig.getOptionValue(WebConfiguration.WebContextInitParameter.AnnotationScanPackages, "\\s+");
        ArrayList<String> packages = new ArrayList<String>(4);
        for (String option : options) {
            if (option.length() == 0) continue;
            if (option.startsWith("jar:")) {
                String[] parts = Util.split(sc, option, ":");
                if (parts.length != 3) {
                    if (!LOGGER.isLoggable(Level.WARNING)) continue;
                    LOGGER.log(Level.WARNING, "jsf.annotation.scanner.configuration.invalid", new String[]{WebConfiguration.WebContextInitParameter.AnnotationScanPackages.getQualifiedName(), option});
                    continue;
                }
                if (WILDCARD.equals(parts[1]) && !this.classpathPackages.containsKey(WILDCARD)) {
                    this.classpathPackages.clear();
                    this.classpathPackages.put(WILDCARD, this.normalizeJarPackages(Util.split(sc, parts[2], ",")));
                    continue;
                }
                if (WILDCARD.equals(parts[1]) && this.classpathPackages.containsKey(WILDCARD)) {
                    if (!LOGGER.isLoggable(Level.WARNING)) continue;
                    LOGGER.log(Level.WARNING, "jsf.annotation.scanner.configuration.duplicate.wildcard", new String[]{WebConfiguration.WebContextInitParameter.AnnotationScanPackages.getQualifiedName(), option});
                    continue;
                }
                if (this.classpathPackages.containsKey(WILDCARD)) continue;
                this.classpathPackages.put(parts[1], this.normalizeJarPackages(Util.split(sc, parts[2], ",")));
                continue;
            }
            if (WILDCARD.equals(option) && !packages.contains(WILDCARD)) {
                packages.clear();
                packages.add(WILDCARD);
                continue;
            }
            if (packages.contains(WILDCARD)) continue;
            packages.add(option);
        }
        this.webInfClassesPackages = packages.toArray(new String[packages.size()]);
    }

    private String[] normalizeJarPackages(String[] packages) {
        if (packages.length == 0) {
            return packages;
        }
        ArrayList<String> normalizedPackages = new ArrayList<String>(packages.length);
        for (String pkg : packages) {
            if (WILDCARD.equals(pkg)) {
                normalizedPackages.clear();
                normalizedPackages.add(WILDCARD);
                break;
            }
            normalizedPackages.add(pkg);
        }
        return normalizedPackages.toArray(new String[normalizedPackages.size()]);
    }

    protected boolean processJar(String entry) {
        return this.classpathPackages == null || this.classpathPackages.containsKey(entry) || this.classpathPackages.containsKey(WILDCARD);
    }

    protected boolean processClass(String candidate) {
        return this.processClass(candidate, this.webInfClassesPackages);
    }

    protected boolean processClass(String candidate, String[] packages) {
        if (packages == null) {
            return true;
        }
        for (String packageName : packages) {
            if (!candidate.startsWith(packageName) && !WILDCARD.equals(packageName)) continue;
            return true;
        }
        return false;
    }

    protected Map<Class<? extends Annotation>, Set<Class<?>>> processClassList(Set<String> classList) {
        Map<Class<Annotation>, Set<Class<?>>> annotatedClasses = null;
        if (classList.size() > 0) {
            annotatedClasses = new HashMap(6, 1.0f);
            for (String className : classList) {
                try {
                    Annotation[] annotations;
                    Class clazz = Util.loadClass(className, this);
                    for (Annotation annotation : annotations = clazz.getAnnotations()) {
                        Class<? extends Annotation> annoType = annotation.annotationType();
                        if (!FACES_ANNOTATION_TYPE.contains(annoType)) continue;
                        Set<Class<?>> classes = annotatedClasses.get(annoType);
                        if (classes == null) {
                            classes = new HashSet();
                            annotatedClasses.put(annoType, classes);
                        }
                        classes.add(clazz);
                    }
                }
                catch (ClassNotFoundException cnfe) {
                    if (!LOGGER.isLoggable(Level.SEVERE)) continue;
                    LOGGER.log(Level.SEVERE, "Unable to load annotated class: {0}", className);
                    LOGGER.log(Level.SEVERE, "", cnfe);
                }
                catch (NoClassDefFoundError ncdfe) {
                    if (!LOGGER.isLoggable(Level.SEVERE)) continue;
                    LOGGER.log(Level.SEVERE, "Unable to load annotated class: {0}, reason: {1}", new Object[]{className, ncdfe.toString()});
                }
            }
        }
        return annotatedClasses != null ? annotatedClasses : Collections.emptyMap();
    }

    protected boolean isAnnotationScanPackagesSet() {
        return this.isAnnotationScanPackagesSet;
    }

    protected Map<String, String[]> getClasspathPackages() {
        return this.classpathPackages;
    }

    protected String[] getWebInfClassesPackages() {
        return this.webInfClassesPackages;
    }

    static {
        HashSet annotations = new HashSet(8, 1.0f);
        Collections.addAll(annotations, "Ljavax/faces/component/FacesComponent;", "Ljavax/faces/convert/FacesConverter;", "Ljavax/faces/validator/FacesValidator;", "Ljavax/faces/render/FacesRenderer;", "Ljavax/faces/bean/ManagedBean;", "Ljavax/faces/event/NamedEvent;", "Ljavax/faces/component/behavior/FacesBehavior;", "Ljavax/faces/render/FacesBehaviorRenderer;", "Ljavax/faces/view/facelets/FaceletsResourceResolver;", "javax.faces.component.FacesComponent", "javax.faces.convert.FacesConverter", "javax.faces.validator.FacesValidator", "javax.faces.render.FacesRenderer", "javax.faces.bean.ManagedBean", "javax.faces.event.NamedEvent", "javax.faces.component.behavior.FacesBehavior", "javax.faces.render.FacesBehaviorRenderer", "javax.faces.view.facelets.FaceletsResourceResolver");
        FACES_ANNOTATIONS = Collections.unmodifiableSet(annotations);
        HashSet annotationInstances = new HashSet(8, 1.0f);
        Collections.addAll(annotationInstances, FacesComponent.class, FacesConverter.class, FacesValidator.class, FacesRenderer.class, ManagedBean.class, NamedEvent.class, FacesBehavior.class, FacesBehaviorRenderer.class, FaceletsResourceResolver.class);
        FACES_ANNOTATION_TYPE = Collections.unmodifiableSet(annotationInstances);
    }
}

