/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.lib.harness;

import com.sun.ts.lib.deliverable.DeliverableFactory;
import com.sun.ts.lib.deliverable.DeliverableInterface;
import com.sun.ts.lib.deliverable.PropertyManagerInterface;
import com.sun.ts.lib.deliverable.PropertyNotSetException;
import com.sun.ts.lib.harness.CommonAppVerifier;
import com.sun.ts.lib.harness.ExecutionMode;
import com.sun.ts.lib.harness.InteropTestManager;
import com.sun.ts.lib.harness.ProfileHelper;
import com.sun.ts.lib.harness.TSRuntimeConfiguration;
import com.sun.ts.lib.porting.DeploymentInfo;
import com.sun.ts.lib.porting.TSDeployment;
import com.sun.ts.lib.porting.TSDeploymentException;
import com.sun.ts.lib.porting.TSDeploymentInterface;
import com.sun.ts.lib.porting.TSJMSAdmin;
import com.sun.ts.lib.porting.TSJMSAdminException;
import com.sun.ts.lib.porting.TSJMSAdminInterface;
import com.sun.ts.lib.util.TestUtil;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Properties;
import java.util.Vector;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;

public class SuiteSynchronizer {
    PrintWriter logOut;
    private static String sClientClassesPath = "";
    private static String sCommonClientClassesPath = "";
    private static String sLastTestDirectory = "none run yet";
    private static String sInteropDirectionWhenTablesWerePopulated = "forward";
    private static Hashtable htTSDeployers = new Hashtable();
    private static Hashtable htTSJMSAdmins = new Hashtable();
    private static Hashtable htJNDIMapsFromServer1 = new Hashtable();
    private static Hashtable htJNDIMapsFromServer2 = new Hashtable();
    private static TSRuntimeConfiguration runtimeConfig;
    String testDir = "";
    Properties pDeployProps;
    private boolean bSweepRebuildableReverseRuntimeFiles;
    private static SuiteSynchronizer ss;
    private PropertyManagerInterface jteMgr;
    private static Vector vCommonAppsDeployedThisJVM;
    private static String sDeployStatus;
    private static String sDeployStackTrace;
    private static String[] sTopicFactories1;
    private static String[] sQueueFactories1;
    private static String[] sTopicFactories2;
    private static String[] sQueueFactories2;
    private static boolean bCreateConnectionFactories1;
    private static boolean bCreateConnectionFactories2;
    private static boolean bReversed;
    private int executionMode;
    private static Vector vCommonDeploymentInfos;
    private static Vector vCurrentDeploymentInfos;
    private static boolean bDeployingCommonApps;
    private static DeliverableInterface deliv;
    private static boolean bSupportsAutoDeploy;
    private static boolean bSupportsAutoJMS;
    private static boolean bSupportsInterop;

    public static final SuiteSynchronizer createSuiteSynchronizer(PrintWriter writer) {
        ss = new SuiteSynchronizer(writer);
        return ss;
    }

    public static final SuiteSynchronizer getSuiteSynchronizer(PrintWriter writer) {
        if (ss == null) {
            ss = new SuiteSynchronizer(writer);
        }
        return ss;
    }

    public SuiteSynchronizer(PrintWriter w) {
        this.setOutputWriter(w);
        try {
            deliv = DeliverableFactory.getDeliverableInstance();
            bSupportsAutoDeploy = deliv.supportsAutoDeployment();
            bSupportsAutoJMS = deliv.supportsAutoJMSAdmin();
            bSupportsInterop = deliv.supportsInterop();
            this.jteMgr = deliv.getPropertyManager();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.executionMode = ExecutionMode.getExecutionMode(this.jteMgr);
        this.init();
    }

    private void init() {
        if (bSupportsAutoDeploy) {
            try {
                if (htTSDeployers.get("cts1") == null) {
                    htTSDeployers.put("cts1", TSDeployment.getDeploymentInstance(this.logOut, "porting.ts.deploy.class.1"));
                }
                if (bSupportsAutoJMS && htTSJMSAdmins.get("cts1") == null) {
                    htTSJMSAdmins.put("cts1", TSJMSAdmin.getTSJMSAdminInstance(this.logOut, "porting.ts.jms.class.1"));
                }
                if (bSupportsInterop) {
                    if (htTSDeployers.get("cts2") == null) {
                        htTSDeployers.put("cts2", TSDeployment.getDeploymentInstance(this.logOut, "porting.ts.deploy.class.2"));
                    }
                    if (bSupportsAutoJMS && htTSJMSAdmins.get("cts2") == null) {
                        htTSJMSAdmins.put("cts2", TSJMSAdmin.getTSJMSAdminInstance(this.logOut, "porting.ts.jms.class.2"));
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                TestUtil.logHarness("Creation of TSDeployment or TSJMSAdmin implementation instances failed.  Please check the values of 'porting.ts.deploy.class.1', 'porting.ts.deploy.class.2', 'porting.ts.jms.class.1' and 'porting.ts.jms.class.2'");
            }
            try {
                runtimeConfig = new TSRuntimeConfiguration(this.logOut);
                TestUtil.logHarness("ss:  modified runtime.xml");
            }
            catch (Exception e) {
                e.printStackTrace();
                TestUtil.logHarness("Failed to modify xml files with correct settings.  Please check the values of 'mailHost, mailFrom, webServerHost, and webServerPort'");
            }
        }
    }

    public void setOutputWriter(PrintWriter w) {
        this.logOut = w;
    }

    public TSDeploymentInterface getTSDeployer(String sDeployerToGet) throws TSDeploymentException {
        return (TSDeploymentInterface)htTSDeployers.get(sDeployerToGet);
    }

    public String getDeploymentStatus() {
        return sDeployStatus;
    }

    public String getDeploymentExceptionTrace() {
        return sDeployStackTrace;
    }

    public String getClientClassPath() {
        return sCommonClientClassesPath + sClientClassesPath;
    }

    public void doCommonUnDeployment() throws TSDeploymentException {
        Object sVal = null;
        this.pDeployProps = new Properties();
        vCommonDeploymentInfos.clear();
        if (!vCommonAppsDeployedThisJVM.isEmpty()) {
            for (int ii = 0; ii < vCommonAppsDeployedThisJVM.size(); ++ii) {
                TestUtil.logHarness("*******************************");
                TestUtil.logHarness("Beginning one-time Undeployment of any TS common applications...");
                TestUtil.logHarness("*******************************");
                this.testDir = (String)vCommonAppsDeployedThisJVM.elementAt(ii);
                try {
                    this.undeployApps(this.testDir);
                    TestUtil.logHarness("Undeployed common apps in:  " + this.testDir);
                    continue;
                }
                catch (TSDeploymentException de) {
                    TestUtil.logHarness("*******************************");
                    TestUtil.logHarness("Failed to complete TS common application deployment.");
                    TestUtil.logHarness("*******************************");
                    throw de;
                }
                catch (Exception e) {
                    TestUtil.logHarness("*******************************");
                    TestUtil.logHarness("Failed to complete TS common application deployment.");
                    TestUtil.logHarness("*******************************");
                    throw new TSDeploymentException("Exception:  Failed to Undeploy common apps in " + this.testDir, e);
                }
            }
            vCommonAppsDeployedThisJVM.clear();
            sCommonClientClassesPath = "";
            TestUtil.logHarness("*******************************");
            TestUtil.logHarness("Successfully completed TS common application Undeployment.");
            TestUtil.logHarness("*******************************");
        }
    }

    public void doDeployment(String testDirectory, Properties props) throws TSDeploymentException, TSJMSAdminException {
        this.pDeployProps = props;
        String sCommonTestDir = "";
        this.testDir = TestUtil.srcToDist(testDirectory);
        if (sLastTestDirectory.equals(this.testDir)) {
            sDeployStatus = "passed";
            return;
        }
        vCurrentDeploymentInfos.clear();
        vCurrentDeploymentInfos.addAll(vCommonDeploymentInfos);
        String sDeployCommon = this.jteMgr.getProperty("deploy_undeploy_common_apps", "true");
        if (TestUtil.harnessDebug) {
            TestUtil.logHarnessDebug("deploy_undeploy_common_apps = " + sDeployCommon);
        }
        if (sDeployCommon.equalsIgnoreCase("true")) {
            String[] sCommonApps = CommonAppVerifier.getInstance(new File(this.testDir)).getCommonApps();
            bDeployingCommonApps = true;
            for (int ii = 0; sCommonApps != null && ii < sCommonApps.length; ++ii) {
                sCommonTestDir = sCommonApps[ii];
                if (TestUtil.harnessDebug) {
                    TestUtil.logHarnessDebug("sCommonTestDir = " + sCommonTestDir);
                }
                if (!vCommonAppsDeployedThisJVM.contains(sCommonTestDir)) {
                    try {
                        this.undeployApps(sCommonTestDir);
                        if (TestUtil.harnessDebug) {
                            TestUtil.logHarnessDebug("Undeployed common apps from - " + sCommonTestDir);
                        }
                    }
                    catch (TSDeploymentException de) {
                        sDeployStatus = "failed";
                        this.logOut.println("Failed to undeploy common apps in " + sCommonTestDir);
                        throw de;
                    }
                    catch (Exception e) {
                        sDeployStatus = "failed";
                        this.logOut.println("Unexpected Exception:  Failed to undeploy common apps in " + sCommonTestDir);
                        throw new TSDeploymentException("Exception:  Failed to undeploy common apps in " + sCommonTestDir, e);
                    }
                    if (sCommonTestDir.indexOf("txECMPbean") != -1 || sCommonTestDir.indexOf("txEPMbean") != -1 || sCommonTestDir.indexOf("ejbql" + File.separator + "schema") != -1) {
                        if (TestUtil.harnessDebug) {
                            TestUtil.logHarnessDebug("Found the TxECMPbean, TxEPMbean, or ejbql/schema common bean.  We must generate SQL ");
                        }
                        this.pDeployProps.put("generateSQL", "true");
                    }
                    try {
                        sCommonClientClassesPath = sCommonClientClassesPath + this.deployApps(sCommonTestDir) + File.pathSeparator;
                        if (TestUtil.harnessDebug) {
                            TestUtil.logHarnessDebug("Deployed common apps from - " + sCommonTestDir);
                        }
                        vCommonAppsDeployedThisJVM.addElement(sCommonTestDir);
                        continue;
                    }
                    catch (TSDeploymentException de) {
                        sDeployStatus = "failed";
                        TestUtil.logHarness("Deployment of common app(s) from:  " + sCommonTestDir + " failed!");
                        de.printStackTrace();
                        sDeployStackTrace = TestUtil.printStackTraceToString(de);
                        throw de;
                    }
                    catch (TSJMSAdminException je) {
                        sDeployStatus = "failed";
                        TestUtil.logHarness("JMS Admin topic/queue creation from:  " + sCommonTestDir + " failed!");
                        je.printStackTrace();
                        sDeployStackTrace = TestUtil.printStackTraceToString(je);
                        throw je;
                    }
                }
                if (!TestUtil.harnessDebug) continue;
                TestUtil.logHarnessDebug("Common apps from this dir are already deployed during this JVM- " + sCommonTestDir);
            }
        } else if (TestUtil.harnessDebug) {
            TestUtil.logHarnessDebug("Skipping common app deployment " + sDeployCommon);
        }
        if (!Boolean.getBoolean("common.apps.only") && !sLastTestDirectory.equals(this.testDir)) {
            bDeployingCommonApps = false;
            try {
                if (!sLastTestDirectory.equals("none run yet")) {
                    this.undeployApps(sLastTestDirectory);
                    this.logOut.println("Undeployed apps from - " + sLastTestDirectory);
                }
            }
            catch (TSDeploymentException de) {
                sDeployStatus = "failed";
                this.logOut.println("Undeployment of previous apps failed.");
                sDeployStackTrace = TestUtil.printStackTraceToString(de);
                throw de;
            }
            catch (Exception e) {
                sDeployStatus = "failed";
                this.logOut.println("Exception:  undeployment of previous apps failed.");
                sDeployStackTrace = TestUtil.printStackTraceToString(e);
                throw new TSDeploymentException("Exception:  Undeployment of previous apps failed", e);
            }
            try {
                if (!sLastTestDirectory.equals(this.testDir)) {
                    this.undeployApps(this.testDir);
                    this.logOut.println("Undeployed apps from - " + this.testDir);
                }
            }
            catch (TSDeploymentException de) {
                sDeployStatus = "failed";
                this.logOut.println("Undeployment of current apps in " + this.testDir + "failed");
                sDeployStackTrace = TestUtil.printStackTraceToString(de);
                throw de;
            }
            catch (Exception e) {
                sDeployStatus = "failed";
                this.logOut.println("Exception:  Undeployment of current apps in " + this.testDir + "failed");
                sDeployStackTrace = TestUtil.printStackTraceToString(e);
                throw new TSDeploymentException("Exception:  Undeployment of current apps in " + this.testDir + "failed", e);
            }
            try {
                sClientClassesPath = this.deployApps(this.testDir) + File.pathSeparator;
                this.logOut.println("Deployed apps from - " + this.testDir);
                sLastTestDirectory = this.testDir;
            }
            catch (TSDeploymentException de) {
                sDeployStatus = "failed";
                TestUtil.logHarness("Deployment of app(s) from:  " + this.testDir + " failed!");
                sDeployStackTrace = TestUtil.printStackTraceToString(de);
                throw de;
            }
            catch (Throwable e) {
                sDeployStatus = "failed";
                TestUtil.logHarness("Exception:  Deployment of app(s) from:  " + this.testDir + " failed!");
                e.printStackTrace(this.logOut);
                sDeployStackTrace = TestUtil.printStackTraceToString(e);
                throw new TSDeploymentException("Deployment of app(s) from:  " + this.testDir + " failed!", e);
            }
        }
        sDeployStatus = "passed";
    }

    public void removeJmsConnectionFactories() throws TSJMSAdminException {
        try {
            if (bSupportsAutoJMS) {
                TSJMSAdminInterface ctsJMS1 = (TSJMSAdminInterface)htTSJMSAdmins.get("cts1");
                TSJMSAdminInterface ctsJMS2 = (TSJMSAdminInterface)htTSJMSAdmins.get("cts2");
                if (sTopicFactories1 != null) {
                    ctsJMS1.removeJmsConnectionFactories(sTopicFactories1);
                    sTopicFactories1 = null;
                }
                if (sQueueFactories1 != null) {
                    ctsJMS1.removeJmsConnectionFactories(sQueueFactories1);
                    sQueueFactories1 = null;
                }
                bCreateConnectionFactories1 = true;
                this.logOut.println("Successfully removed JMS connection factories from server 1.");
                if (sTopicFactories2 != null) {
                    ctsJMS2.removeJmsConnectionFactories(sTopicFactories2);
                    sTopicFactories2 = null;
                }
                if (sQueueFactories2 != null) {
                    ctsJMS2.removeJmsConnectionFactories(sQueueFactories2);
                    sQueueFactories2 = null;
                }
                bCreateConnectionFactories2 = true;
                this.logOut.println("Successfully removed JMS connection factories from server 2.");
            }
        }
        catch (Exception e) {
            this.logOut.println("Exception:  removal of JMS connection factories failed.");
            e.printStackTrace();
            throw new TSJMSAdminException("Exception:  removal of JMS connection factories failed.", e);
        }
    }

    public void undeployLastApp() throws TSDeploymentException, TSJMSAdminException {
        try {
            if (!sLastTestDirectory.equals("none run yet")) {
                this.undeployApps(sLastTestDirectory);
                this.logOut.println("Undeployed apps from - " + sLastTestDirectory);
                sLastTestDirectory = "none run yet";
            }
        }
        catch (TSDeploymentException de) {
            this.logOut.println("Undeployment of last apps failed.");
            throw de;
        }
        catch (Exception e) {
            this.logOut.println("Exception:  undeployment of last apps failed.");
            throw new TSDeploymentException("Exception:  Undeployment of last apps failed", e);
        }
    }

    private boolean isInteropDir(String sDir) {
        return sDir.indexOf("interop") != -1;
    }

    private String[] getValidRuntimeInfoFiles(String sAppEar, String[] sRuntimeInfoArray, String sDir, Hashtable oppositeServerJNDITable, boolean bSweep) throws TSDeploymentException {
        int i;
        String[] sValidRuntimeInfo = null;
        sValidRuntimeInfo = this.getS1ASRuntimeInfoFiles(sAppEar, sRuntimeInfoArray, sDir);
        TestUtil.logHarnessDebug("Valid runtime files before sweep:");
        for (int k = 0; k < sValidRuntimeInfo.length; ++k) {
            TestUtil.logHarnessDebug(sValidRuntimeInfo[k]);
        }
        try {
            for (i = 0; i < sValidRuntimeInfo.length; ++i) {
                if (!bSweep) continue;
                runtimeConfig.setTable(oppositeServerJNDITable);
                String sTemp = runtimeConfig.sweepRuntimeFile(new File(sValidRuntimeInfo[i]));
                if (sTemp == null) continue;
                sValidRuntimeInfo[i] = sTemp;
            }
        }
        catch (Exception e) {
            TestUtil.logHarnessDebug("Error while sweeping valid runtime file: " + sValidRuntimeInfo[i]);
            throw new TSDeploymentException("Error while sweeping valid runtime files!", e);
        }
        TestUtil.logHarness("Valid runtime files after sweep:");
        for (int k = 0; k < sValidRuntimeInfo.length; ++k) {
            TestUtil.logHarness(sValidRuntimeInfo[k]);
        }
        return sValidRuntimeInfo;
    }

    private String getBaseName(String path) {
        int slash = path.lastIndexOf(File.separator);
        return path.substring(slash + 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String[] getS1ASRuntimeInfoFiles(String sAppEar, String[] sRuntimeInfoArray, String sDir) {
        String[] validRuntimeFiles;
        List<Object> al;
        block13: {
            al = new ArrayList(7);
            validRuntimeFiles = null;
            String baseName = this.getBaseName(sAppEar);
            TestUtil.logHarness("Search for s1as runtime files match:`" + baseName + "`");
            try {
                if (sAppEar.endsWith(".ear")) {
                    boolean isVIBuiltEar = sAppEar.contains("vi_built");
                    this.addIfPresent(baseName, al, sRuntimeInfoArray, isVIBuiltEar);
                    try (JarFile earFile = null;){
                        earFile = new JarFile(sAppEar);
                        Enumeration<JarEntry> enum1 = earFile.entries();
                        while (enum1.hasMoreElements()) {
                            String name;
                            ZipEntry infile = enum1.nextElement();
                            if (infile.isDirectory() || !(name = infile.getName()).endsWith(".war") && !name.endsWith("_ejb.jar") && !name.endsWith("_client.jar")) continue;
                            this.addIfPresent(name, al, sRuntimeInfoArray, isVIBuiltEar);
                        }
                        break block13;
                    }
                }
                if (sAppEar.endsWith(".jar") || sAppEar.endsWith(".war")) {
                    this.addIfPresent(baseName, al, sRuntimeInfoArray, false);
                } else {
                    TestUtil.logHarness("Unrecognized standalone component:`" + sAppEar + "`");
                }
            }
            catch (IOException ex) {
                TestUtil.logHarness("Exception in checking entries in ear file, use all available s1as runtime files.");
                ex.printStackTrace();
                al = Arrays.asList(sRuntimeInfoArray);
            }
        }
        validRuntimeFiles = new String[al.size()];
        for (int i = 0; i < validRuntimeFiles.length; ++i) {
            validRuntimeFiles[i] = sDir + File.separator + (String)al.get(i);
        }
        return validRuntimeFiles;
    }

    private void addIfPresent(String moduleName, List al, String[] runtimeFileNames, boolean isVIBuiltEar) {
        for (int i = 0; i < runtimeFileNames.length; ++i) {
            if (!runtimeFileNames[i].startsWith(moduleName) && (!isVIBuiltEar || !runtimeFileNames[i].startsWith("vi_built_" + moduleName))) continue;
            al.add(runtimeFileNames[i]);
            if (!TestUtil.harnessDebug) continue;
            TestUtil.logHarnessDebug("valid runtime file for:" + moduleName + ": " + runtimeFileNames[i]);
        }
    }

    public void cleanupTempDirectory() {
        try {
            this.jteMgr = deliv.getPropertyManager();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        String sHarnessTempDir = "";
        try {
            sHarnessTempDir = this.jteMgr.getProperty("harness.temp.directory");
        }
        catch (PropertyNotSetException pe) {
            TestUtil.logHarness(pe.getMessage());
            TestUtil.logHarness("error looking up property:  harness.temp.directory");
            pe.printStackTrace();
        }
        File fTestDir = new File(sHarnessTempDir);
        File[] fAppJarsArray = fTestDir.listFiles(ProfileHelper.ArchiveFilter.getInstance());
        for (int ii = 0; ii < fAppJarsArray.length; ++ii) {
            fAppJarsArray[ii].delete();
        }
    }

    private String deployApps(String sDir) throws TSDeploymentException, TSJMSAdminException {
        String sClientClassPaths = "";
        if (this.executionMode == 0 || this.executionMode == 1 || this.executionMode == 4) {
            String sInteropDirections = InteropTestManager.getInteropDirectionsFromKeywords(sDir);
            File fTestDir = new File(sDir);
            if (TestUtil.harnessDebug) {
                TestUtil.logHarnessDebug("deployApps - InteropDirections:  " + sInteropDirections);
            }
            String[] sAppJarsArray = ProfileHelper.getArchives(sDir, sInteropDirections);
            String[] sAppJarsForward = ProfileHelper.getArchives(sDir, "forward");
            String[] sAppJarsReverse = ProfileHelper.getArchives(sDir, "reverse");
            if (sInteropDirections.equals("forward") || sInteropDirections.equals("both")) {
                this.swapSettings("forward");
                if (this.isInteropDir(sDir)) {
                    this.populatePortingReplacementTables(sDir, sAppJarsArray);
                    TestUtil.logHarness("Deploying apps...");
                    sClientClassPaths = sClientClassPaths + this.continueToDeployApps(sDir, sAppJarsArray);
                } else {
                    this.populatePortingReplacementTables(sDir, sAppJarsForward);
                    TestUtil.logHarness("Deploying apps for forward rebuildable...");
                    sClientClassPaths = sClientClassPaths + this.continueToDeployApps(sDir, sAppJarsForward);
                    if (sInteropDirections.equals("both")) {
                        this.populatePortingReplacementTables(sDir, sAppJarsReverse);
                        TestUtil.logHarness("Deploying apps for reverse rebuildable...");
                        this.bSweepRebuildableReverseRuntimeFiles = true;
                        sClientClassPaths = sClientClassPaths + this.continueToDeployApps(sDir, sAppJarsReverse);
                        this.bSweepRebuildableReverseRuntimeFiles = false;
                    }
                }
            }
            if (sInteropDirections.equals("reverse") || sInteropDirections.equals("both")) {
                if (this.isInteropDir(sDir)) {
                    this.swapSettings("reverse");
                    this.populatePortingReplacementTables(sDir, sAppJarsArray);
                    TestUtil.logHarness("Deploying apps for reverse run...");
                    sClientClassPaths = sClientClassPaths + this.continueToDeployApps(sDir, sAppJarsArray);
                    TestUtil.logHarness("Swapped settings & deployed apps to opposite servers for directory:  " + sDir);
                } else if (sInteropDirections.equals("reverse")) {
                    this.populatePortingReplacementTables(sDir, sAppJarsReverse);
                    TestUtil.logHarness("Deploying apps for reverse rebuildable...");
                    this.bSweepRebuildableReverseRuntimeFiles = true;
                    sClientClassPaths = sClientClassPaths + this.continueToDeployApps(sDir, sAppJarsReverse);
                    this.bSweepRebuildableReverseRuntimeFiles = false;
                }
            }
        } else if (TestUtil.harnessDebug) {
            TestUtil.logHarnessDebug("Deployment of apps disabled due to execute mode being set to:" + String.valueOf(this.executionMode));
        }
        return sClientClassPaths;
    }

    private DeploymentInfo getDeploymentInfo(String earFile, String sAppJar, String sFileNameMinusExtension, String[] sValidRuntimeInfoFilesArray) throws TSDeploymentException {
        String sRuntimeInfoFiles = "";
        if (sValidRuntimeInfoFilesArray != null) {
            for (int j = 0; j < sValidRuntimeInfoFilesArray.length; ++j) {
                sRuntimeInfoFiles = sRuntimeInfoFiles + sValidRuntimeInfoFilesArray[j] + " ";
            }
        }
        if (TestUtil.harnessDebug) {
            TestUtil.logHarnessDebug(sFileNameMinusExtension + " ear_file = " + earFile + "\n" + sFileNameMinusExtension + " runtime files = " + sRuntimeInfoFiles);
        }
        try {
            DeploymentInfo deploymentInfo = deliv.getDeploymentInfo(earFile, sValidRuntimeInfoFilesArray);
            return deploymentInfo;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new TSDeploymentException("Exception reading runtime information from Deliverable instance: " + e.getMessage());
        }
    }

    private void populatePortingReplacementTables(String sDir, String[] sAppJarsArray) throws TSDeploymentException {
        String sFileNameMinusExtension = "";
        String[] sValidRuntimeInfoFilesArray = null;
        String earFile = "";
        File fTestDir = new File(sDir);
        String[] sRuntimeInfoFilesArray = fTestDir.list(RuntimeInfoFilter.getInstance());
        if (sAppJarsArray == null || sAppJarsArray.length < 1) {
            return;
        }
        DeploymentInfo[] infoArray = new DeploymentInfo[sAppJarsArray.length];
        for (int ii = 0; ii < sAppJarsArray.length; ++ii) {
            earFile = sDir + File.separator + sAppJarsArray[ii];
            if (TestUtil.harnessDebug) {
                TestUtil.logHarnessDebug("earFile = " + earFile);
            }
            sFileNameMinusExtension = sAppJarsArray[ii].substring(0, sAppJarsArray[ii].lastIndexOf("."));
            sValidRuntimeInfoFilesArray = this.getValidRuntimeInfoFiles(sDir + File.separator + sAppJarsArray[ii], sRuntimeInfoFilesArray, sDir, null, false);
            infoArray[ii] = this.getDeploymentInfo(earFile, sAppJarsArray[ii], sFileNameMinusExtension, sValidRuntimeInfoFilesArray);
        }
        TSDeploymentInterface ctsDeploy1 = (TSDeploymentInterface)htTSDeployers.get("cts1");
        TSDeploymentInterface ctsDeploy2 = this.isInteropDir(sDir) ? (TSDeploymentInterface)htTSDeployers.get("cts2") : ctsDeploy1;
        if (bReversed) {
            htJNDIMapsFromServer1.putAll(ctsDeploy2.getInteropJNDINames(infoArray));
            htJNDIMapsFromServer2.putAll(ctsDeploy1.getInteropJNDINames(infoArray));
            sInteropDirectionWhenTablesWerePopulated = "reverse";
        } else {
            htJNDIMapsFromServer1.putAll(ctsDeploy1.getInteropJNDINames(infoArray));
            htJNDIMapsFromServer2.putAll(ctsDeploy2.getInteropJNDINames(infoArray));
            sInteropDirectionWhenTablesWerePopulated = "forward";
        }
        if (TestUtil.harnessDebug) {
            this.printAllMappings();
        }
    }

    private void printAllMappings() {
        String sKey;
        TestUtil.logHarness("RuntimeInfo mappings from Porting impl 1");
        Enumeration e = htJNDIMapsFromServer1.keys();
        while (e.hasMoreElements()) {
            sKey = (String)e.nextElement();
            TestUtil.logHarness("----------------------------------------");
            TestUtil.logHarness("RuntimeInfo key:  " + sKey);
            TestUtil.logHarness("To be replaced with:  " + (String)htJNDIMapsFromServer1.get(sKey));
            TestUtil.logHarness("----------------------------------------");
        }
        TestUtil.logHarness("RuntimeInfo mappings from Porting impl 2");
        e = htJNDIMapsFromServer2.keys();
        while (e.hasMoreElements()) {
            sKey = (String)e.nextElement();
            TestUtil.logHarness("----------------------------------------");
            TestUtil.logHarness("RuntimeInfo key:  " + sKey);
            TestUtil.logHarness("To be replaced with:  " + (String)htJNDIMapsFromServer2.get(sKey));
            TestUtil.logHarness("----------------------------------------");
        }
    }

    private String continueToDeployApps(String sDir, String[] sAppJarsArray) throws TSDeploymentException, TSJMSAdminException {
        DeploymentInfo deploymentInfo = null;
        String sClientClassPaths = "";
        File fTestDir = new File(sDir);
        String[] sRuntimeInfoFilesArray = fTestDir.list(RuntimeInfoFilter.getInstance());
        String[] sValidRuntimeInfoFilesArray = null;
        String sFileNameMinusExtension = "";
        String sRuntimeFileMinusExtension = "";
        String sRuntimeInfoFiles = "";
        TSDeploymentInterface ctsDeploy = null;
        TSJMSAdminInterface ctsJMS = null;
        String[] sQueues = null;
        String[] sTopics = null;
        String earFile = "";
        if (sAppJarsArray == null || sAppJarsArray.length < 1) {
            TestUtil.logHarness("There are no archives to deploy in this directory:  " + sDir);
            return "";
        }
        Arrays.sort(sAppJarsArray);
        for (int ii = 0; ii < sAppJarsArray.length; ++ii) {
            earFile = sDir + File.separator + sAppJarsArray[ii];
            if (TestUtil.harnessDebug) {
                TestUtil.logHarnessDebug("earFile = " + earFile);
            }
            sFileNameMinusExtension = sAppJarsArray[ii].substring(0, sAppJarsArray[ii].lastIndexOf("."));
            Hashtable oppositeServerJNDITable = null;
            oppositeServerJNDITable = sInteropDirectionWhenTablesWerePopulated.equals("forward") ? (sFileNameMinusExtension.indexOf("_j2ee2") != -1 || sFileNameMinusExtension.startsWith("vi_built_") ? htJNDIMapsFromServer1 : htJNDIMapsFromServer2) : (sFileNameMinusExtension.indexOf("_j2ee2") != -1 || sFileNameMinusExtension.startsWith("vi_built_") ? htJNDIMapsFromServer2 : htJNDIMapsFromServer1);
            if (this.bSweepRebuildableReverseRuntimeFiles) {
                this.swapSettings("reverse");
            }
            sValidRuntimeInfoFilesArray = this.getValidRuntimeInfoFiles(sDir + File.separator + sAppJarsArray[ii], sRuntimeInfoFilesArray, sDir, oppositeServerJNDITable, true);
            if (this.bSweepRebuildableReverseRuntimeFiles) {
                this.swapSettings("forward");
            }
            deploymentInfo = this.getDeploymentInfo(earFile, sAppJarsArray[ii], sFileNameMinusExtension, sValidRuntimeInfoFilesArray);
            if (bDeployingCommonApps) {
                vCommonDeploymentInfos.addElement(deploymentInfo);
            }
            vCurrentDeploymentInfos.addElement(deploymentInfo);
            deploymentInfo.setPreviousInfos(vCurrentDeploymentInfos.toArray(new DeploymentInfo[vCurrentDeploymentInfos.size()]));
            if (!sClientClassPaths.equals("")) {
                sClientClassPaths = sClientClassPaths + File.pathSeparator;
            }
            if (TestUtil.harnessDebug) {
                TestUtil.logHarnessDebug("generateSQL is set to:  " + deploymentInfo.getProperty("generateSQL"));
            }
            try {
                String sElement;
                Enumeration e;
                String[] sQueueFactoryProps;
                Hashtable htQueueFactories;
                String sElement2;
                Enumeration e2;
                int jj;
                String[] sTopicFactoryProps;
                int iSize;
                Hashtable htTopicFactories;
                if (sFileNameMinusExtension.indexOf("_j2ee2") != -1 || sFileNameMinusExtension.startsWith("vi_built_")) {
                    deploymentInfo.setProperty("deployment_host", this.jteMgr.getProperty("deployment_host.2"));
                    deploymentInfo.setProperty("deployment_port", this.jteMgr.getProperty("deployment_port.2"));
                    deploymentInfo.setProperty("deployment.props.number", "2");
                    ctsDeploy = (TSDeploymentInterface)htTSDeployers.get("cts2");
                    if (bSupportsAutoJMS) {
                        ctsJMS = (TSJMSAdminInterface)htTSJMSAdmins.get("cts2");
                        sQueues = TSJMSAdmin.getQueues(sDir, 2);
                        sTopics = TSJMSAdmin.getTopics(sDir, 2);
                        if (bCreateConnectionFactories2 && TSJMSAdmin.requiresJmsFactories(sDir)) {
                            htTopicFactories = TSJMSAdmin.getTopicConnectionFactories(2);
                            iSize = htTopicFactories.size();
                            sTopicFactories2 = new String[iSize];
                            sTopicFactoryProps = new String[iSize];
                            jj = 0;
                            e2 = htTopicFactories.keys();
                            while (e2.hasMoreElements()) {
                                SuiteSynchronizer.sTopicFactories2[jj] = sElement2 = (String)e2.nextElement();
                                sTopicFactoryProps[jj] = (String)htTopicFactories.get(sElement2);
                                ++jj;
                            }
                            ctsJMS.createTopicConnectionFactories(sTopicFactories2, sTopicFactoryProps);
                            htQueueFactories = TSJMSAdmin.getQueueConnectionFactories(2);
                            iSize = htQueueFactories.size();
                            sQueueFactories2 = new String[iSize];
                            sQueueFactoryProps = new String[iSize];
                            jj = 0;
                            e = htQueueFactories.keys();
                            while (e.hasMoreElements()) {
                                SuiteSynchronizer.sQueueFactories2[jj] = sElement = (String)e.nextElement();
                                sQueueFactoryProps[jj] = (String)htQueueFactories.get(sElement);
                                ++jj;
                            }
                            ctsJMS.createQueueConnectionFactories(sQueueFactories2, sQueueFactoryProps);
                            bCreateConnectionFactories2 = false;
                        }
                    }
                } else {
                    deploymentInfo.setProperty("deployment_host", this.jteMgr.getProperty("deployment_host.1"));
                    deploymentInfo.setProperty("deployment_port", this.jteMgr.getProperty("deployment_port.1"));
                    deploymentInfo.setProperty("deployment.props.number", "1");
                    ctsDeploy = (TSDeploymentInterface)htTSDeployers.get("cts1");
                    if (bSupportsAutoJMS) {
                        ctsJMS = (TSJMSAdminInterface)htTSJMSAdmins.get("cts1");
                        sQueues = TSJMSAdmin.getQueues(sDir, 1);
                        sTopics = TSJMSAdmin.getTopics(sDir, 1);
                        if (bCreateConnectionFactories1 && TSJMSAdmin.requiresJmsFactories(sDir)) {
                            htTopicFactories = TSJMSAdmin.getTopicConnectionFactories(1);
                            iSize = htTopicFactories.size();
                            sTopicFactories1 = new String[iSize];
                            sTopicFactoryProps = new String[iSize];
                            jj = 0;
                            e2 = htTopicFactories.keys();
                            while (e2.hasMoreElements()) {
                                SuiteSynchronizer.sTopicFactories1[jj] = sElement2 = (String)e2.nextElement();
                                sTopicFactoryProps[jj] = (String)htTopicFactories.get(sElement2);
                                ++jj;
                            }
                            ctsJMS.createTopicConnectionFactories(sTopicFactories1, sTopicFactoryProps);
                            htQueueFactories = TSJMSAdmin.getQueueConnectionFactories(1);
                            iSize = htQueueFactories.size();
                            sQueueFactories1 = new String[iSize];
                            sQueueFactoryProps = new String[iSize];
                            jj = 0;
                            e = htQueueFactories.keys();
                            while (e.hasMoreElements()) {
                                SuiteSynchronizer.sQueueFactories1[jj] = sElement = (String)e.nextElement();
                                sQueueFactoryProps[jj] = (String)htQueueFactories.get(sElement);
                                ++jj;
                            }
                            ctsJMS.createQueueConnectionFactories(sQueueFactories1, sQueueFactoryProps);
                            bCreateConnectionFactories1 = false;
                        }
                    }
                }
            }
            catch (PropertyNotSetException e) {
                e.printStackTrace();
                throw new TSDeploymentException("Failed to get values for deployment_host properties.");
            }
            if (bSupportsAutoJMS) {
                if (sQueues != null) {
                    ctsJMS.createQueues(sQueues);
                }
                if (sTopics != null) {
                    ctsJMS.createTopics(sTopics);
                }
            }
            if (earFile.endsWith(".rar")) {
                try {
                    Properties connectorProps = new Properties();
                    connectorProps.setProperty("rar_file", earFile);
                    connectorProps.setProperty("deployment_host", deploymentInfo.getProperty("deployment_host"));
                    connectorProps.setProperty("deployment_port", deploymentInfo.getProperty("deployment_port"));
                    connectorProps.setProperty("deployment.props.number", deploymentInfo.getProperty("deployment.props.number"));
                    ctsDeploy.deployConnector(connectorProps);
                    continue;
                }
                catch (TSDeploymentException e) {
                    this.logOut.println("Failed to deploy Connector:  " + earFile);
                    e.printStackTrace();
                    throw e;
                }
            }
            if ((sClientClassPaths = sClientClassPaths + ctsDeploy.deploy(deploymentInfo)).endsWith(File.pathSeparator)) continue;
            sClientClassPaths = sClientClassPaths + File.pathSeparator;
        }
        return sClientClassPaths;
    }

    private void undeployApps(String sDir) throws TSDeploymentException, TSJMSAdminException {
        if (this.executionMode == 0 || this.executionMode == 3) {
            String sInteropDirections = InteropTestManager.getInteropDirectionsFromKeywords(sDir);
            if (TestUtil.harnessDebug) {
                TestUtil.logHarnessDebug("undeployApps - InteropDirections:  " + sInteropDirections);
            }
            String[] sAppJarsArray = ProfileHelper.getArchives(sDir, sInteropDirections);
            if (sInteropDirections.equals("forward") || sInteropDirections.equals("both")) {
                this.swapSettings("forward");
                TestUtil.logHarness("Undeploying apps...");
                this.continueToUndeployApps(sDir, sAppJarsArray);
            }
            if (sInteropDirections.equals("reverse") || sInteropDirections.equals("both")) {
                if (this.isInteropDir(sDir)) {
                    this.swapSettings("reverse");
                    TestUtil.logHarness("Deploying apps for reverse run...");
                    this.continueToUndeployApps(sDir, sAppJarsArray);
                } else {
                    this.swapSettings("forward");
                    if (sInteropDirections.equals("reverse")) {
                        TestUtil.logHarness("Undeploying apps for reverse rebuildable...");
                        this.continueToUndeployApps(sDir, sAppJarsArray);
                    }
                }
            }
        } else if (TestUtil.harnessDebug) {
            TestUtil.logHarnessDebug("Undeployment of apps disabled due to execute mode being set to:" + String.valueOf(this.executionMode));
        }
    }

    private void continueToUndeployApps(String sDir, String[] sAppJarsArray) throws TSDeploymentException, TSJMSAdminException {
        File fTestDir = new File(sDir);
        String sFileNameMinusExtension = "";
        TSDeploymentInterface ctsDeploy = null;
        TSJMSAdminInterface ctsJMS = null;
        String[] sQueues = null;
        String[] sTopics = null;
        if (sAppJarsArray == null) {
            TestUtil.logHarness("There are no archives to undeploy in this directory:  " + sDir);
            return;
        }
        for (int ii = 0; ii < sAppJarsArray.length; ++ii) {
            sFileNameMinusExtension = sAppJarsArray[ii].substring(0, sAppJarsArray[ii].lastIndexOf("."));
            this.pDeployProps.put("ear_file", sDir + File.separator + sAppJarsArray[ii]);
            if (TestUtil.harnessDebug) {
                TestUtil.logHarnessDebug(sFileNameMinusExtension + " ear_file = " + sDir + File.separator + sAppJarsArray[ii]);
            }
            try {
                if (sFileNameMinusExtension.indexOf("_j2ee2") != -1 || sFileNameMinusExtension.startsWith("vi_built_")) {
                    this.pDeployProps.setProperty("deployment_host", this.jteMgr.getProperty("deployment_host.2"));
                    this.pDeployProps.setProperty("deployment_port", this.jteMgr.getProperty("deployment_port.2"));
                    this.pDeployProps.setProperty("deployment.props.number", "2");
                    ctsDeploy = (TSDeploymentInterface)htTSDeployers.get("cts2");
                    if (bSupportsAutoJMS) {
                        ctsJMS = (TSJMSAdminInterface)htTSJMSAdmins.get("cts2");
                        sQueues = TSJMSAdmin.getQueues(sDir, 2);
                        sTopics = TSJMSAdmin.getTopics(sDir, 2);
                    }
                } else {
                    this.pDeployProps.setProperty("deployment_host", this.jteMgr.getProperty("deployment_host.1"));
                    this.pDeployProps.setProperty("deployment_port", this.jteMgr.getProperty("deployment_port.1"));
                    this.pDeployProps.setProperty("deployment.props.number", "1");
                    ctsDeploy = (TSDeploymentInterface)htTSDeployers.get("cts1");
                    if (bSupportsAutoJMS) {
                        ctsJMS = (TSJMSAdminInterface)htTSJMSAdmins.get("cts1");
                        sQueues = TSJMSAdmin.getQueues(sDir, 1);
                        sTopics = TSJMSAdmin.getTopics(sDir, 1);
                    }
                }
            }
            catch (PropertyNotSetException e) {
                e.printStackTrace();
                throw new TSDeploymentException("Failed to get values for deployment_host properties.");
            }
            String earFile = this.pDeployProps.getProperty("ear_file");
            if (earFile.endsWith(".rar")) {
                try {
                    Properties connectorProps = new Properties();
                    connectorProps.setProperty("rar_file", earFile);
                    connectorProps.setProperty("deployment_host", this.pDeployProps.getProperty("deployment_host"));
                    connectorProps.setProperty("deployment_port", this.pDeployProps.getProperty("deployment_port"));
                    connectorProps.setProperty("deployment.props.number", this.pDeployProps.getProperty("deployment.props.number"));
                    if (!ctsDeploy.isConnectorDeployed(connectorProps)) continue;
                    ctsDeploy.undeployConnector(connectorProps);
                    continue;
                }
                catch (TSDeploymentException e) {
                    this.logOut.println("Failed to undeploy Connector:  " + earFile);
                    e.printStackTrace();
                    throw e;
                }
            }
            if (!ctsDeploy.isDeployed(this.pDeployProps)) continue;
            ctsDeploy.undeploy(this.pDeployProps);
            this.logOut.println("Successfully undeployed app:  " + sDir + File.separator + sAppJarsArray[ii]);
            if (!bSupportsAutoJMS) continue;
            if (sQueues != null) {
                ctsJMS.removeQueues(sQueues);
            }
            if (sTopics == null) continue;
            ctsJMS.removeTopics(sTopics);
        }
    }

    private void swap() {
        if (bSupportsAutoDeploy) {
            Object cts1 = htTSDeployers.get("cts1");
            Object jms1 = htTSJMSAdmins.get("cts1");
            Object cts2 = htTSDeployers.get("cts2");
            Object jms2 = htTSJMSAdmins.get("cts2");
            htTSDeployers.put("cts1", cts2);
            htTSDeployers.put("cts2", cts1);
            htTSJMSAdmins.put("cts1", jms2);
            htTSJMSAdmins.put("cts2", jms1);
        }
        try {
            runtimeConfig = new TSRuntimeConfiguration(this.logOut);
            TestUtil.logHarness("ss:  modified runtime.xml");
        }
        catch (Exception e) {
            e.printStackTrace();
            TestUtil.logHarness("Failed to modify xml files with correct settings.  Please check the values of 'mailHost, mailFrom, webServerHost, and webServerPort'");
        }
    }

    public void swapSettings(String sDirection) {
        TestUtil.logHarnessDebug("*******swapSettings CALLED with direction:  " + sDirection);
        if (sDirection.equals("reverse")) {
            if (bReversed) {
                return;
            }
            try {
                this.jteMgr = deliv.getPropertyManager();
                this.jteMgr.swapInteropPropertyValues(sDirection);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            bReversed = true;
            this.swap();
        } else {
            if (!bReversed) {
                return;
            }
            try {
                this.jteMgr = deliv.getPropertyManager();
                this.jteMgr.swapInteropPropertyValues(sDirection);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            bReversed = false;
            this.swap();
        }
    }

    static {
        vCommonAppsDeployedThisJVM = new Vector();
        sDeployStatus = "passed";
        sDeployStackTrace = "";
        bCreateConnectionFactories1 = true;
        bCreateConnectionFactories2 = true;
        vCommonDeploymentInfos = new Vector();
        vCurrentDeploymentInfos = new Vector();
        bSupportsAutoDeploy = true;
        bSupportsAutoJMS = true;
        bSupportsInterop = true;
    }

    public static class RuntimeInfoFilter
    implements FilenameFilter {
        private static RuntimeInfoFilter instance = new RuntimeInfoFilter();

        private RuntimeInfoFilter() {
        }

        public static RuntimeInfoFilter getInstance() {
            return instance;
        }

        @Override
        public boolean accept(File dir, String name) {
            boolean bReturn = false;
            if (name.endsWith(".xml") && (name.indexOf(".sun-") != -1 || name.startsWith("sun-")) || name.endsWith("dbschema")) {
                bReturn = true;
            }
            return bReturn;
        }
    }
}

