/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jaxb;

import org.eclipse.persistence.exceptions.DescriptorException;
import org.eclipse.persistence.internal.core.helper.CoreClassConstants;
import org.eclipse.persistence.internal.descriptors.MethodAttributeAccessor;
import org.eclipse.persistence.internal.helper.Helper;

public class JAXBSetMethodAttributeAccessor
extends MethodAttributeAccessor {
    String parameterTypeAsString;
    ClassLoader loader;
    Class attributeClassification = CoreClassConstants.OBJECT;

    public JAXBSetMethodAttributeAccessor(String parameterTypeAsString, ClassLoader loader) {
        this.parameterTypeAsString = parameterTypeAsString;
        this.loader = loader;
    }

    public void initializeAttributes(Class theJavaClass) throws DescriptorException {
        if (this.getAttributeName() == null) {
            throw DescriptorException.attributeNameNotSpecified();
        }
        try {
            if (!this.isWriteOnly()) {
                Class[] parameterTypes = new Class[]{Helper.getClassFromClasseName((String)this.parameterTypeAsString, (ClassLoader)this.loader)};
                this.attributeClassification = parameterTypes[0];
                this.setSetMethod(Helper.getDeclaredMethod((Class)theJavaClass, (String)this.setMethodName, (Class[])parameterTypes));
            }
        }
        catch (NoSuchMethodException ex) {
            DescriptorException descriptorException = DescriptorException.noSuchMethodWhileInitializingAttributesInMethodAccessor((String)this.getSetMethodName(), (String)this.getGetMethodName(), (String)theJavaClass.getName());
            descriptorException.setInternalException((Throwable)ex);
            throw descriptorException;
        }
    }

    public Class getAttributeClass() {
        return this.attributeClassification;
    }
}

