/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.pfl.dynamic.codegen.impl;

import java.util.ArrayList;
import java.util.List;
import org.glassfish.pfl.dynamic.codegen.impl.AttributedObject;
import org.glassfish.pfl.dynamic.copyobject.spi.Copy;
import org.glassfish.pfl.dynamic.copyobject.spi.CopyInterceptor;
import org.glassfish.pfl.dynamic.copyobject.spi.CopyType;

public class AttributedObjectBase
implements AttributedObject,
CopyInterceptor {
    @Copy(value=CopyType.SOURCE)
    private AttributedObjectBase delegate = null;
    @Copy(value=CopyType.NULL)
    private ArrayList<Object> attributes = null;

    @Override
    public void preCopy() {
        if (this.attributes != null) {
            AttributedObjectBase base = new AttributedObjectBase();
            base.delegate = this.delegate;
            this.delegate = base;
            base.attributes = this.attributes;
            this.attributes = null;
        }
    }

    @Override
    public void postCopy() {
        if (this.delegate != null) {
            this.delegate = this.delegate.delegate;
        }
    }

    private void ensure(int index) {
        if (this.attributes == null) {
            this.attributes = new ArrayList(index + 1);
        } else {
            this.attributes.ensureCapacity(index + 1);
        }
        for (int ctr = this.attributes.size(); ctr <= index; ++ctr) {
            this.attributes.add(null);
        }
    }

    @Override
    public final Object get(int index) {
        this.ensure(index);
        Object result = null;
        if (this.attributes != null) {
            result = this.attributes.get(index);
        }
        if (result == null && this.delegate != null) {
            result = this.delegate.get(index);
        }
        return result;
    }

    @Override
    public final void set(int index, Object obj) {
        this.ensure(index);
        this.attributes.set(index, obj);
    }

    @Override
    public final List<Object> attributes() {
        int ctr;
        List<Object> delAttrs = null;
        if (this.delegate != null) {
            delAttrs = this.delegate.attributes();
        }
        if (delAttrs == null) {
            return this.attributes;
        }
        int len = Math.max(this.attributes.size(), delAttrs.size());
        ArrayList<Object> result = new ArrayList<Object>(len);
        for (ctr = 0; ctr < len; ++ctr) {
            result.add(null);
        }
        for (ctr = 0; ctr < len; ++ctr) {
            Object attrElem = null;
            if (ctr < this.attributes.size()) {
                attrElem = this.attributes.get(ctr);
            }
            Object delAttrElem = null;
            if (ctr < delAttrs.size()) {
                delAttrElem = delAttrs.get(ctr);
            }
            if (attrElem != null) {
                result.set(ctr, attrElem);
                continue;
            }
            if (delAttrElem == null) continue;
            result.set(ctr, delAttrElem);
        }
        return result;
    }
}

