/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jpa.jpql.tools.model.query;

import java.io.IOException;
import java.util.List;
import org.eclipse.persistence.jpa.jpql.parser.CaseExpression;
import org.eclipse.persistence.jpa.jpql.tools.model.Problem;
import org.eclipse.persistence.jpa.jpql.tools.model.query.AbstractListHolderStateObject;
import org.eclipse.persistence.jpa.jpql.tools.model.query.StateObject;
import org.eclipse.persistence.jpa.jpql.tools.model.query.StateObjectVisitor;
import org.eclipse.persistence.jpa.jpql.tools.model.query.WhenClauseStateObject;

public class CaseExpressionStateObject
extends AbstractListHolderStateObject<WhenClauseStateObject> {
    private StateObject caseOperandStateObject;
    private StateObject elseStateObject;
    public static final String CASE_OPERAND_STATE_OBJECT_PROPERTY = "caseOperandStateObject";
    public static final String ELSE_STATE_OBJECT_PROPERTY = "elseStateObject";
    public static final String WHEN_CLAUSE_STATE_OBJECT_LIST = "whenStateObjects";

    public CaseExpressionStateObject(StateObject parent) {
        super(parent);
    }

    public CaseExpressionStateObject(StateObject parent, List<WhenClauseStateObject> whenClauseStateObjects, StateObject elseStateObject) {
        this(parent, null, whenClauseStateObjects, elseStateObject);
    }

    public CaseExpressionStateObject(StateObject parent, StateObject caseOperandStateObject, List<WhenClauseStateObject> whenClauseStateObjects, StateObject elseStateObject) {
        super(parent, whenClauseStateObjects);
        this.elseStateObject = this.parent(elseStateObject);
        this.caseOperandStateObject = this.parent(caseOperandStateObject);
    }

    @Override
    public void accept(StateObjectVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    protected void addChildren(List<StateObject> children) {
        if (this.caseOperandStateObject != null) {
            children.add(this.caseOperandStateObject);
        }
        super.addChildren(children);
        if (this.elseStateObject != null) {
            children.add(this.elseStateObject);
        }
    }

    @Override
    protected void addProblems(List<Problem> problems) {
        super.addProblems(problems);
    }

    public WhenClauseStateObject addWhenClause() {
        WhenClauseStateObject whenClause = new WhenClauseStateObject(this);
        this.addItem(whenClause);
        return whenClause;
    }

    public WhenClauseStateObject addWhenClause(StateObject whenStateObject, StateObject thenStateObject) {
        WhenClauseStateObject whenClause = new WhenClauseStateObject(this, whenStateObject, thenStateObject);
        this.addItem(whenClause);
        return whenClause;
    }

    public WhenClauseStateObject addWhenClause(String whenJpqlFragment, String thenJpqlFragment) {
        WhenClauseStateObject whenClause = new WhenClauseStateObject(this);
        whenClause.parseWhen(whenJpqlFragment);
        whenClause.parseThen(thenJpqlFragment);
        this.addItem(whenClause);
        return whenClause;
    }

    public StateObject getCaseOperand() {
        return this.caseOperandStateObject;
    }

    public StateObject getElse() {
        return this.elseStateObject;
    }

    @Override
    public CaseExpression getExpression() {
        return (CaseExpression)super.getExpression();
    }

    public boolean hasCaseOperand() {
        return this.caseOperandStateObject != null;
    }

    public boolean hasElse() {
        return this.elseStateObject != null;
    }

    @Override
    public boolean isEquivalent(StateObject stateObject) {
        if (super.isEquivalent(stateObject)) {
            CaseExpressionStateObject caseExpression = (CaseExpressionStateObject)stateObject;
            return this.areEquivalent(this.elseStateObject, caseExpression.elseStateObject) && this.areEquivalent(this.caseOperandStateObject, caseExpression.caseOperandStateObject) && this.areChildrenEquivalent(caseExpression);
        }
        return false;
    }

    @Override
    protected String listName() {
        return WHEN_CLAUSE_STATE_OBJECT_LIST;
    }

    public void parseCaseOperand(String jpqlFragment) {
        Object stateObject = this.buildStateObject(jpqlFragment, "case_operand");
        this.setCaseOperand((StateObject)stateObject);
    }

    public void parseElse(String jpqlFragment) {
        Object stateObject = this.buildStateObject(jpqlFragment, "else_expression");
        this.setElse((StateObject)stateObject);
    }

    public void removeCaseOperand() {
        this.setCaseOperand(null);
    }

    public void setCaseOperand(StateObject caseOperand) {
        StateObject oldCaseOperandStateObject = this.caseOperandStateObject;
        this.caseOperandStateObject = this.parent(caseOperand);
        this.firePropertyChanged(CASE_OPERAND_STATE_OBJECT_PROPERTY, oldCaseOperandStateObject, caseOperand);
    }

    public void setElse(StateObject elseStateObject) {
        StateObject oldElseStateObject = this.elseStateObject;
        this.elseStateObject = this.parent(elseStateObject);
        this.firePropertyChanged(ELSE_STATE_OBJECT_PROPERTY, oldElseStateObject, elseStateObject);
    }

    public void setExpression(CaseExpression expression) {
        super.setExpression(expression);
    }

    @Override
    public void toTextInternal(Appendable writer) throws IOException {
        writer.append("CASE");
        writer.append(' ');
        if (this.hasCaseOperand()) {
            this.caseOperandStateObject.toString(writer);
            writer.append(' ');
        }
        if (this.hasItems()) {
            this.toStringItems(writer, false);
            writer.append(' ');
        }
        writer.append("ELSE");
        writer.append(' ');
        if (this.hasElse()) {
            this.elseStateObject.toString(writer);
            writer.append(' ');
        }
        writer.append("END");
    }
}

