/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.expressions;

import java.util.Map;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.expressions.ExpressionOperator;
import org.eclipse.persistence.expressions.ListExpressionOperator;
import org.eclipse.persistence.internal.databaseaccess.DatabasePlatform;
import org.eclipse.persistence.internal.expressions.ExpressionSQLPrinter;
import org.eclipse.persistence.internal.expressions.FunctionExpression;

public class ArgumentListFunctionExpression
extends FunctionExpression {
    protected Boolean hasLastChild = Boolean.FALSE;

    @Override
    public synchronized void addChild(Expression argument) {
        if (this.hasLastChild != null && this.hasLastChild.booleanValue()) {
            this.getChildren().add(this.getChildren().size() - 1, argument);
        } else {
            super.addChild(argument);
        }
        this.setBaseExpression(this.getChildren().firstElement());
        ((ListExpressionOperator)this.operator).incrementNumberOfItems();
    }

    public synchronized void addRightMostChild(Expression argument) {
        if (this.hasLastChild != null && this.hasLastChild.booleanValue()) {
            this.getChildren().remove(super.getChildren().size() - 1);
            super.addChild(argument);
        } else {
            this.addChild(argument);
        }
        this.hasLastChild = Boolean.TRUE;
    }

    @Override
    public void setOperator(ExpressionOperator theOperator) {
        assert (theOperator instanceof ListExpressionOperator);
        super.setOperator(theOperator);
        ((ListExpressionOperator)theOperator).setNumberOfItems(0);
    }

    @Override
    public void printSQL(ExpressionSQLPrinter printer) {
        ListExpressionOperator platformOperator = (ListExpressionOperator)this.getPlatformOperator(printer.getPlatform());
        platformOperator.copyTo(this.operator);
        ((ListExpressionOperator)this.operator).setIsComplete(true);
        this.operator.printCollection(this.getChildren(), printer);
    }

    @Override
    protected void postCopyIn(Map alreadyDone) {
        ((ListExpressionOperator)this.operator).setNumberOfItems(0);
        Boolean hasLastChildCopy = this.hasLastChild;
        this.hasLastChild = null;
        super.postCopyIn(alreadyDone);
        this.hasLastChild = hasLastChildCopy;
    }

    @Override
    public void initializePlatformOperator(DatabasePlatform platform) {
        super.initializePlatformOperator(platform);
        ((ListExpressionOperator)this.platformOperator).setNumberOfItems(((ListExpressionOperator)this.operator).getNumberOfItems());
    }
}

