/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.lib.implementation.sun.javaee.runtime;

import com.sun.ts.lib.deliverable.DeliverableFactory;
import com.sun.ts.lib.deliverable.PropertyManagerInterface;
import com.sun.ts.lib.implementation.sun.javaee.runtime.app.SunApplication;
import com.sun.ts.lib.implementation.sun.javaee.runtime.appclient.SunApplicationClient;
import com.sun.ts.lib.implementation.sun.javaee.runtime.ejb.SunEjbJar;
import com.sun.ts.lib.implementation.sun.javaee.runtime.web.SunWebApp;
import com.sun.ts.lib.porting.DeploymentInfo;
import com.sun.ts.lib.util.TestUtil;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Unmarshaller;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Source;
import javax.xml.transform.sax.SAXSource;
import org.jdom.Document;
import org.jdom.input.SAXBuilder;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;

public class SunRIDeploymentInfo
implements DeploymentInfo,
Serializable {
    private static final String EJB_PARSE_PKG = "com.sun.ts.lib.implementation.sun.javaee.runtime.ejb";
    private static final String WEB_PARSE_PKG = "com.sun.ts.lib.implementation.sun.javaee.runtime.web";
    private static final String APP_PARSE_PKG = "com.sun.ts.lib.implementation.sun.javaee.runtime.app";
    private static final String APC_PARSE_PKG = "com.sun.ts.lib.implementation.sun.javaee.runtime.appclient";
    private static final String EJB_RUNTIME_FILE = "sun-ejb-jar.xml";
    private static final String WEB_RUNTIME_FILE = "sun-web.xml";
    private static final String APC_RUNTIME_FILE = "sun-application-client.xml";
    private static final String APP_RUNTIME_FILE = "sun-application.xml";
    private Map ejbRuntimeData = new HashMap();
    private Map webRuntimeData = new HashMap();
    private Map appRuntimeData = new HashMap();
    private Map appClientRuntimeData = new HashMap();
    private String earFile;
    private String[] runtimeFiles;
    protected DeploymentInfo[] prevDeployInfos = null;
    protected Properties properties = new Properties();

    public SunRIDeploymentInfo(String earFile, String[] runtimeFiles) throws IOException, DeploymentInfo.ParseException {
        this.earFile = earFile;
        this.runtimeFiles = runtimeFiles;
        this.setProperty("generateSQL", "false");
        this.unmarshalFiles(runtimeFiles);
    }

    public void setProperty(String key, String value) {
        this.properties.setProperty(key, value);
    }

    public String getProperty(String key) {
        return this.properties.getProperty(key);
    }

    public void setPreviousInfos(DeploymentInfo[] infos) {
        this.prevDeployInfos = infos;
    }

    public DeploymentInfo[] getPreviousInfos() {
        return this.prevDeployInfos;
    }

    public String getEarFile() {
        return this.earFile;
    }

    public String[] getRuntimeFiles() {
        return this.runtimeFiles;
    }

    public Map getEjbRuntimeData() {
        return this.ejbRuntimeData;
    }

    public Map getWebRuntimeData() {
        return this.webRuntimeData;
    }

    public Map getAppRuntimeData() {
        return this.appRuntimeData;
    }

    public Map getAppClientRuntimeData() {
        return this.appClientRuntimeData;
    }

    private List makeList(Map aMap) {
        ArrayList result = new ArrayList();
        if (aMap == null) {
            return result;
        }
        Iterator i = aMap.values().iterator();
        while (i.hasNext()) {
            result.add(i.next());
        }
        return result;
    }

    public List getAppClientRuntimeDDs() {
        return this.makeList(this.appClientRuntimeData);
    }

    public List getAppRuntimeDDs() {
        return this.makeList(this.appRuntimeData);
    }

    public List getWebRuntimeDDs() {
        return this.makeList(this.webRuntimeData);
    }

    public List getEjbRuntimeDDs() {
        return this.makeList(this.ejbRuntimeData);
    }

    private String normalizeFile(String fileName) {
        int index = fileName.lastIndexOf(File.separator);
        ++index;
        int index2 = fileName.indexOf(".sun-");
        if (index2 == -1) {
            index2 = fileName.length();
        }
        String result = fileName.substring(index, index2);
        return result;
    }

    private void unmarshalFiles(String[] files) throws DeploymentInfo.ParseException {
        String file = "";
        try {
            int numFiles = files == null ? 0 : files.length;
            for (int i = 0; i < numFiles; ++i) {
                file = files[i];
                if (file.endsWith(EJB_RUNTIME_FILE)) {
                    this.ejbRuntimeData.put(this.normalizeFile(file), (SunEjbJar)this.unmarshalFile(EJB_PARSE_PKG, file));
                } else if (file.endsWith(WEB_RUNTIME_FILE)) {
                    this.webRuntimeData.put(this.normalizeFile(file), (SunWebApp)this.unmarshalFile(WEB_PARSE_PKG, file));
                } else if (file.endsWith(APP_RUNTIME_FILE)) {
                    this.appRuntimeData.put(this.normalizeFile(file), (SunApplication)this.unmarshalFile(APP_PARSE_PKG, file));
                } else if (file.endsWith(APC_RUNTIME_FILE)) {
                    this.appClientRuntimeData.put(this.normalizeFile(file), (SunApplicationClient)this.unmarshalFile(APC_PARSE_PKG, file));
                } else {
                    TestUtil.logHarnessDebug((String)"Warning unknown file type found in unmarshalFiles (String[])");
                    TestUtil.logHarnessDebug((String)("\tfile name is \"" + file + "\", Ignoring file and continuing..."));
                }
                if (!TestUtil.harnessDebug) continue;
                TestUtil.logHarnessDebug((String)"###################");
                TestUtil.logHarnessDebug((String)("### DD file key was \"" + file + "\""));
                TestUtil.logHarnessDebug((String)("### DD file key is  \"" + this.normalizeFile(file) + "\""));
                TestUtil.logHarnessDebug((String)"###################");
            }
        }
        catch (Exception e) {
            TestUtil.logHarness((String)("Error unmarshalling file \"" + file + "\""));
            e.printStackTrace();
            throw new DeploymentInfo.ParseException("Error unmarshalling file \"" + file + "\"");
        }
    }

    private String getAppserverLibDir() {
        String libDir = File.separator + "j2eetck" + File.separator + "lib";
        try {
            PropertyManagerInterface propMgr = DeliverableFactory.getDeliverableInstance().getPropertyManager();
            String ctsDtdDirectory = propMgr.getProperty("ts.home", libDir);
            libDir = ctsDtdDirectory + File.separator + "lib";
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return libDir;
    }

    private Object unmarshalFile(String pkg, String aFile) throws Exception {
        SAXParserFactory spf = SAXParserFactory.newInstance();
        spf.setNamespaceAware(true);
        SAXParser saxParser = spf.newSAXParser();
        XMLReader xmlReader = saxParser.getXMLReader();
        xmlReader.setEntityResolver(new MyResolver());
        SAXSource source = new SAXSource(xmlReader, new InputSource(aFile));
        JAXBContext jc = JAXBContext.newInstance((String)pkg);
        Unmarshaller um = jc.createUnmarshaller();
        TestUtil.logHarnessDebug((String)("Unmarshalling file \"" + aFile + "\""));
        Object tree = um.unmarshal((Source)source);
        return tree;
    }

    public String getContentAsXml() {
        String NL = System.getProperty("line.separator", "\n");
        int numFiles = this.runtimeFiles == null ? 0 : this.runtimeFiles.length;
        SAXBuilder builder = new SAXBuilder(false);
        builder.setEntityResolver((EntityResolver)new MyResolver());
        File runtimeFile = null;
        StringWriter writer = new StringWriter();
        XMLOutputter out = new XMLOutputter(Format.getPrettyFormat());
        for (int i = 0; i < numFiles; ++i) {
            try {
                ((Writer)writer).write("*******************************************************************" + NL);
                ((Writer)writer).write("File: \"" + this.runtimeFiles[i] + "\"" + NL);
                runtimeFile = new File(this.runtimeFiles[i]);
                Document doc = builder.build(runtimeFile);
                out.output(doc, (Writer)writer);
                ((Writer)writer).write(NL);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
                try {
                    ((Writer)writer).write("*******************************************************************" + NL);
                    ((Writer)writer).write(NL + NL + "Error processing file \"" + this.runtimeFiles[i] + "\"" + NL + NL);
                    ((Writer)writer).write("*******************************************************************" + NL);
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        try {
            ((Writer)writer).close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return ((Object)writer).toString();
    }

    public class MyResolver
    implements EntityResolver {
        @Override
        public InputSource resolveEntity(String publicId, String systemId) {
            int index = systemId.lastIndexOf(47);
            if (index == -1) {
                index = systemId.lastIndexOf(92);
            }
            String fileName = systemId.substring(index + 1);
            String libDir = SunRIDeploymentInfo.this.getAppserverLibDir();
            String result = systemId;
            if (fileName.endsWith(".xsd")) {
                result = libDir + File.separator + "schemas" + File.separator + fileName;
            } else if (fileName.endsWith(".dtd")) {
                result = libDir + File.separator + "dtds" + File.separator + fileName;
            } else {
                TestUtil.logHarnessDebug((String)("No match for \"" + systemId + "\""));
            }
            if (new File(result).exists()) {
                TestUtil.logHarnessDebug((String)("Entity Resolver Returning \"" + result + "\""));
                return new InputSource(result);
            }
            TestUtil.logHarnessDebug((String)("Entity Resolver could not find \"" + result + "\", returning null"));
            return null;
        }
    }
}

