/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.realm;

import java.io.IOException;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import org.apache.catalina.realm.JAASRealm;

public class JAASCallbackHandler
implements CallbackHandler {
    protected char[] password = null;
    protected JAASRealm realm = null;
    protected String username = null;

    public JAASCallbackHandler(JAASRealm realm, String username, char[] password) {
        this.realm = realm;
        this.username = username;
        this.password = password != null ? (char[])password.clone() : null;
    }

    @Override
    public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
        for (int i = 0; i < callbacks.length; ++i) {
            if (callbacks[i] instanceof NameCallback) {
                if (this.realm.getDebug() >= 3) {
                    this.realm.log("Returning username " + this.username);
                }
                ((NameCallback)callbacks[i]).setName(this.username);
                continue;
            }
            if (callbacks[i] instanceof PasswordCallback) {
                char[] passwordcontents = this.password != null ? (char[])this.password.clone() : new char[]{};
                ((PasswordCallback)callbacks[i]).setPassword(passwordcontents);
                continue;
            }
            throw new UnsupportedCallbackException(callbacks[i]);
        }
    }
}

