/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata.queries;

import org.eclipse.persistence.annotations.Direction;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.helper.DatabaseType;
import org.eclipse.persistence.internal.jpa.metadata.MetadataProject;
import org.eclipse.persistence.internal.jpa.metadata.ORMetadata;
import org.eclipse.persistence.internal.jpa.metadata.accessors.MetadataAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAnnotation;
import org.eclipse.persistence.platform.database.oracle.plsql.PLSQLCursor;
import org.eclipse.persistence.platform.database.oracle.plsql.PLSQLStoredFunctionCall;
import org.eclipse.persistence.platform.database.oracle.plsql.PLSQLStoredProcedureCall;

public class PLSQLParameterMetadata
extends ORMetadata {
    private Boolean m_optional;
    private String m_direction;
    private String m_databaseType;
    private String m_name;
    private String m_queryParameter;
    private Integer m_length;
    private Integer m_precision;
    private Integer m_scale;

    public PLSQLParameterMetadata() {
        super("<plsql-parameter>");
    }

    public PLSQLParameterMetadata(MetadataAnnotation storedProcedureParameter, MetadataAccessor accessor) {
        super(storedProcedureParameter, accessor);
        this.m_direction = storedProcedureParameter.getAttributeString("direction");
        this.m_name = storedProcedureParameter.getAttributeString("name");
        this.m_queryParameter = storedProcedureParameter.getAttributeString("queryParameter");
        this.m_databaseType = storedProcedureParameter.getAttributeString("databaseType");
        this.m_optional = storedProcedureParameter.getAttributeBooleanDefaultFalse("optional");
        this.m_length = storedProcedureParameter.getAttributeInteger("length");
        this.m_precision = storedProcedureParameter.getAttributeInteger("precision");
        this.m_scale = storedProcedureParameter.getAttributeInteger("scale");
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (objectToCompare instanceof PLSQLParameterMetadata) {
            PLSQLParameterMetadata parameter = (PLSQLParameterMetadata)objectToCompare;
            if (!this.valuesMatch(this.m_databaseType, parameter.getDatabaseType())) {
                return false;
            }
            if (!this.valuesMatch(this.m_direction, parameter.getDirection())) {
                return false;
            }
            if (!this.valuesMatch(this.m_length, parameter.getLength())) {
                return false;
            }
            if (!this.valuesMatch(this.m_precision, parameter.getPrecision())) {
                return false;
            }
            if (!this.valuesMatch(this.m_name, parameter.getName())) {
                return false;
            }
            if (!this.valuesMatch(this.m_optional, parameter.getOptional())) {
                return false;
            }
            return this.valuesMatch(this.m_queryParameter, parameter.getQueryParameter());
        }
        return false;
    }

    public int hashCode() {
        int result = this.m_optional != null ? this.m_optional.hashCode() : 0;
        result = 31 * result + (this.m_direction != null ? this.m_direction.hashCode() : 0);
        result = 31 * result + (this.m_databaseType != null ? this.m_databaseType.hashCode() : 0);
        result = 31 * result + (this.m_name != null ? this.m_name.hashCode() : 0);
        result = 31 * result + (this.m_queryParameter != null ? this.m_queryParameter.hashCode() : 0);
        result = 31 * result + (this.m_length != null ? this.m_length.hashCode() : 0);
        result = 31 * result + (this.m_precision != null ? this.m_precision.hashCode() : 0);
        return result;
    }

    public String getDatabaseType() {
        return this.m_databaseType;
    }

    @Override
    protected DatabaseType getDatabaseTypeEnum(String type) {
        if (Direction.OUT_CURSOR.name().equals(this.m_direction)) {
            return new PLSQLCursor(type);
        }
        return super.getDatabaseTypeEnum(type);
    }

    public String getDirection() {
        return this.m_direction;
    }

    public Integer getLength() {
        return this.m_length;
    }

    public String getName() {
        return this.m_name;
    }

    public Boolean getOptional() {
        return this.m_optional;
    }

    public Integer getPrecision() {
        return this.m_precision;
    }

    public String getQueryParameter() {
        return this.m_queryParameter;
    }

    public Integer getScale() {
        return this.m_scale;
    }

    public void process(PLSQLStoredProcedureCall call, boolean functionReturn) {
        String procedureParameterName = this.m_name;
        if (this.m_name == null || this.m_name.equals("")) {
            procedureParameterName = this.m_queryParameter;
        }
        if (this.m_optional != null && this.m_optional.booleanValue()) {
            call.addOptionalArgument(procedureParameterName);
        }
        DatabaseType type = this.getDatabaseTypeEnum(this.getDatabaseType());
        if (functionReturn) {
            if (Direction.OUT_CURSOR.name().equals(this.m_direction)) {
                ((PLSQLStoredFunctionCall)call).getArguments().remove(0);
                ((PLSQLStoredFunctionCall)call).useNamedCursorOutputAsResultSet(Direction.OUT_CURSOR.name(), type);
            } else if (this.getLength() != null) {
                ((PLSQLStoredFunctionCall)call).setResult(type, this.getLength().intValue());
            } else if (this.getPrecision() != null) {
                ((PLSQLStoredFunctionCall)call).setResult(type, this.getPrecision().intValue(), this.getScale().intValue());
            } else {
                ((PLSQLStoredFunctionCall)call).setResult(type);
            }
        } else if (this.m_direction == null || this.m_direction.equals(Direction.IN.name())) {
            if (this.getLength() != null) {
                call.addNamedArgument(procedureParameterName, type, this.getLength().intValue());
            } else if (this.getPrecision() != null) {
                call.addNamedArgument(procedureParameterName, type, this.getPrecision().intValue(), this.getScale().intValue());
            } else {
                call.addNamedArgument(procedureParameterName, type);
            }
        } else if (this.m_direction.equals(Direction.OUT.name())) {
            if (this.getLength() != null) {
                call.addNamedOutputArgument(procedureParameterName, type, this.getLength().intValue());
            } else if (this.getPrecision() != null) {
                call.addNamedOutputArgument(procedureParameterName, type, this.getPrecision().intValue(), this.getScale().intValue());
            } else {
                call.addNamedOutputArgument(procedureParameterName, type);
            }
        } else if (this.m_direction.equals(Direction.IN_OUT.name())) {
            if (this.getLength() != null) {
                call.addNamedInOutputArgument(procedureParameterName, type, this.getLength().intValue());
            } else if (this.getPrecision() != null) {
                call.addNamedInOutputArgument(procedureParameterName, type, this.getPrecision().intValue(), this.getScale().intValue());
            } else {
                call.addNamedInOutputArgument(procedureParameterName, type);
            }
        } else if (this.m_direction.equals(Direction.OUT_CURSOR.name())) {
            boolean multipleCursors = false;
            if (call.getParameterTypes().contains(PLSQLStoredProcedureCall.OUT_CURSOR)) {
                multipleCursors = true;
            }
            call.useNamedCursorOutputAsResultSet(procedureParameterName, type);
            if (multipleCursors) {
                call.setIsCursorOutputProcedure(false);
            }
        }
    }

    protected void setDatabaseFieldSettings(DatabaseField field, MetadataProject project) {
        if (project.useDelimitedIdentifier()) {
            field.setUseDelimiters(true);
        } else if (project.getShouldForceFieldNamesToUpperCase() && !field.shouldUseDelimiters()) {
            field.useUpperCaseForComparisons(true);
        }
    }

    public void setDatabaseType(String databaseType) {
        this.m_databaseType = databaseType;
    }

    public void setDirection(String direction) {
        this.m_direction = direction;
    }

    public void setLength(Integer length) {
        this.m_length = length;
    }

    public void setName(String name) {
        this.m_name = name;
    }

    public void setOptional(Boolean optional) {
        this.m_optional = optional;
    }

    public void setPrecision(Integer precision) {
        this.m_precision = precision;
    }

    public void setQueryParameter(String queryParameter) {
        this.m_queryParameter = queryParameter;
    }

    public void setScale(Integer scale) {
        this.m_scale = scale;
    }
}

