/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.servlet.common.util;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.Cookie;

public class ServletTestUtil {
    public static final boolean DEBUG = true;

    private ServletTestUtil() {
    }

    public static boolean checkEnumeration(Enumeration e, String[] values) {
        return ServletTestUtil.checkEnumeration(e, values, true, true);
    }

    public static boolean checkEnumeration(Enumeration e, String[] values, boolean enforceSizes, boolean allowDuplicates) {
        ArrayList<Object> foundValues = null;
        if (e == null || !e.hasMoreElements() || values == null) {
            return false;
        }
        if (!allowDuplicates) {
            foundValues = new ArrayList<Object>();
        }
        boolean valuesFound = true;
        Arrays.sort(values);
        int count = 0;
        while (e.hasMoreElements()) {
            Object val;
            block9: {
                val = null;
                try {
                    val = e.nextElement();
                    ++count;
                    if (allowDuplicates) break block9;
                    if (foundValues.contains(val)) {
                        ServletTestUtil.debug("[ServletTestUtil] Duplicate values found in Enumeration when duplicates are not allowed.Values found in the Enumeration: " + ServletTestUtil.getAsString(e));
                        valuesFound = false;
                        break;
                    }
                    foundValues.add(val);
                }
                catch (NoSuchElementException nsee) {
                    ServletTestUtil.debug("[ServletTestUtil] There were less elements in the Enumeration than expected");
                    valuesFound = false;
                    break;
                }
            }
            ServletTestUtil.debug("[ServletTestUtil] Looking for '" + val + "' in values: " + ServletTestUtil.getAsString(values));
            if (Arrays.binarySearch(values, val) >= 0 || !enforceSizes) continue;
            ServletTestUtil.debug("[ServletTestUtil] Value '" + val + "' not found.");
            valuesFound = false;
        }
        if (enforceSizes) {
            if (e.hasMoreElements()) {
                ServletTestUtil.debug("[ServletTestUtil] There were more elements in the Enumeration than expected.");
                valuesFound = false;
            }
            if (count != values.length) {
                ServletTestUtil.debug("[ServletTestUtil] There number of elements in the Enumeration did not match number of expected values.Expected number of Values=" + values.length + ", Actual number of Enumeration elements=" + count);
                valuesFound = false;
            }
        }
        return valuesFound;
    }

    public static boolean checkArrayList(ArrayList al, String[] values, boolean enforceSizes, boolean allowDuplicates) {
        ArrayList<String> foundValues = null;
        if (al == null || al.isEmpty() || values == null) {
            return false;
        }
        if (!allowDuplicates) {
            foundValues = new ArrayList<String>();
        }
        al.trimToSize();
        boolean valuesFound = true;
        Arrays.sort(values);
        int len = al.size();
        for (int i = 0; i < len; ++i) {
            String val = null;
            val = (String)al.get(i);
            ServletTestUtil.debug("[ServletTestUtil] val=" + val);
            if (!allowDuplicates) {
                if (foundValues.contains(val)) {
                    ServletTestUtil.debug("[ServletTestUtil] Duplicate values found in ArrayList when duplicates are not allowed.Values found in the ArrayList: " + ServletTestUtil.getAsString(al));
                    valuesFound = false;
                    break;
                }
                foundValues.add(val);
            }
            ServletTestUtil.debug("[ServletTestUtil] Looking for '" + val + "' in values: " + ServletTestUtil.getAsString(values));
            if (Arrays.binarySearch(values, val) >= 0 || !enforceSizes) continue;
            ServletTestUtil.debug("[ServletTestUtil] Value '" + val + "' not found.");
            valuesFound = false;
        }
        if (enforceSizes && len != values.length) {
            ServletTestUtil.debug("[ServletTestUtil] There number of elements in the ArrayList did not match number of expected values.Expected number of Values=" + values.length + ", Actual number of ArrayList elements=" + len);
            valuesFound = false;
        }
        return valuesFound;
    }

    public static boolean compareString(String expected, String actual) {
        String[] list_expected = expected.split("[|]");
        boolean found = true;
        int n = list_expected.length;
        int startIdx = 0;
        int bodyLength = actual.length();
        for (int i = 0; i < n; ++i) {
            String search = list_expected[i];
            if (startIdx >= bodyLength) {
                startIdx = bodyLength;
            }
            int searchIdx = actual.toLowerCase().indexOf(search.toLowerCase(), startIdx);
            ServletTestUtil.debug("[ServletTestUtil] Scanning response for search string: '" + search + "' starting at index location: " + startIdx);
            if (searchIdx < 0) {
                found = false;
                StringBuffer sb = new StringBuffer(255);
                sb.append("[ServletTestUtil] Unable to find the following ");
                sb.append("search string in the server's ");
                sb.append("response: '").append(search).append("' at index: ");
                sb.append(startIdx);
                sb.append("\n[ServletTestUtil] Server's response:\n");
                sb.append("-------------------------------------------\n");
                sb.append(actual);
                sb.append("\n-------------------------------------------\n");
                ServletTestUtil.debug(sb.toString());
                break;
            }
            ServletTestUtil.debug("[ServletTestUtil] Found search string: '" + search + "' at index '" + searchIdx + "' in the server's response");
            startIdx = searchIdx + search.length();
        }
        return found;
    }

    public static String getAsString(Object[] sArray) {
        if (sArray == null) {
            return null;
        }
        StringBuffer buf = new StringBuffer();
        buf.append("[");
        for (int i = 0; i < sArray.length; ++i) {
            buf.append(sArray[i].toString());
            if (i + 1 == sArray.length) continue;
            buf.append(",");
        }
        buf.append("]");
        return buf.toString();
    }

    public static String getAsString(ArrayList al) {
        if (al == null) {
            return null;
        }
        StringBuffer buf = new StringBuffer();
        buf.append("[");
        al.trimToSize();
        int len = al.size();
        for (int i = 0; i < len; ++i) {
            buf.append((String)al.get(i));
            if (i + 1 == len) continue;
            buf.append(",");
        }
        buf.append("]");
        return buf.toString();
    }

    public static String getAsString(Enumeration e) {
        return ServletTestUtil.getAsString(ServletTestUtil.getAsArray(e));
    }

    public static Object[] getAsArray(Enumeration e) {
        ArrayList list = new ArrayList();
        while (e.hasMoreElements()) {
            list.add(e.nextElement());
        }
        return list.toArray(new Object[list.size()]);
    }

    public static String[] getAsArray(String value) {
        StringTokenizer st = new StringTokenizer(value, ",");
        String[] retValues = new String[st.countTokens()];
        int i = 0;
        while (st.hasMoreTokens()) {
            retValues[i] = st.nextToken();
            ++i;
        }
        return retValues;
    }

    public static void debug(String message) {
        System.out.println(message);
    }

    public static void printResult(PrintWriter pw, String s) {
        if (s == null || s.equals("")) {
            pw.println("Test PASSED");
        } else {
            pw.println("Test FAILED: " + s);
        }
    }

    public static void printResult(PrintWriter pw, boolean b) {
        if (b) {
            pw.println("Test PASSED");
        } else {
            pw.println("Test FAILED");
        }
    }

    public static void printResult(ServletOutputStream pw, boolean b) throws IOException {
        if (b) {
            pw.println("Test PASSED");
        } else {
            pw.println("Test FAILED");
        }
    }

    public static void printFailureData(PrintWriter pw, ArrayList result, Object[] expected) {
        pw.println("Unable to find the expected values:\n    " + ServletTestUtil.getAsString(expected) + "\nin the results returned by the test which were:\n   " + ServletTestUtil.getAsString(result));
    }

    public static void printFailureData(PrintWriter pw, Enumeration result, Object[] expected) {
        pw.println("Unable to find the expected values:\n    " + ServletTestUtil.getAsString(expected) + "\nin the results returned by the test which were:\n   " + ServletTestUtil.getAsString(result));
    }

    public static int findCookie(Cookie[] cookie, String name) {
        boolean found = false;
        int i = 0;
        if (cookie != null) {
            while (!found && i < cookie.length) {
                if (cookie[i].getName().equals(name)) {
                    found = true;
                    continue;
                }
                ++i;
            }
        } else {
            found = false;
        }
        if (found) {
            return i;
        }
        return -1;
    }
}

