/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.scr.impl.manager;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.felix.scr.impl.manager.AbstractComponentManager;

class EdgeInfo {
    private int open = -1;
    private int close = -1;
    private final CountDownLatch openLatch = new CountDownLatch(1);
    private final CountDownLatch closeLatch = new CountDownLatch(1);

    EdgeInfo() {
    }

    public void setClose(int close) {
        this.close = close;
    }

    public CountDownLatch getOpenLatch() {
        return this.openLatch;
    }

    public void waitForOpen(AbstractComponentManager<?> m_componentManager, String componentName, String methodName) {
        CountDownLatch latch = this.getOpenLatch();
        String latchName = "open";
        this.waitForLatch(m_componentManager, latch, componentName, methodName, latchName);
    }

    public void waitForClose(AbstractComponentManager<?> m_componentManager, String componentName, String methodName) {
        CountDownLatch latch = this.getCloseLatch();
        String latchName = "close";
        this.waitForLatch(m_componentManager, latch, componentName, methodName, latchName);
    }

    private void waitForLatch(AbstractComponentManager<?> m_componentManager, CountDownLatch latch, String componentName, String methodName, String latchName) {
        try {
            if (!latch.await(m_componentManager.getLockTimeout(), TimeUnit.MILLISECONDS)) {
                m_componentManager.log(1, "DependencyManager : {0} : timeout on {1} latch {2}", new Object[]{methodName, latchName, componentName}, null);
                m_componentManager.dumpThreads();
            }
        }
        catch (InterruptedException e) {
            try {
                if (!latch.await(m_componentManager.getLockTimeout(), TimeUnit.MILLISECONDS)) {
                    m_componentManager.log(1, "DependencyManager : {0} : timeout on {1} latch {2}", new Object[]{methodName, latchName, componentName}, null);
                    m_componentManager.dumpThreads();
                }
            }
            catch (InterruptedException e1) {
                m_componentManager.log(1, "DependencyManager : {0} : Interrupted twice on {1} latch {2}", new Object[]{methodName, latchName, componentName}, null);
                Thread.currentThread().interrupt();
            }
            Thread.currentThread().interrupt();
        }
    }

    public CountDownLatch getCloseLatch() {
        return this.closeLatch;
    }

    public void setOpen(int open) {
        this.open = open;
    }

    public void ignore() {
        this.open = Integer.MAX_VALUE;
        this.close = 0x7FFFFFFE;
        this.openLatch.countDown();
        this.closeLatch.countDown();
    }

    public boolean outOfRange(int trackingCount) {
        return this.open == -1 || trackingCount < this.open || this.close != -1 && trackingCount > this.close;
    }

    public boolean beforeRange(int trackingCount) {
        return this.open == -1 || trackingCount < this.open;
    }

    public boolean afterRange(int trackingCount) {
        return this.close != -1 && trackingCount > this.close;
    }
}

