/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.transport.tcp.grizzly;

import com.sun.enterprise.web.portunif.ProtocolHandler;
import com.sun.enterprise.web.portunif.util.ProtocolInfo;
import com.sun.xml.ws.transport.tcp.resources.MessagesMessages;
import com.sun.xml.ws.transport.tcp.server.IncomeMessageProcessor;
import java.io.IOException;
import java.nio.channels.SelectionKey;
import java.nio.channels.SocketChannel;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class WSTCPProtocolHandler
implements ProtocolHandler {
    private static final Logger logger = Logger.getLogger("com.sun.metro.transport.tcp.server");
    private static IncomeMessageProcessor processor;

    public static void setIncomingMessageProcessor(IncomeMessageProcessor processor) {
        WSTCPProtocolHandler.processor = processor;
    }

    public String[] getProtocols() {
        return new String[]{"vnd.sun.ws.tcp"};
    }

    public void handle(ProtocolInfo tupple) throws IOException {
        if (processor != null) {
            tupple.byteBuffer.flip();
            processor.process(tupple.byteBuffer, (SocketChannel)tupple.key.channel());
        } else {
            logger.log(Level.WARNING, MessagesMessages.WSTCP_0013_TCP_PROCESSOR_NOT_REGISTERED());
        }
    }

    public boolean expireKey(SelectionKey key) {
        if (processor != null) {
            processor.notifyClosed((SocketChannel)key.channel());
        }
        return true;
    }
}

