/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.bundlerepository.impl;

import java.util.Dictionary;
import java.util.HashSet;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.felix.bundlerepository.LocalResource;
import org.apache.felix.bundlerepository.impl.CapabilityImpl;
import org.apache.felix.bundlerepository.impl.DataModelHelperImpl;
import org.apache.felix.bundlerepository.impl.FelixPropertyAdapter;
import org.apache.felix.bundlerepository.impl.PropertyImpl;
import org.apache.felix.bundlerepository.impl.ResourceImpl;
import org.osgi.framework.Bundle;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.wiring.BundleRevision;
import org.osgi.resource.Capability;

public class LocalResourceImpl
extends ResourceImpl
implements LocalResource {
    private Bundle m_bundle = null;

    LocalResourceImpl(Bundle bundle) throws InvalidSyntaxException {
        this.m_bundle = bundle;
        this.initialize();
    }

    public boolean isLocal() {
        return true;
    }

    public Bundle getBundle() {
        return this.m_bundle;
    }

    private void initialize() throws InvalidSyntaxException {
        final Dictionary dict = this.m_bundle.getHeaders();
        DataModelHelperImpl.populate(new DataModelHelperImpl.Headers(){

            public String getHeader(String name) {
                return (String)dict.get(name);
            }

            public void close() {
            }
        }, this);
        this.convertExportServiceToCapability(dict, this.m_bundle);
        if (this.m_bundle.getBundleId() == 0L) {
            CapabilityImpl sysBundleCap = new CapabilityImpl("bundle");
            sysBundleCap.addProperty("symbolicname", "system.bundle");
            this.addCapability(sysBundleCap);
            String ee = this.m_bundle.getBundleContext().getProperty("org.osgi.framework.executionenvironment");
            if (ee != null) {
                StringTokenizer tokens = new StringTokenizer(ee, ",");
                while (tokens.hasMoreTokens()) {
                    CapabilityImpl cap = new CapabilityImpl("ee");
                    cap.addProperty("ee", tokens.nextToken().trim());
                    this.addCapability(cap);
                }
            }
            BundleRevision br = (BundleRevision)this.m_bundle.adapt(BundleRevision.class);
            for (Capability cap : br.getCapabilities(null)) {
                CapabilityImpl bcap = new CapabilityImpl(cap.getNamespace());
                for (Map.Entry<String, Object> entry : cap.getAttributes().entrySet()) {
                    bcap.addProperty(new FelixPropertyAdapter(entry));
                }
                for (Map.Entry entry : cap.getDirectives().entrySet()) {
                    bcap.addDirective((String)entry.getKey(), (String)entry.getValue());
                }
                this.addCapability(bcap);
            }
        }
    }

    private void convertExportServiceToCapability(Dictionary dict, Bundle bundle) {
        HashSet services = new HashSet();
        ServiceReference[] refs = bundle.getRegisteredServices();
        for (int i = 0; refs != null && i < refs.length; ++i) {
            String[] cls = (String[])refs[i].getProperty("objectClass");
            for (int j = 0; cls != null && j < cls.length; ++j) {
                CapabilityImpl cap = new CapabilityImpl();
                cap.setName("service");
                cap.addProperty(new PropertyImpl("service", null, cls[j]));
                this.addCapability(cap);
            }
        }
    }

    public String toString() {
        return this.m_bundle.toString();
    }
}

