/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.xjc.reader;

import com.sun.tools.xjc.Options;
import com.sun.tools.xjc.Plugin;
import com.sun.tools.xjc.reader.Messages;
import com.sun.tools.xjc.util.SubtreeCutter;
import com.sun.xml.bind.v2.util.EditDistance;
import java.util.HashSet;
import java.util.Set;
import org.xml.sax.ErrorHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.NamespaceSupport;

public abstract class AbstractExtensionBindingChecker
extends SubtreeCutter {
    protected final NamespaceSupport nsSupport = new NamespaceSupport();
    protected final Set<String> enabledExtensions = new HashSet<String>();
    private final Set<String> recognizableExtensions = new HashSet<String>();
    private Locator locator;
    protected final String schemaLanguage;
    protected final boolean allowExtensions;
    private final Options options;

    public AbstractExtensionBindingChecker(String schemaLanguage, Options options, ErrorHandler handler) {
        this.schemaLanguage = schemaLanguage;
        this.allowExtensions = options.compatibilityMode != 1;
        this.options = options;
        this.setErrorHandler(handler);
        for (Plugin plugin : options.getAllPlugins()) {
            this.recognizableExtensions.addAll(plugin.getCustomizationURIs());
        }
        this.recognizableExtensions.add("http://java.sun.com/xml/ns/jaxb/xjc");
    }

    protected final void checkAndEnable(String uri) throws SAXException {
        if (!this.isRecognizableExtension(uri)) {
            String nearest = EditDistance.findNearest(uri, this.recognizableExtensions);
            this.error(Messages.ERR_UNSUPPORTED_EXTENSION.format(uri, nearest));
        } else if (!this.isSupportedExtension(uri)) {
            Plugin owner = null;
            for (Plugin p : this.options.getAllPlugins()) {
                if (!p.getCustomizationURIs().contains(uri)) continue;
                owner = p;
                break;
            }
            if (owner != null) {
                this.error(Messages.ERR_PLUGIN_NOT_ENABLED.format(owner.getOptionName(), uri));
            } else {
                this.error(Messages.ERR_UNSUPPORTED_EXTENSION.format(uri));
            }
        }
        this.enabledExtensions.add(uri);
    }

    protected final void verifyTagName(String namespaceURI, String localName, String qName) throws SAXException {
        if (this.options.pluginURIs.contains(namespaceURI)) {
            boolean correct = false;
            for (Plugin p : this.options.activePlugins) {
                if (!p.isCustomizationTagName(namespaceURI, localName)) continue;
                correct = true;
                break;
            }
            if (!correct) {
                this.error(Messages.ERR_ILLEGAL_CUSTOMIZATION_TAGNAME.format(qName));
                this.startCutting();
            }
        }
    }

    protected final boolean isSupportedExtension(String namespaceUri) {
        return namespaceUri.equals("http://java.sun.com/xml/ns/jaxb/xjc") || this.options.pluginURIs.contains(namespaceUri);
    }

    protected final boolean isRecognizableExtension(String namespaceUri) {
        return this.recognizableExtensions.contains(namespaceUri);
    }

    @Override
    public void setDocumentLocator(Locator locator) {
        super.setDocumentLocator(locator);
        this.locator = locator;
    }

    @Override
    public void startDocument() throws SAXException {
        super.startDocument();
        this.nsSupport.reset();
        this.enabledExtensions.clear();
    }

    @Override
    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        if ("http://www.w3.org/XML/1998/namespace".equals(uri)) {
            return;
        }
        super.startPrefixMapping(prefix, uri);
        this.nsSupport.pushContext();
        this.nsSupport.declarePrefix(prefix, uri);
    }

    @Override
    public void endPrefixMapping(String prefix) throws SAXException {
        if ("xml".equals(prefix)) {
            return;
        }
        super.endPrefixMapping(prefix);
        this.nsSupport.popContext();
    }

    protected final SAXParseException error(String msg) throws SAXException {
        SAXParseException spe = new SAXParseException(msg, this.locator);
        this.getErrorHandler().error(spe);
        return spe;
    }

    protected final void warning(String msg) throws SAXException {
        SAXParseException spe = new SAXParseException(msg, this.locator);
        this.getErrorHandler().warning(spe);
    }
}

