/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.osgijavaeebase;

import com.sun.enterprise.deploy.shared.ArchiveFactory;
import java.util.Dictionary;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.ActionReport;
import org.glassfish.internal.api.Globals;
import org.glassfish.internal.deployment.Deployment;
import org.glassfish.osgijavaeebase.DeploymentException;
import org.glassfish.osgijavaeebase.OSGiApplicationInfo;
import org.glassfish.osgijavaeebase.OSGiContainer;
import org.glassfish.osgijavaeebase.OSGiDeployer;
import org.glassfish.osgijavaeebase.OSGiDeploymentRequest;
import org.glassfish.osgijavaeebase.OSGiUndeploymentRequest;
import org.glassfish.server.ServerEnvironmentImpl;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.util.tracker.ServiceTracker;

public abstract class AbstractOSGiDeployer
implements OSGiDeployer {
    private static final Logger logger = Logger.getLogger(AbstractOSGiDeployer.class.getPackage().getName());
    private BundleContext bundleContext;
    private ServiceRegistration serviceReg;
    private int rank;
    private Deployment deployer = (Deployment)Globals.get(Deployment.class);
    private ArchiveFactory archiveFactory = (ArchiveFactory)Globals.get(ArchiveFactory.class);
    private ServerEnvironmentImpl env = (ServerEnvironmentImpl)Globals.get(ServerEnvironmentImpl.class);

    protected AbstractOSGiDeployer(BundleContext bundleContext, int rank) {
        this.bundleContext = bundleContext;
        this.rank = rank;
    }

    public BundleContext getBundleContext() {
        return this.bundleContext;
    }

    public void register() {
        Properties properties = new Properties();
        properties.put("service.ranking", (Object)this.rank);
        this.serviceReg = this.bundleContext.registerService(OSGiDeployer.class.getName(), (Object)this, (Dictionary)properties);
    }

    public void unregister() {
        this.undeployAll();
        this.serviceReg.unregister();
    }

    @Override
    public OSGiApplicationInfo deploy(Bundle b) throws DeploymentException {
        this.raiseEvent(State.DEPLOYING, b, null);
        ActionReport report = this.getReport();
        OSGiDeploymentRequest request = this.createOSGiDeploymentRequest(this.deployer, this.archiveFactory, this.env, report, b);
        OSGiApplicationInfo osgiAppInfo = request.execute();
        if (osgiAppInfo == null) {
            Throwable throwable = report.getFailureCause();
            this.raiseEvent(State.FAILED, b, throwable);
            throw new DeploymentException("Deployment of " + b + " failed because of following reason: " + report.getMessage(), throwable);
        }
        this.raiseEvent(State.DEPLOYED, b, null);
        return osgiAppInfo;
    }

    @Override
    public void undeploy(OSGiApplicationInfo osgiAppInfo) throws DeploymentException {
        Bundle b = osgiAppInfo.getBundle();
        this.raiseEvent(State.UNDEPLOYING, b, null);
        ActionReport report = this.getReport();
        OSGiUndeploymentRequest request = this.createOSGiUndeploymentRequest(this.deployer, this.env, report, osgiAppInfo);
        request.execute();
        this.raiseEvent(State.UNDEPLOYED, b, null);
        if (report.getActionExitCode() == ActionReport.ExitCode.FAILURE) {
            throw new DeploymentException("Undeployment of " + b + " failed because of following reason: " + report.getMessage(), report.getFailureCause());
        }
    }

    protected ActionReport getReport() {
        return (ActionReport)Globals.get(ActionReport.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void undeployAll() {
        ServiceTracker st = new ServiceTracker(this.bundleContext, OSGiContainer.class.getName(), null);
        st.open();
        try {
            OSGiContainer c = (OSGiContainer)st.getService();
            if (c == null) {
                return;
            }
            ServiceReference deployerRef = this.serviceReg.getReference();
            for (OSGiApplicationInfo app : c.getDeployedApps()) {
                if (app.getDeployer() != deployerRef) continue;
                try {
                    c.undeploy(app.getBundle());
                }
                catch (Exception e) {
                    logger.logp(Level.WARNING, "WebExtender", "undeployAll", "Failed to undeploy bundle " + app.getBundle(), e);
                }
            }
        }
        finally {
            st.close();
        }
    }

    protected abstract OSGiDeploymentRequest createOSGiDeploymentRequest(Deployment var1, ArchiveFactory var2, ServerEnvironmentImpl var3, ActionReport var4, Bundle var5);

    protected abstract OSGiUndeploymentRequest createOSGiUndeploymentRequest(Deployment var1, ServerEnvironmentImpl var2, ActionReport var3, OSGiApplicationInfo var4);

    protected void raiseEvent(State state, Bundle appBundle, Throwable throwable) {
    }

    public static enum State {
        DEPLOYING,
        DEPLOYED,
        FAILED,
        UNDEPLOYING,
        UNDEPLOYED;

    }
}

