/*
 * Decompiled with CFR 0.152.
 */
package com.sun.data.provider.impl;

import com.sun.data.provider.DataListener;
import com.sun.data.provider.DataProvider;
import com.sun.data.provider.DataProviderException;
import com.sun.data.provider.FieldKey;
import com.sun.data.provider.RowKey;
import com.sun.data.provider.TableCursorListener;
import com.sun.data.provider.TableCursorVetoException;
import com.sun.data.provider.TableDataListener;
import com.sun.data.provider.TableDataProvider;
import com.sun.data.provider.TransactionalDataListener;
import com.sun.data.provider.TransactionalDataProvider;
import com.sun.data.provider.impl.AbstractTableDataProvider;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.ResourceBundle;

public class BasicTransactionalTableDataProvider
extends AbstractTableDataProvider
implements TransactionalDataProvider {
    private transient ResourceBundle bundle = null;
    protected TableDataProvider provider;
    protected HashMap changedRowMap = new HashMap();
    private DataEars dataEars = new DataEars();
    private CursorEars cursorEars = new CursorEars();

    public void setTableDataProvider(TableDataProvider provider) {
        if (this.provider != null) {
            this.provider.removeTableDataListener(this.dataEars);
            this.provider.removeTableCursorListener(this.cursorEars);
        }
        this.provider = provider;
        this.provider.addTableDataListener(this.dataEars);
        this.provider.addTableCursorListener(this.cursorEars);
        this.changedRowMap.clear();
        this.fireProviderChanged();
    }

    private ResourceBundle getBundle() {
        if (this.bundle == null) {
            this.bundle = ResourceBundle.getBundle("com/sun/data/provider/impl/Bundle");
        }
        return this.bundle;
    }

    public TableDataProvider getTableDataProvider() {
        return this.provider;
    }

    public FieldKey[] getFieldKeys() throws DataProviderException {
        if (this.provider == null) {
            return FieldKey.EMPTY_ARRAY;
        }
        return this.provider.getFieldKeys();
    }

    public FieldKey getFieldKey(String fieldId) throws DataProviderException {
        if (this.provider == null) {
            return null;
        }
        return this.provider.getFieldKey(fieldId);
    }

    public Class getType(FieldKey fieldKey) throws DataProviderException {
        if (this.provider == null) {
            return null;
        }
        return this.provider.getType(fieldKey);
    }

    public boolean isReadOnly(FieldKey fieldKey) throws DataProviderException {
        if (this.provider == null) {
            return true;
        }
        return this.provider.isReadOnly(fieldKey);
    }

    public int getRowCount() throws DataProviderException {
        if (this.provider == null) {
            return -1;
        }
        return this.provider.getRowCount();
    }

    public RowKey[] getRowKeys(int count, RowKey afterRow) throws DataProviderException {
        if (this.provider == null) {
            return RowKey.EMPTY_ARRAY;
        }
        return this.provider.getRowKeys(count, afterRow);
    }

    public RowKey getRowKey(String rowId) throws DataProviderException {
        if (this.provider == null) {
            return null;
        }
        return this.provider.getRowKey(rowId);
    }

    public boolean isRowAvailable(RowKey row) throws DataProviderException {
        if (this.provider == null) {
            return false;
        }
        return this.provider.isRowAvailable(row);
    }

    public Object getValue(FieldKey fieldKey, RowKey row) throws DataProviderException {
        HashMap changeMap;
        if (this.provider == null) {
            return null;
        }
        if (this.changedRowMap.containsKey(row) && (changeMap = (HashMap)this.changedRowMap.get(row)).containsKey(fieldKey)) {
            return changeMap.get(fieldKey);
        }
        return this.provider.getValue(fieldKey, row);
    }

    public void setValue(FieldKey fieldKey, RowKey row, Object value) throws DataProviderException {
        if (this.provider == null) {
            return;
        }
        if (this.isReadOnly(fieldKey)) {
            throw new DataProviderException(this.getBundle().getString("FK_READ_ONLY"));
        }
        HashMap changeMap = null;
        if (this.changedRowMap.containsKey(row)) {
            changeMap = (HashMap)this.changedRowMap.get(row);
        } else {
            changeMap = new HashMap();
            this.changedRowMap.put(row, changeMap);
        }
        Object oldValue = this.getValue(fieldKey, row);
        changeMap.put(fieldKey, value);
        this.fireValueChanged(fieldKey, row, oldValue, value);
        if (this.getCursorRow() == row) {
            this.fireValueChanged(fieldKey, oldValue, value);
        }
    }

    public boolean canInsertRow(RowKey beforeRow) throws DataProviderException {
        if (this.provider == null) {
            return false;
        }
        return this.provider.canInsertRow(beforeRow);
    }

    public RowKey insertRow(RowKey beforeRow) throws DataProviderException {
        if (this.provider == null) {
            return null;
        }
        return this.provider.insertRow(beforeRow);
    }

    public boolean canAppendRow() throws DataProviderException {
        if (this.provider == null) {
            return false;
        }
        return this.provider.canAppendRow();
    }

    public RowKey appendRow() throws DataProviderException {
        if (this.provider == null) {
            return null;
        }
        return this.provider.appendRow();
    }

    public boolean canRemoveRow(RowKey row) throws DataProviderException {
        if (this.provider == null) {
            return false;
        }
        return this.provider.canRemoveRow(row);
    }

    public void removeRow(RowKey row) throws DataProviderException {
        if (this.provider != null) {
            this.provider.removeRow(row);
        }
    }

    public void commitChanges() throws DataProviderException {
        Iterator rowKeys = this.changedRowMap.keySet().iterator();
        while (rowKeys.hasNext()) {
            RowKey rowKey = (RowKey)rowKeys.next();
            HashMap changeMap = (HashMap)this.changedRowMap.get(rowKey);
            Iterator changeKeys = changeMap.keySet().iterator();
            while (changeKeys.hasNext()) {
                FieldKey fieldKey = (FieldKey)changeKeys.next();
                this.provider.setValue(fieldKey, rowKey, changeMap.get(fieldKey));
            }
        }
        this.changedRowMap.clear();
        this.fireChangesCommitted();
    }

    public void revertChanges() throws DataProviderException {
        this.changedRowMap.clear();
        this.fireChangesReverted();
        this.fireProviderChanged();
    }

    public void addTransactionalDataListener(TransactionalDataListener l) {
        super.addDataListener(l);
    }

    public void removeTransactionalDataListener(TransactionalDataListener l) {
        super.removeDataListener(l);
    }

    public TransactionalDataListener[] getTransactionalDataListeners() {
        if (this.dpListeners == null) {
            return new TransactionalDataListener[0];
        }
        ArrayList<DataListener> cdpList = new ArrayList<DataListener>();
        for (int i = 0; i < this.dpListeners.length; ++i) {
            if (!(this.dpListeners[i] instanceof TransactionalDataListener)) continue;
            cdpList.add(this.dpListeners[i]);
        }
        return cdpList.toArray(new TransactionalDataListener[cdpList.size()]);
    }

    protected void fireChangesCommitted() {
        TransactionalDataListener[] cdpls = this.getTransactionalDataListeners();
        for (int i = 0; i < cdpls.length; ++i) {
            cdpls[i].changesCommitted(this);
        }
    }

    protected void fireChangesReverted() {
        TransactionalDataListener[] cdpls = this.getTransactionalDataListeners();
        for (int i = 0; i < cdpls.length; ++i) {
            cdpls[i].changesReverted(this);
        }
    }

    private class CursorEars
    implements TableCursorListener,
    Serializable {
        private CursorEars() {
        }

        public void cursorChanging(TableDataProvider provider, RowKey oldRow, RowKey newRow) throws TableCursorVetoException {
            BasicTransactionalTableDataProvider.this.fireCursorChanging(oldRow, newRow);
        }

        public void cursorChanged(TableDataProvider provider, RowKey oldRow, RowKey newRow) {
            BasicTransactionalTableDataProvider.this.fireCursorChanged(oldRow, newRow);
        }
    }

    private class DataEars
    implements TableDataListener,
    Serializable {
        private DataEars() {
        }

        public void valueChanged(TableDataProvider provider, FieldKey fieldKey, RowKey row, Object oldValue, Object newValue) {
            BasicTransactionalTableDataProvider.this.fireValueChanged(fieldKey, row, oldValue, newValue);
        }

        public void rowAdded(TableDataProvider provider, RowKey row) {
            BasicTransactionalTableDataProvider.this.fireRowAdded(row);
        }

        public void rowRemoved(TableDataProvider provider, RowKey row) {
            BasicTransactionalTableDataProvider.this.fireRowRemoved(row);
        }

        public void valueChanged(DataProvider provider, FieldKey fieldKey, Object oldValue, Object newValue) {
            BasicTransactionalTableDataProvider.this.fireValueChanged(fieldKey, oldValue, newValue);
        }

        public void providerChanged(DataProvider provider) {
            BasicTransactionalTableDataProvider.this.fireProviderChanged();
        }
    }
}

