/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.util.collections;

import java.util.AbstractSet;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.jboss.weld.util.Preconditions;
import org.jboss.weld.util.collections.ImmutableList;
import org.jboss.weld.util.collections.Iterators;

public final class Sets {
    private Sets() {
    }

    @SafeVarargs
    public static <E> HashSet<E> newHashSet(E ... elements) {
        HashSet set = new HashSet(elements.length);
        Collections.addAll(set, elements);
        return set;
    }

    public static <E> Set<E> union(final Set<? extends E> set1, Set<? extends E> set2) {
        Preconditions.checkArgumentNotNull(set1, "set1");
        Preconditions.checkArgumentNotNull(set2, "set2");
        final HashSet<E> difference = new HashSet<E>(set2);
        difference.removeAll(set1);
        return new AbstractSet<E>(){

            @Override
            public Iterator<E> iterator() {
                final Iterator iterator = Iterators.concat(ImmutableList.of(new Iterator[]{set1.iterator(), difference.iterator()}).iterator());
                return new Iterator<E>(){

                    @Override
                    public boolean hasNext() {
                        return iterator.hasNext();
                    }

                    @Override
                    public E next() {
                        return iterator.next();
                    }
                };
            }

            @Override
            public int size() {
                return set1.size() + difference.size();
            }

            @Override
            public boolean isEmpty() {
                return set1.isEmpty() && difference.isEmpty();
            }

            @Override
            public boolean contains(Object o) {
                return set1.contains(o) || difference.contains(o);
            }
        };
    }
}

