/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.registry.common.util;

import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;
import java.rmi.server.UID;
import java.util.ResourceBundle;
import java.util.logging.Logger;
import javax.naming.InitialContext;
import javax.naming.NamingException;

public class Utility {
    public static final String LOGGING_DOMAIN = "javax.enterprise.resource.webservices.registry";
    Logger logger = Logger.getLogger("javax.enterprise.resource.webservices.registry.common");
    private static Utility instance = null;
    private String jaxrHome = null;

    protected Utility() {
    }

    public void setJAXRHome(String string2) {
        this.jaxrHome = string2;
    }

    public String getJAXRHome() {
        this.logger.finest("getJAXRHome() called");
        if (this.jaxrHome == null) {
            try {
                this.jaxrHome = System.getProperty("JAXR_HOME");
                if (this.jaxrHome == null) {
                    throw new NullPointerException();
                }
            }
            catch (NullPointerException nullPointerException) {
                throw new RuntimeException(ResourceBundle.getBundle("com/sun/xml/registry/common/LocalStrings").getString("Utility:JAXR_HOME_must_be_set"), nullPointerException);
            }
        }
        return this.jaxrHome;
    }

    public String getContextRoot() {
        String string2 = "c:/jaxr";
        try {
            InitialContext initialContext = new InitialContext();
            string2 = (String)initialContext.lookup("java:comp/env/jaxr-service/contextRoot");
        }
        catch (NamingException namingException) {
            System.getProperty("JAXR_HOME", "c:/jaxr");
        }
        return string2;
    }

    public String getContextRootURLString() {
        String string2 = this.getContextRoot();
        if (!string2.startsWith("http", 0) && !string2.startsWith("file", 0)) {
            string2 = "file:///" + string2;
        }
        return string2;
    }

    public URL getURL(String string2) throws MalformedURLException {
        URL uRL = null;
        String string3 = this.getContextRootURLString() + string2;
        uRL = new URL(string3);
        return uRL;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Utility getInstance() {
        if (instance != null) return instance;
        Class<Utility> clazz = Utility.class;
        synchronized (Utility.class) {
            if (instance != null) return instance;
            instance = new Utility();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public static String generateUUID() {
        String string2 = null;
        try {
            string2 = InetAddress.getLocalHost() + new UID().toString();
        }
        catch (UnknownHostException unknownHostException) {
            unknownHostException.printStackTrace();
        }
        return string2;
    }
}

