/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dbschema;

import org.netbeans.modules.dbschema.DBException;
import org.netbeans.modules.dbschema.DBMemberElement;
import org.netbeans.modules.dbschema.TableElement;
import org.netbeans.modules.dbschema.util.SQLTypeUtil;

public class ColumnElement
extends DBMemberElement {
    public ColumnElement() {
        this(new Memory(), null);
    }

    public ColumnElement(Impl impl, TableElement declaringTable) {
        super(impl, declaringTable);
    }

    @Override
    public boolean equals(Object obj) {
        Integer iArg;
        if (!(obj instanceof ColumnElement)) {
            return false;
        }
        ColumnElement ce = (ColumnElement)obj;
        if (!this.getName().getFullName().equals(ce.getName().getFullName())) {
            return false;
        }
        if (this.getType() != ce.getType()) {
            return false;
        }
        if (this.isNullable() != ce.isNullable()) {
            return false;
        }
        Integer iThis = this.getLength();
        if (iThis != null ^ (iArg = ce.getLength()) != null) {
            return false;
        }
        if (iThis != null && iArg != null && iThis.compareTo(iArg) != 0) {
            return false;
        }
        iThis = this.getScale();
        if (iThis != null ^ (iArg = ce.getScale()) != null) {
            return false;
        }
        if (iThis != null && iArg != null && iThis.compareTo(iArg) != 0) {
            return false;
        }
        iThis = this.getPrecision();
        if (iThis != null ^ (iArg = ce.getPrecision()) != null) {
            return false;
        }
        return iThis == null || iArg == null || iThis.compareTo(iArg) == 0;
    }

    public Object clone() {
        return new ColumnElement(new Memory(this), null);
    }

    final Impl getColumnImpl() {
        return (Impl)this.getElementImpl();
    }

    public int getType() {
        return this.getColumnImpl().getType();
    }

    public void setType(int type) throws DBException {
        this.getColumnImpl().setType(type);
    }

    public boolean isNumericType() {
        return SQLTypeUtil.isNumeric(this.getType());
    }

    public boolean isCharacterType() {
        return SQLTypeUtil.isCharacter(this.getType());
    }

    public boolean isBlobType() {
        return SQLTypeUtil.isBlob(this.getType());
    }

    public boolean isAutoIncrement() {
        return this.getColumnImpl().isAutoIncrement();
    }

    public boolean isNullable() {
        return this.getColumnImpl().isNullable();
    }

    public void setNullable(boolean flag) throws DBException {
        this.getColumnImpl().setNullable(flag);
    }

    public Integer getLength() {
        if (this.isCharacterType() || this.isBlobType()) {
            return this.getColumnImpl().getLength();
        }
        return null;
    }

    public void setLength(Integer length) throws DBException {
        if (this.isCharacterType() || this.isBlobType()) {
            this.getColumnImpl().setLength(length);
        }
    }

    public Integer getPrecision() {
        if (this.isNumericType()) {
            return this.getColumnImpl().getPrecision();
        }
        return null;
    }

    public void setPrecision(Integer precision) throws DBException {
        if (this.isNumericType()) {
            this.getColumnImpl().setPrecision(precision);
        }
    }

    public Integer getScale() {
        if (this.isNumericType()) {
            return this.getColumnImpl().getScale();
        }
        return null;
    }

    public void setScale(Integer scale) throws DBException {
        if (this.isNumericType()) {
            this.getColumnImpl().setScale(scale);
        }
    }

    @Override
    public String toString() {
        return this.getName().toString();
    }

    static class Memory
    extends DBMemberElement.Memory
    implements Impl {
        private int _type;
        private boolean _nullable;
        private Integer _length;
        private Integer _precision;
        private Integer _scale;
        private boolean _autoIncrement;

        Memory() {
            this._type = 0;
        }

        Memory(ColumnElement column) {
            super(column);
            this._type = column.getType();
            this._nullable = column.isNullable();
            this._length = column.getLength();
            this._precision = column.getPrecision();
            this._scale = column.getScale();
            this._autoIncrement = column.isAutoIncrement();
        }

        @Override
        public int getType() {
            return this._type;
        }

        @Override
        public void setType(int type) {
            int old = this._type;
            this._type = type;
            this.firePropertyChange("type", new Integer(old), new Integer(type));
        }

        @Override
        public boolean isNullable() {
            return this._nullable;
        }

        @Override
        public void setNullable(boolean flag) throws DBException {
            boolean old = this._nullable;
            this._nullable = flag;
            this.firePropertyChange("nullable", old, flag);
        }

        @Override
        public Integer getLength() {
            return this._length;
        }

        @Override
        public void setLength(Integer length) throws DBException {
            Integer old = this._length;
            this._length = length;
            this.firePropertyChange("length", old, length);
        }

        @Override
        public Integer getPrecision() {
            return this._precision;
        }

        @Override
        public void setPrecision(Integer precision) throws DBException {
            Integer old = this._precision;
            this._precision = precision;
            this.firePropertyChange("precision", old, precision);
        }

        @Override
        public Integer getScale() {
            return this._scale;
        }

        @Override
        public void setScale(Integer scale) throws DBException {
            Integer old = this._scale;
            this._scale = scale;
            this.firePropertyChange("scale", old, scale);
        }

        @Override
        public boolean isAutoIncrement() {
            return this._autoIncrement;
        }
    }

    public static interface Impl
    extends DBMemberElement.Impl {
        public int getType();

        public boolean isAutoIncrement();

        public void setType(int var1) throws DBException;

        public boolean isNullable();

        public void setNullable(boolean var1) throws DBException;

        public Integer getLength();

        public void setLength(Integer var1) throws DBException;

        public Integer getPrecision();

        public void setPrecision(Integer var1) throws DBException;

        public Integer getScale();

        public void setScale(Integer var1) throws DBException;
    }
}

