/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.xjc;

import com.sun.tools.xjc.Input;
import com.sun.xml.bind.v2.util.XmlFactory;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.ValidatorHandler;
import org.w3c.dom.ls.LSInput;
import org.w3c.dom.ls.LSResourceResolver;
import org.xml.sax.SAXException;

public final class SchemaCache {
    private final boolean createResolver;
    private final String resourceName;
    private final Class<?> clazz;
    private Schema schema;

    public SchemaCache(String resourceName, Class<?> classToResolveResources) {
        this(resourceName, classToResolveResources, false);
    }

    public SchemaCache(String resourceName, Class<?> classToResolveResources, boolean createResolver) {
        this.resourceName = resourceName;
        this.createResolver = createResolver;
        this.clazz = classToResolveResources;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ValidatorHandler newValidator() {
        if (this.schema == null) {
            SchemaCache schemaCache = this;
            synchronized (schemaCache) {
                if (this.schema == null) {
                    ResourceResolver resourceResolver = null;
                    try (InputStream is = this.clazz.getResourceAsStream(this.resourceName);){
                        StreamSource source = new StreamSource(is);
                        source.setSystemId(this.resourceName);
                        SchemaFactory sf = XmlFactory.createSchemaFactory("http://www.w3.org/2001/XMLSchema", false);
                        SchemaFactory schemaFactory = XmlFactory.allowExternalAccess(sf, "file", false);
                        if (this.createResolver) {
                            resourceResolver = new ResourceResolver(this.clazz);
                            schemaFactory.setResourceResolver(resourceResolver);
                        }
                        this.schema = schemaFactory.newSchema(source);
                    }
                    catch (IOException | SAXException e) {
                        InternalError ie = new InternalError(e.getMessage());
                        ie.initCause(e);
                        throw ie;
                    }
                    finally {
                        if (resourceResolver != null) {
                            resourceResolver.closeStreams();
                        }
                    }
                }
            }
        }
        return this.schema.newValidatorHandler();
    }

    class ResourceResolver
    implements LSResourceResolver {
        private List<InputStream> streamsToClose = Collections.synchronizedList(new ArrayList());
        private Class<?> clazz;

        ResourceResolver(Class<?> clazz) {
            this.clazz = clazz;
        }

        @Override
        public LSInput resolveResource(String type, String namespaceURI, String publicId, String systemId, String baseURI) {
            InputStream is = this.clazz.getResourceAsStream(systemId);
            this.streamsToClose.add(is);
            return new Input(is, publicId, systemId);
        }

        void closeStreams() {
            for (InputStream is : this.streamsToClose) {
                if (is == null) continue;
                try {
                    is.close();
                }
                catch (IOException iOException) {}
            }
        }
    }
}

