/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.strategies;

import java.io.IOException;
import java.util.concurrent.Executor;
import java.util.logging.Logger;
import org.glassfish.grizzly.Connection;
import org.glassfish.grizzly.Grizzly;
import org.glassfish.grizzly.IOEvent;
import org.glassfish.grizzly.IOEventLifeCycleListener;
import org.glassfish.grizzly.nio.NIOConnection;
import org.glassfish.grizzly.nio.SelectorRunner;
import org.glassfish.grizzly.strategies.AbstractIOStrategy;

public final class LeaderFollowerNIOStrategy
extends AbstractIOStrategy {
    private static final LeaderFollowerNIOStrategy INSTANCE = new LeaderFollowerNIOStrategy();
    private static final Logger logger = Grizzly.logger(LeaderFollowerNIOStrategy.class);

    private LeaderFollowerNIOStrategy() {
    }

    public static LeaderFollowerNIOStrategy getInstance() {
        return INSTANCE;
    }

    @Override
    public boolean executeIoEvent(Connection connection, IOEvent ioEvent, boolean isIoEventEnabled) throws IOException {
        Executor threadPool;
        NIOConnection nioConnection = (NIOConnection)connection;
        IOEventLifeCycleListener listener = null;
        if (LeaderFollowerNIOStrategy.isReadWrite(ioEvent)) {
            if (isIoEventEnabled) {
                connection.disableIOEvent(ioEvent);
            }
            listener = ENABLE_INTEREST_LIFECYCLE_LISTENER;
        }
        if ((threadPool = this.getThreadPoolFor(connection, ioEvent)) != null) {
            SelectorRunner runner = nioConnection.getSelectorRunner();
            runner.postpone();
            threadPool.execute(runner);
            LeaderFollowerNIOStrategy.fireIOEvent(connection, ioEvent, listener, logger);
            return false;
        }
        LeaderFollowerNIOStrategy.fireIOEvent(connection, ioEvent, listener, logger);
        return true;
    }
}

