/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.libraries.asm.xml;

import org.eclipse.persistence.internal.libraries.asm.AnnotationVisitor;
import org.eclipse.persistence.internal.libraries.asm.ClassVisitor;
import org.eclipse.persistence.internal.libraries.asm.FieldVisitor;
import org.eclipse.persistence.internal.libraries.asm.MethodVisitor;
import org.eclipse.persistence.internal.libraries.asm.ModuleVisitor;
import org.eclipse.persistence.internal.libraries.asm.TypePath;
import org.eclipse.persistence.internal.libraries.asm.xml.SAXAdapter;
import org.eclipse.persistence.internal.libraries.asm.xml.SAXAnnotationAdapter;
import org.eclipse.persistence.internal.libraries.asm.xml.SAXCodeAdapter;
import org.eclipse.persistence.internal.libraries.asm.xml.SAXFieldAdapter;
import org.eclipse.persistence.internal.libraries.asm.xml.SAXModuleAdapter;
import org.xml.sax.ContentHandler;
import org.xml.sax.helpers.AttributesImpl;

@Deprecated
public final class SAXClassAdapter
extends ClassVisitor {
    SAXAdapter sa;
    private final boolean singleDocument;
    private static final int ACCESS_CLASS = 262144;
    private static final int ACCESS_FIELD = 524288;
    private static final int ACCESS_INNER = 0x100000;
    static final int ACCESS_MODULE = 0x200000;
    static final int ACCESS_MODULE_REQUIRES = 0x400000;

    public SAXClassAdapter(ContentHandler h, boolean singleDocument) {
        super(393216);
        this.sa = new SAXAdapter(h);
        this.singleDocument = singleDocument;
        if (!singleDocument) {
            this.sa.addDocumentStart();
        }
    }

    @Override
    public void visitSource(String source, String debug) {
        AttributesImpl att = new AttributesImpl();
        if (source != null) {
            att.addAttribute("", "file", "file", "", SAXClassAdapter.encode(source));
        }
        if (debug != null) {
            att.addAttribute("", "debug", "debug", "", SAXClassAdapter.encode(debug));
        }
        this.sa.addElement("source", att);
    }

    @Override
    public ModuleVisitor visitModule(String name, int access, String version) {
        AttributesImpl att = new AttributesImpl();
        att.addAttribute("", "name", "name", "", name);
        StringBuilder sb = new StringBuilder();
        SAXClassAdapter.appendAccess(access | 0x200000, sb);
        att.addAttribute("", "access", "access", "", sb.toString());
        if (version != null) {
            att.addAttribute("", "version", "version", "", SAXClassAdapter.encode(version));
        }
        this.sa.addStart("module", att);
        return new SAXModuleAdapter(this.sa);
    }

    @Override
    public void visitOuterClass(String owner, String name, String desc) {
        AttributesImpl att = new AttributesImpl();
        att.addAttribute("", "owner", "owner", "", owner);
        if (name != null) {
            att.addAttribute("", "name", "name", "", name);
        }
        if (desc != null) {
            att.addAttribute("", "desc", "desc", "", desc);
        }
        this.sa.addElement("outerclass", att);
    }

    @Override
    public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
        return new SAXAnnotationAdapter(this.sa, "annotation", visible ? 1 : -1, null, desc);
    }

    @Override
    public AnnotationVisitor visitTypeAnnotation(int typeRef, TypePath typePath, String desc, boolean visible) {
        return new SAXAnnotationAdapter(this.sa, "typeAnnotation", visible ? 1 : -1, null, desc, typeRef, typePath);
    }

    @Override
    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        StringBuilder sb = new StringBuilder();
        SAXClassAdapter.appendAccess(access | 0x40000, sb);
        AttributesImpl att = new AttributesImpl();
        att.addAttribute("", "access", "access", "", sb.toString());
        if (name != null) {
            att.addAttribute("", "name", "name", "", name);
        }
        if (signature != null) {
            att.addAttribute("", "signature", "signature", "", SAXClassAdapter.encode(signature));
        }
        if (superName != null) {
            att.addAttribute("", "parent", "parent", "", superName);
        }
        att.addAttribute("", "major", "major", "", Integer.toString(version & 0xFFFF));
        att.addAttribute("", "minor", "minor", "", Integer.toString(version >>> 16));
        this.sa.addStart("class", att);
        this.sa.addStart("interfaces", new AttributesImpl());
        if (interfaces != null && interfaces.length > 0) {
            for (int i = 0; i < interfaces.length; ++i) {
                AttributesImpl att2 = new AttributesImpl();
                att2.addAttribute("", "name", "name", "", interfaces[i]);
                this.sa.addElement("interface", att2);
            }
        }
        this.sa.addEnd("interfaces");
    }

    @Override
    public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
        StringBuilder sb = new StringBuilder();
        SAXClassAdapter.appendAccess(access | 0x80000, sb);
        AttributesImpl att = new AttributesImpl();
        att.addAttribute("", "access", "access", "", sb.toString());
        att.addAttribute("", "name", "name", "", name);
        att.addAttribute("", "desc", "desc", "", desc);
        if (signature != null) {
            att.addAttribute("", "signature", "signature", "", SAXClassAdapter.encode(signature));
        }
        if (value != null) {
            att.addAttribute("", "value", "value", "", SAXClassAdapter.encode(value.toString()));
        }
        return new SAXFieldAdapter(this.sa, att);
    }

    @Override
    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        StringBuilder sb = new StringBuilder();
        SAXClassAdapter.appendAccess(access, sb);
        AttributesImpl att = new AttributesImpl();
        att.addAttribute("", "access", "access", "", sb.toString());
        att.addAttribute("", "name", "name", "", name);
        att.addAttribute("", "desc", "desc", "", desc);
        if (signature != null) {
            att.addAttribute("", "signature", "signature", "", signature);
        }
        this.sa.addStart("method", att);
        this.sa.addStart("exceptions", new AttributesImpl());
        if (exceptions != null && exceptions.length > 0) {
            for (int i = 0; i < exceptions.length; ++i) {
                AttributesImpl att2 = new AttributesImpl();
                att2.addAttribute("", "name", "name", "", exceptions[i]);
                this.sa.addElement("exception", att2);
            }
        }
        this.sa.addEnd("exceptions");
        return new SAXCodeAdapter(this.sa, access);
    }

    @Override
    public final void visitInnerClass(String name, String outerName, String innerName, int access) {
        StringBuilder sb = new StringBuilder();
        SAXClassAdapter.appendAccess(access | 0x100000, sb);
        AttributesImpl att = new AttributesImpl();
        att.addAttribute("", "access", "access", "", sb.toString());
        if (name != null) {
            att.addAttribute("", "name", "name", "", name);
        }
        if (outerName != null) {
            att.addAttribute("", "outerName", "outerName", "", outerName);
        }
        if (innerName != null) {
            att.addAttribute("", "innerName", "innerName", "", innerName);
        }
        this.sa.addElement("innerclass", att);
    }

    @Override
    public final void visitEnd() {
        this.sa.addEnd("class");
        if (!this.singleDocument) {
            this.sa.addDocumentEnd();
        }
    }

    static final String encode(String s) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c == '\\') {
                sb.append("\\\\");
                continue;
            }
            if (c < ' ' || c > '\u007f') {
                sb.append("\\u");
                if (c < '\u0010') {
                    sb.append("000");
                } else if (c < '\u0100') {
                    sb.append("00");
                } else if (c < '\u1000') {
                    sb.append('0');
                }
                sb.append(Integer.toString(c, 16));
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    static void appendAccess(int access, StringBuilder sb) {
        if ((access & 1) != 0) {
            sb.append("public ");
        }
        if ((access & 2) != 0) {
            sb.append("private ");
        }
        if ((access & 4) != 0) {
            sb.append("protected ");
        }
        if ((access & 0x10) != 0) {
            if ((access & 0x200000) == 0) {
                sb.append("final ");
            } else {
                sb.append("transitive ");
            }
        }
        if ((access & 8) != 0) {
            sb.append("static ");
        }
        if ((access & 0x20) != 0) {
            if ((access & 0x40000) == 0) {
                if ((access & 0x400000) != 0) {
                    sb.append("transitive ");
                } else if ((access & 0x200000) == 0) {
                    sb.append("synchronized ");
                } else {
                    sb.append("open ");
                }
            } else {
                sb.append("super ");
            }
        }
        if ((access & 0x40) != 0) {
            if ((access & 0x80000) == 0) {
                sb.append("bridge ");
            } else if ((access & 0x400000) == 0) {
                sb.append("volatile ");
            } else {
                sb.append("static ");
            }
        }
        if ((access & 0x80) != 0) {
            if ((access & 0x80000) == 0) {
                sb.append("varargs ");
            } else {
                sb.append("transient ");
            }
        }
        if ((access & 0x100) != 0) {
            sb.append("native ");
        }
        if ((access & 0x800) != 0) {
            sb.append("strict ");
        }
        if ((access & 0x200) != 0) {
            sb.append("interface ");
        }
        if ((access & 0x400) != 0) {
            sb.append("abstract ");
        }
        if ((access & 0x1000) != 0) {
            sb.append("synthetic ");
        }
        if ((access & 0x2000) != 0) {
            sb.append("annotation ");
        }
        if ((access & 0x4000) != 0) {
            sb.append("enum ");
        }
        if ((access & 0x20000) != 0) {
            sb.append("deprecated ");
        }
        if ((access & 0x8000) != 0) {
            if ((access & 0x40000) == 0) {
                sb.append("module ");
            } else {
                sb.append("mandated ");
            }
        }
    }
}

