/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.config.ssl;

import java.net.Socket;
import javax.net.ssl.SSLEngine;
import org.glassfish.grizzly.config.ssl.JSSEFactory;
import org.glassfish.grizzly.config.ssl.SSLImplementation;
import org.glassfish.grizzly.config.ssl.ServerSocketFactory;
import org.glassfish.grizzly.ssl.SSLSupport;

public class JSSEImplementation
extends SSLImplementation {
    static final String JSSE14Factory = "org.glassfish.grizzly.config.ssl.JSSE14Factory";
    static final String SSLSocketClass = "javax.net.ssl.SSLSocket";
    private JSSEFactory factory;

    public JSSEImplementation() throws ClassNotFoundException {
        Class.forName(SSLSocketClass);
        try {
            Class<?> factcl = Class.forName(JSSE14Factory);
            this.factory = (JSSEFactory)factcl.newInstance();
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    public String getImplementationName() {
        return "JSSE";
    }

    @Override
    public ServerSocketFactory getServerSocketFactory() {
        return this.factory.getSocketFactory();
    }

    @Override
    public SSLSupport getSSLSupport(Socket s) {
        return this.factory.getSSLSupport(s);
    }

    @Override
    public SSLSupport getSSLSupport(SSLEngine sslEngine) {
        return this.factory.getSSLSupport(sslEngine);
    }
}

