/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jms.admin.cli;

import com.sun.appserv.connectors.internal.api.ConnectorRuntime;
import com.sun.enterprise.config.serverbeans.Cluster;
import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;
import javax.inject.Named;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.RestEndpoint;
import org.glassfish.api.admin.RestEndpoints;
import org.glassfish.api.admin.RestParam;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.config.support.CommandTarget;
import org.glassfish.config.support.TargetType;
import org.glassfish.hk2.api.PerLookup;
import org.glassfish.internal.api.ServerContext;
import org.glassfish.jms.admin.cli.JMSDestination;
import org.glassfish.jms.admin.cli.MQJMXConnectorInfo;
import org.jvnet.hk2.annotations.Service;

@Service(name="delete-jmsdest")
@PerLookup
@I18n(value="delete.jms.dest")
@ExecuteOn(value={RuntimeType.DAS})
@TargetType(value={CommandTarget.DAS, CommandTarget.STANDALONE_INSTANCE, CommandTarget.CLUSTER, CommandTarget.CONFIG})
@RestEndpoints(value={@RestEndpoint(configBean=Cluster.class, opType=RestEndpoint.OpType.DELETE, path="delete-jmsdest", description="Delete JMS Destination", params={@RestParam(name="target", value="$parent")}), @RestEndpoint(configBean=Server.class, opType=RestEndpoint.OpType.DELETE, path="delete-jmsdest", description="Delete JMS Destination", params={@RestParam(name="target", value="$parent")})})
public class DeleteJMSDestination
extends JMSDestination
implements AdminCommand {
    private final Logger logger = Logger.getLogger("javax.enterprise.system.tools.admin");
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(DeleteJMSDestination.class);
    @Param(name="destType", shortName="T", optional=false)
    String destType;
    @Param(name="dest_name", primary=true)
    String destName;
    @Param(optional=true)
    String target = "server";
    @Inject
    ConnectorRuntime connectorRuntime;
    @Inject
    Domain domain;
    @Inject
    @Named(value="default-instance-name")
    Config config;
    @Inject
    ServerContext serverContext;

    public void execute(AdminCommandContext context) {
        ActionReport report = context.getActionReport();
        this.logger.entering(this.getClass().getName(), "deleteJMSDestination", new Object[]{this.destName, this.destType});
        try {
            this.validateJMSDestName(this.destName);
            this.validateJMSDestType(this.destType);
        }
        catch (IllegalArgumentException e) {
            report.setMessage(e.getMessage());
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return;
        }
        try {
            this.deleteJMSDestination(this.destName, this.destType, this.target);
            return;
        }
        catch (Exception e) {
            this.logger.throwing(this.getClass().getName(), "deleteJMSDestination", e);
            report.setMessage(localStrings.getLocalString("delete.jms.dest.noJmsDelete", "Delete JMS Destination failed. Please verify if the JMS Destination specified for deletion exists"));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object deleteJMSDestination(String destName, String destType, String tgtName) throws Exception {
        if (this.logger.isLoggable(Level.FINE)) {
            this.logger.log(Level.FINE, "deleteJMSDestination ...");
        }
        MQJMXConnectorInfo mqInfo = this.getMQJMXConnectorInfo(this.target, this.config, this.serverContext, this.domain, this.connectorRuntime);
        try {
            MBeanServerConnection mbsc = mqInfo.getMQMBeanServerConnection();
            ObjectName on = new ObjectName("com.sun.messaging.jms.server:type=DestinationManager,subtype=Config");
            String[] signature = null;
            Object[] params = null;
            signature = new String[]{"java.lang.String", "java.lang.String"};
            if (destType.equalsIgnoreCase("topic")) {
                destType = "t";
            } else if (destType.equalsIgnoreCase("queue")) {
                destType = "q";
            }
            params = new Object[]{destType, destName};
            Object object = mbsc.invoke(on, "destroy", params, signature);
            return object;
        }
        catch (Exception e) {
            this.logAndHandleException(e, "admin.mbeans.rmb.error_deleting_jms_dest");
        }
        finally {
            try {
                if (mqInfo != null) {
                    mqInfo.closeMQMBeanServerConnection();
                }
            }
            catch (Exception e) {
                this.handleException(e);
            }
        }
        return null;
    }
}

