/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.appclient.server.admin;

import com.sun.enterprise.config.serverbeans.Application;
import com.sun.enterprise.config.serverbeans.Applications;
import com.sun.enterprise.config.serverbeans.Module;
import com.sun.enterprise.util.LocalStringManager;
import com.sun.enterprise.util.LocalStringManagerImpl;
import javax.inject.Inject;
import org.glassfish.api.ActionReport;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.CommandLock;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.RestEndpoint;
import org.glassfish.api.admin.RestEndpoints;
import org.glassfish.api.admin.RestParam;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.appclient.server.core.AppClientDeployer;
import org.glassfish.hk2.api.PerLookup;
import org.jvnet.hk2.annotations.Service;

@Service(name="_get-relative-jws-uri")
@PerLookup
@CommandLock(value=CommandLock.LockType.NONE)
@ExecuteOn(value={RuntimeType.DAS})
@RestEndpoints(value={@RestEndpoint(configBean=Application.class, opType=RestEndpoint.OpType.GET, path="_get-relative-jws-uri", description="Get Relative JWS URI", params={@RestParam(name="appname", value="$parent")}, useForAuthorization=true)})
public class GetRelativeJWSURICommand
implements AdminCommand {
    private static final String APPNAME_OPTION = "appname";
    private static final String MODULENAME_OPTION = "modulename";
    private static final String URI_PROPERTY_NAME = "relative-uri";
    private static final LocalStringManager localStrings = new LocalStringManagerImpl(GetRelativeJWSURICommand.class);
    @Param(name="appname", optional=false)
    public String appname;
    @Param(name="modulename", optional=false)
    public String modulename;
    @Inject
    private AppClientDeployer appClientDeployer;
    @Inject
    private Applications apps;

    public void execute(AdminCommandContext context) {
        ActionReport report = context.getActionReport();
        Application app = this.apps.getApplication(this.appname);
        if (app != null) {
            Module appClient = app.getModule(this.modulename);
            if (appClient == null) {
                appClient = app.getModule(this.modulename + ".jar");
            }
            if (appClient != null) {
                String result = appClient.getPropertyValue("jws.user.friendly.path");
                if (result == null) {
                    result = app.getPropertyValue("jws.user.friendly.path");
                }
                if (result != null) {
                    report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
                    report.getTopMessagePart().addProperty(URI_PROPERTY_NAME, result);
                    report.setMessage(result);
                    return;
                }
            }
        }
        report.setActionExitCode(ActionReport.ExitCode.FAILURE);
        report.setMessage(localStrings.getLocalString(this.getClass(), "getreljwsuri.appOrModuleNotFound", "Could not find application {0}, module {1}", new Object[]{this.appname, this.modulename}));
    }
}

