/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.yasson.internal.properties;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import org.eclipse.yasson.internal.properties.MessageKeys;

public class Messages {
    private static final String MESSAGE_BUNDLE = "yasson-messages";
    private static final String ENCODING = "UTF-8";

    private Messages() {
    }

    public static String getMessage(MessageKeys key, Object ... objects) {
        return Messages.getMessage(key, Locale.getDefault(), objects);
    }

    public static String getMessage(MessageKeys key, Locale locale, Object ... objects) {
        ResourceBundle messages = Messages.getResourceBundle(locale);
        MessageFormat formatter = new MessageFormat(messages.getString(key.key));
        return formatter.format(objects);
    }

    private static ResourceBundle getResourceBundle(Locale locale) {
        try {
            return ResourceBundle.getBundle(MESSAGE_BUNDLE, locale, new UTF8Control());
        }
        catch (UnsupportedOperationException e) {
            return ResourceBundle.getBundle(MESSAGE_BUNDLE, locale);
        }
    }

    static class UTF8Control
    extends ResourceBundle.Control {
        UTF8Control() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ResourceBundle newBundle(String baseName, Locale locale, String format, ClassLoader loader, boolean reload) throws IllegalAccessException, InstantiationException, IOException {
            String bundleName = this.toBundleName(baseName, locale);
            String resourceName = this.toResourceName(bundleName, "properties");
            PropertyResourceBundle bundle = null;
            InputStream stream = null;
            if (reload) {
                URLConnection connection;
                URL url = loader.getResource(resourceName);
                if (url != null && (connection = url.openConnection()) != null) {
                    connection.setUseCaches(false);
                    stream = connection.getInputStream();
                }
            } else {
                stream = loader.getResourceAsStream(resourceName);
            }
            if (stream != null) {
                try {
                    bundle = new PropertyResourceBundle(new InputStreamReader(stream, Messages.ENCODING));
                }
                finally {
                    stream.close();
                }
            }
            return bundle;
        }
    }
}

