/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.ejb.security.application;

import com.sun.ejb.EjbInvocation;
import com.sun.enterprise.deployment.EjbBundleDescriptor;
import com.sun.enterprise.deployment.EjbIORConfigurationDescriptor;
import com.sun.enterprise.deployment.MethodDescriptor;
import com.sun.enterprise.deployment.MethodPermission;
import com.sun.enterprise.deployment.RoleReference;
import com.sun.enterprise.deployment.RunAsIdentityDescriptor;
import com.sun.enterprise.security.SecurityContext;
import com.sun.enterprise.security.SecurityManager;
import com.sun.enterprise.security.auth.login.LoginContextDriver;
import com.sun.enterprise.security.authorize.PolicyContextHandlerImpl;
import com.sun.enterprise.security.common.AppservAccessController;
import com.sun.enterprise.security.ee.CachedPermission;
import com.sun.enterprise.security.ee.CachedPermissionImpl;
import com.sun.enterprise.security.ee.PermissionCache;
import com.sun.enterprise.security.ee.PermissionCacheFactory;
import com.sun.enterprise.security.ee.SecurityUtil;
import com.sun.enterprise.security.ee.audit.AppServerAuditManager;
import com.sun.logging.LogDomains;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.AccessControlContext;
import java.security.AccessControlException;
import java.security.AccessController;
import java.security.CodeSource;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.security.Policy;
import java.security.Principal;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.ProtectionDomain;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.auth.Subject;
import javax.security.auth.SubjectDomainCombiner;
import javax.security.jacc.EJBMethodPermission;
import javax.security.jacc.EJBRoleRefPermission;
import javax.security.jacc.PolicyConfiguration;
import javax.security.jacc.PolicyConfigurationFactory;
import javax.security.jacc.PolicyContext;
import javax.security.jacc.PolicyContextException;
import org.glassfish.api.invocation.ComponentInvocation;
import org.glassfish.api.invocation.InvocationException;
import org.glassfish.api.invocation.InvocationManager;
import org.glassfish.deployment.common.SecurityRoleMapperFactory;
import org.glassfish.ejb.deployment.descriptor.EjbDescriptor;
import org.glassfish.ejb.security.application.EjbSecurityProbeProvider;
import org.glassfish.ejb.security.application.EjbSecurityStatsProvider;
import org.glassfish.ejb.security.factory.EJBSecurityManagerFactory;
import org.glassfish.external.probe.provider.PluginPoint;
import org.glassfish.external.probe.provider.StatsProviderManager;
import org.glassfish.security.common.Role;

public final class EJBSecurityManager
implements SecurityManager {
    private static final Logger _logger = LogDomains.getLogger(EJBSecurityManager.class, (String)"javax.enterprise.system.container.ejb");
    private AppServerAuditManager auditManager;
    private static final PolicyContextHandlerImpl pcHandlerImpl = (PolicyContextHandlerImpl)PolicyContextHandlerImpl.getInstance();
    private final SecurityRoleMapperFactory roleMapperFactory;
    private final EjbDescriptor deploymentDescriptor;
    private final RunAsIdentityDescriptor runAs;
    private static PolicyConfigurationFactory pcf = null;
    private String ejbName = null;
    private String contextId = null;
    private String codebase = null;
    private CodeSource codesource = null;
    private String realmName = null;
    private final Map cacheProtectionDomain = Collections.synchronizedMap(new WeakHashMap());
    private final Map protectionDomainCache = Collections.synchronizedMap(new WeakHashMap());
    private final Map accessControlContextCache = Collections.synchronizedMap(new WeakHashMap());
    private PermissionCache uncheckedMethodPermissionCache = null;
    private final Policy policy;
    private static final CodeSource managerCodeSource = EJBSecurityManager.class.getProtectionDomain().getCodeSource();
    private final InvocationManager invMgr;
    private final EJBSecurityManagerFactory ejbSFM;
    private final EjbSecurityProbeProvider probeProvider = new EjbSecurityProbeProvider();
    private static volatile EjbSecurityStatsProvider ejbStatsProvider = null;

    public EJBSecurityManager(EjbDescriptor ejbDescriptor, InvocationManager invMgr, EJBSecurityManagerFactory fact) throws Exception {
        boolean runas;
        this.deploymentDescriptor = ejbDescriptor;
        this.invMgr = invMgr;
        this.roleMapperFactory = SecurityUtil.getRoleMapperFactory();
        this.policy = Policy.getPolicy();
        this.ejbSFM = fact;
        boolean bl = runas = this.deploymentDescriptor.getUsesCallerIdentity() == false;
        if (runas) {
            this.runAs = this.deploymentDescriptor.getRunAsIdentity();
            if (this.runAs != null && _logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, this.deploymentDescriptor.getEjbClassName() + " will run-as: " + this.runAs.getPrincipal() + " (" + this.runAs.getRoleName() + ")");
            }
        } else {
            this.runAs = null;
        }
        this.initialize();
    }

    private static CodeSource getApplicationCodeSource(String pcid) throws Exception {
        CodeSource result = null;
        String archiveURI = "file:///" + pcid.replace(' ', '_');
        try {
            URI uri = null;
            try {
                uri = new URI(archiveURI);
                if (uri != null) {
                    result = new CodeSource(uri.toURL(), (Certificate[])null);
                }
            }
            catch (URISyntaxException use) {
                _logger.log(Level.SEVERE, "JACC_createurierror", use);
                throw new RuntimeException(use);
            }
        }
        catch (MalformedURLException mue) {
            _logger.log(Level.SEVERE, "JACC_ejbsm.codesourceerror", mue);
            throw new RuntimeException(mue);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static PolicyConfigurationFactory getPolicyFactory() throws PolicyContextException {
        Class<EJBSecurityManager> clazz = EJBSecurityManager.class;
        synchronized (EJBSecurityManager.class) {
            if (pcf == null) {
                try {
                    pcf = PolicyConfigurationFactory.getPolicyConfigurationFactory();
                }
                catch (ClassNotFoundException cnfe) {
                    _logger.severe("jaccfactory.notfound");
                    throw new PolicyContextException((Throwable)cnfe);
                }
                catch (PolicyContextException pce) {
                    _logger.severe("jaccfactory.notfound");
                    throw pce;
                }
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return pcf;
        }
    }

    public boolean getUsesCallerIdentity() {
        return this.runAs == null;
    }

    public void loadPolicyConfiguration(EjbDescriptor eDescriptor) throws Exception {
        boolean inService = EJBSecurityManager.getPolicyFactory().inService(this.contextId);
        if (!inService) {
            EJBSecurityManager.convertEJBMethodPermissions(eDescriptor, this.contextId);
            EJBSecurityManager.convertEJBRoleReferences(eDescriptor, this.contextId);
            if (_logger.isLoggable(Level.FINE)) {
                _logger.fine("JACC: policy translated for policy context:" + this.contextId);
            }
        }
    }

    public static String getContextID(EjbDescriptor ejbDesc) {
        return SecurityUtil.getContextID((EjbBundleDescriptor)ejbDesc.getEjbBundleDescriptor());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private void initialize() throws Exception {
        Set<EjbIORConfigurationDescriptor> iorConfigs;
        Iterator<EjbIORConfigurationDescriptor> iter;
        if (ejbStatsProvider == null) {
            Class<EjbSecurityStatsProvider> clazz = EjbSecurityStatsProvider.class;
            // MONITORENTER : org.glassfish.ejb.security.application.EjbSecurityStatsProvider.class
            if (ejbStatsProvider == null) {
                ejbStatsProvider = new EjbSecurityStatsProvider();
                StatsProviderManager.register((String)"security", (PluginPoint)PluginPoint.SERVER, (String)"security/ejb", (Object)ejbStatsProvider);
            }
            // MONITOREXIT : clazz
        }
        this.contextId = EJBSecurityManager.getContextID(this.deploymentDescriptor);
        String appName = this.deploymentDescriptor.getApplication().getRegistrationName();
        this.roleMapperFactory.setAppNameForContext(appName, this.contextId);
        this.codesource = EJBSecurityManager.getApplicationCodeSource(this.contextId);
        this.ejbName = this.deploymentDescriptor.getName();
        this.realmName = this.deploymentDescriptor.getApplication().getRealm();
        if (this.realmName == null && (iter = (iorConfigs = this.deploymentDescriptor.getIORConfigurationDescriptors()).iterator()) != null) {
            while (iter.hasNext()) {
                this.realmName = iter.next().getRealmName();
            }
        }
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("JACC: Context id (id under which all EJB's in application will be created) = " + this.contextId);
            _logger.fine("Codebase (module id for ejb " + this.ejbName + ") = " + this.codebase);
        }
        this.loadPolicyConfiguration(this.deploymentDescriptor);
        this.uncheckedMethodPermissionCache = PermissionCacheFactory.createPermissionCache((String)this.contextId, (CodeSource)this.codesource, EJBMethodPermission.class, (String)this.ejbName);
        this.auditManager = this.ejbSFM.getAuditManager();
    }

    private static void convertEJBRoleReferences(EjbDescriptor eDescriptor, String pcid) throws PolicyContextException {
        EJBRoleRefPermission ejbrr;
        PolicyConfiguration pc = EJBSecurityManager.getPolicyFactory().getPolicyConfiguration(pcid, false);
        assert (pc != null);
        Set roleset = eDescriptor.getEjbBundleDescriptor().getRoles();
        Role anyAuthUserRole = new Role("**");
        boolean rolesetContainsAnyAuthUserRole = roleset.contains(anyAuthUserRole);
        ArrayList<Role> role = new ArrayList<Role>();
        String eName = eDescriptor.getName();
        for (RoleReference roleRef : eDescriptor.getRoleReferences()) {
            String rolename = roleRef.getRoleName();
            ejbrr = new EJBRoleRefPermission(eName, rolename);
            String rolelink = roleRef.getSecurityRoleLink().getName();
            role.add(new Role(rolename));
            pc.addToRole(rolelink, (Permission)ejbrr);
            if (!_logger.isLoggable(Level.FINE)) continue;
            _logger.fine("JACC: Converting role-ref -> " + roleRef.toString() + " to permission with name(" + ejbrr.getName() + ") and actions (" + ejbrr.getActions() + ")mapped to role (" + rolelink + ")");
        }
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "JACC: Converting role-ref: Going through the list of roles not present in RoleRef elements and creating EJBRoleRefPermissions ");
        }
        for (Role r : roleset) {
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, "JACC: Converting role-ref: Looking at Role =  " + r.getName());
            }
            if (role.contains(r)) continue;
            String action = r.getName();
            ejbrr = new EJBRoleRefPermission(eName, action);
            pc.addToRole(action, (Permission)ejbrr);
            if (!_logger.isLoggable(Level.FINE)) continue;
            _logger.fine("JACC: Converting role-ref: Role =  " + r.getName() + " is added as a permission with name(" + ejbrr.getName() + ") and actions (" + ejbrr.getActions() + ")mapped to role (" + action + ")");
        }
        if (!role.contains(anyAuthUserRole) && !rolesetContainsAnyAuthUserRole) {
            String rolename = anyAuthUserRole.getName();
            EJBRoleRefPermission ejbrr2 = new EJBRoleRefPermission(eName, rolename);
            pc.addToRole(rolename, (Permission)ejbrr2);
            if (_logger.isLoggable(Level.FINE)) {
                _logger.fine("JACC: Converting role-ref: Adding any authenticated user role-ref  to permission with name(" + ejbrr2.getName() + ") and actions (" + ejbrr2.getActions() + ")mapped to role (" + rolename + ")");
            }
        }
    }

    private static HashMap addToRolePermissionsTable(HashMap table, MethodPermission mp, EJBMethodPermission ejbmp) {
        if (mp.isRoleBased()) {
            String roleName;
            Permissions rolePermissions;
            if (table == null) {
                table = new HashMap<String, Permissions>();
            }
            if ((rolePermissions = (Permissions)table.get(roleName = mp.getRole().getName())) == null) {
                rolePermissions = new Permissions();
                table.put(roleName, rolePermissions);
            }
            rolePermissions.add((Permission)ejbmp);
            if (_logger.isLoggable(Level.FINE)) {
                _logger.fine("JACC DD conversion: EJBMethodPermission ->(" + ejbmp.getName() + " " + ejbmp.getActions() + ")protected by role -> " + roleName);
            }
        }
        return table;
    }

    private static Permissions addToUncheckedPermissions(Permissions permissions, MethodPermission mp, EJBMethodPermission ejbmp) {
        if (mp.isUnchecked()) {
            if (permissions == null) {
                permissions = new Permissions();
            }
            permissions.add((Permission)ejbmp);
            if (_logger.isLoggable(Level.FINE)) {
                _logger.fine("JACC DD conversion: EJBMethodPermission ->(" + ejbmp.getName() + " " + ejbmp.getActions() + ") is (unchecked)");
            }
        }
        return permissions;
    }

    private static Permissions addToExcludedPermissions(Permissions permissions, MethodPermission mp, EJBMethodPermission ejbmp) {
        if (mp.isExcluded()) {
            if (permissions == null) {
                permissions = new Permissions();
            }
            permissions.add((Permission)ejbmp);
            if (_logger.isLoggable(Level.FINE)) {
                _logger.fine("JACC DD conversion: EJBMethodPermission ->(" + ejbmp.getName() + " " + ejbmp.getActions() + ") is (excluded)");
            }
        }
        return permissions;
    }

    private static void convertEJBMethodPermissions(EjbDescriptor eDescriptor, String pcid) throws PolicyContextException {
        PolicyConfiguration pc = EJBSecurityManager.getPolicyFactory().getPolicyConfiguration(pcid, false);
        assert (pc != null);
        String eName = eDescriptor.getName();
        Permissions uncheckedPermissions = null;
        Permissions excludedPermissions = null;
        HashMap rolePermissionsTable = null;
        EJBMethodPermission ejbmp = null;
        HashMap mpMap = eDescriptor.getMethodPermissionsFromDD();
        if (mpMap != null) {
            for (Map.Entry entry : mpMap.entrySet()) {
                MethodPermission mp = (MethodPermission)entry.getKey();
                for (MethodDescriptor md : (ArrayList)entry.getValue()) {
                    String mthdName = md.getName();
                    String mthdIntf = md.getEjbClassSymbol();
                    String[] mthdParams = md.getStyle() == 3 ? md.getParameterClassNames() : null;
                    ejbmp = new EJBMethodPermission(eName, mthdName.equals("*") ? null : mthdName, mthdIntf, mthdParams);
                    rolePermissionsTable = EJBSecurityManager.addToRolePermissionsTable(rolePermissionsTable, mp, ejbmp);
                    uncheckedPermissions = EJBSecurityManager.addToUncheckedPermissions(uncheckedPermissions, mp, ejbmp);
                    excludedPermissions = EJBSecurityManager.addToExcludedPermissions(excludedPermissions, mp, ejbmp);
                }
            }
        }
        for (MethodDescriptor md : eDescriptor.getMethodDescriptors()) {
            Method mthd = md.getMethod((com.sun.enterprise.deployment.EjbDescriptor)eDescriptor);
            String mthdIntf = md.getEjbClassSymbol();
            if (mthd == null) continue;
            if (mthdIntf == null || mthdIntf.equals("")) {
                _logger.log(Level.SEVERE, "method_descriptor_not_defined", new Object[]{eName, md.getName(), md.getParameterClassNames()});
                continue;
            }
            ejbmp = new EJBMethodPermission(eName, mthdIntf, mthd);
            for (MethodPermission mp : eDescriptor.getMethodPermissionsFor(md)) {
                rolePermissionsTable = EJBSecurityManager.addToRolePermissionsTable(rolePermissionsTable, mp, ejbmp);
                uncheckedPermissions = EJBSecurityManager.addToUncheckedPermissions(uncheckedPermissions, mp, ejbmp);
                excludedPermissions = EJBSecurityManager.addToExcludedPermissions(excludedPermissions, mp, ejbmp);
            }
        }
        if (uncheckedPermissions != null) {
            pc.addToUncheckedPolicy(uncheckedPermissions);
        }
        if (excludedPermissions != null) {
            pc.addToExcludedPolicy(excludedPermissions);
        }
        if (rolePermissionsTable != null) {
            for (Map.Entry entry : rolePermissionsTable.entrySet()) {
                pc.addToRole((String)entry.getKey(), (PermissionCollection)((Permissions)entry.getValue()));
            }
        }
    }

    private ProtectionDomain getCachedProtectionDomain(Set principalSet, boolean applicationCodeSource) {
        ProtectionDomain prdm = null;
        Principal[] principals = null;
        CodeSource cs = null;
        if (applicationCodeSource) {
            prdm = (ProtectionDomain)this.cacheProtectionDomain.get(principalSet);
            cs = this.codesource;
        } else {
            prdm = (ProtectionDomain)this.protectionDomainCache.get(principalSet);
            cs = managerCodeSource;
        }
        if (prdm == null) {
            HashSet newKeySet;
            principals = principalSet == null ? null : principalSet.toArray(new Principal[principalSet.size()]);
            prdm = new ProtectionDomain(cs, null, null, principals);
            HashSet hashSet = newKeySet = principalSet != null ? new HashSet(principalSet) : new HashSet();
            if (applicationCodeSource) {
                this.cacheProtectionDomain.put(newKeySet, prdm);
            } else {
                this.protectionDomainCache.put(newKeySet, prdm);
            }
            if (_logger.isLoggable(Level.FINE)) {
                _logger.fine("JACC: new ProtectionDomain added to cache");
            }
        }
        if (_logger.isLoggable(Level.FINE)) {
            if (principalSet == null) {
                _logger.fine("JACC: returning cached ProtectionDomain PrincipalSet: null");
            } else {
                StringBuffer pBuf = null;
                principals = principalSet.toArray(new Principal[principalSet.size()]);
                for (int i = 0; i < principals.length; ++i) {
                    if (i == 0) {
                        pBuf = new StringBuffer(principals[i].toString());
                        continue;
                    }
                    pBuf.append(" " + principals[i].toString());
                }
                _logger.fine("JACC: returning cached ProtectionDomain - CodeSource: (" + cs + ") PrincipalSet: " + pBuf);
            }
        }
        return prdm;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean authorize(ComponentInvocation compInv) {
        if (!(compInv instanceof EjbInvocation)) {
            return false;
        }
        EjbInvocation inv = (EjbInvocation)compInv;
        if (inv.getAuth() != null) {
            return inv.getAuth();
        }
        boolean ret = false;
        CachedPermission cp = null;
        Object ejbmp = null;
        if (inv.invocationInfo == null || inv.invocationInfo.cachedPermission == null) {
            ejbmp = new EJBMethodPermission(this.ejbName, inv.getMethodInterface(), inv.method);
            cp = new CachedPermissionImpl(this.uncheckedMethodPermissionCache, (Permission)ejbmp);
            if (inv.invocationInfo != null) {
                inv.invocationInfo.cachedPermission = cp;
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.fine("JACC: permission initialized in InvocationInfo: EJBMethodPermission (Name) = " + ((Permission)ejbmp).getName() + " (Action) = " + ((Permission)ejbmp).getActions());
                }
            }
        } else {
            cp = inv.invocationInfo.cachedPermission;
            ejbmp = cp.getPermission();
        }
        String caller = null;
        SecurityContext sc = null;
        pcHandlerImpl.getHandlerData().setInvocation((ComponentInvocation)inv);
        ret = cp.checkPermission();
        if (!ret) {
            sc = SecurityContext.getCurrent();
            Set principalSet = sc.getPrincipalSet();
            ProtectionDomain prdm = this.getCachedProtectionDomain(principalSet, true);
            try {
                String oldContextId = EJBSecurityManager.setPolicyContext(this.contextId);
                try {
                    ret = this.policy.implies(prdm, (Permission)ejbmp);
                }
                catch (SecurityException se) {
                    _logger.log(Level.SEVERE, "jacc_access_exception", se);
                    ret = false;
                }
                catch (Throwable t) {
                    _logger.log(Level.SEVERE, "jacc_access_exception", t);
                    ret = false;
                }
                finally {
                    EJBSecurityManager.resetPolicyContext(oldContextId, this.contextId);
                }
            }
            catch (Throwable t) {
                _logger.log(Level.SEVERE, "jacc_policy_context_exception", t);
                ret = false;
            }
        }
        inv.setAuth(ret ? Boolean.TRUE : Boolean.FALSE);
        if (this.auditManager.isAuditOn()) {
            if (sc == null) {
                sc = SecurityContext.getCurrent();
            }
            caller = sc.getCallerPrincipal().getName();
            this.auditManager.ejbInvocation(caller, this.ejbName, inv.method.toString(), ret);
        }
        if (ret && inv.isWebService && !inv.isPreInvokeDone()) {
            this.preInvoke(inv);
        }
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("JACC: Access Control Decision Result: " + ret + " EJBMethodPermission (Name) = " + ((Permission)ejbmp).getName() + " (Action) = " + ((Permission)ejbmp).getActions() + " (Caller) = " + caller);
        }
        return ret;
    }

    public void preInvoke(ComponentInvocation inv) {
        if (this.runAs == null) {
            inv.setPreInvokeDone(true);
            return;
        }
        boolean isWebService = false;
        if (inv instanceof EjbInvocation) {
            isWebService = ((EjbInvocation)inv).isWebService;
        }
        if ((!isWebService || inv.getAuth() != null && inv.getAuth().booleanValue()) && !inv.isPreInvokeDone()) {
            inv.setOldSecurityContext((Object)SecurityContext.getCurrent());
            this.loginForRunAs();
            inv.setPreInvokeDone(true);
        }
    }

    public void postInvoke(ComponentInvocation inv) {
        if (this.runAs != null && inv.isPreInvokeDone()) {
            final ComponentInvocation finv = inv;
            AppservAccessController.doPrivileged((PrivilegedAction)new PrivilegedAction(){

                public Object run() {
                    SecurityContext.setCurrent((SecurityContext)((SecurityContext)finv.getOldSecurityContext()));
                    return null;
                }
            });
        }
    }

    private void loginForRunAs() {
        AppservAccessController.doPrivileged((PrivilegedAction)new PrivilegedAction(){

            public Object run() {
                LoginContextDriver.loginPrincipal((String)EJBSecurityManager.this.runAs.getPrincipal(), (String)EJBSecurityManager.this.realmName);
                return null;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isCallerInRole(String role) {
        SecurityContext sc;
        boolean ret = false;
        if (_logger.isLoggable(Level.FINE)) {
            _logger.entering("EJBSecurityManager", "isCallerInRole", role);
        }
        EJBRoleRefPermission ejbrr = new EJBRoleRefPermission(this.ejbName, role);
        if (this.runAs != null) {
            ComponentInvocation ci = this.invMgr.getCurrentInvocation();
            sc = (SecurityContext)ci.getOldSecurityContext();
        } else {
            sc = SecurityContext.getCurrent();
        }
        Set principalSet = sc != null ? sc.getPrincipalSet() : null;
        ProtectionDomain prdm = this.getCachedProtectionDomain(principalSet, true);
        String oldContextId = null;
        try {
            oldContextId = EJBSecurityManager.setPolicyContext(this.contextId);
            ret = this.policy.implies(prdm, (Permission)ejbrr);
        }
        catch (SecurityException se) {
            _logger.log(Level.SEVERE, "jacc_is_caller_in_role_exception", se);
            ret = false;
        }
        catch (Throwable t) {
            _logger.log(Level.SEVERE, "jacc_is_caller_in_role_exception", t);
            ret = false;
        }
        finally {
            try {
                EJBSecurityManager.resetPolicyContext(oldContextId, this.contextId);
            }
            catch (Throwable ex) {
                _logger.log(Level.SEVERE, "jacc_policy_context_exception", ex);
                ret = false;
            }
        }
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("JACC: isCallerInRole Result: " + ret + " EJBRoleRefPermission (Name) = " + ejbrr.getName() + " (Action) = " + ejbrr.getActions() + " (Codesource) = " + prdm.getCodeSource());
        }
        return ret;
    }

    public Principal getCallerPrincipal() {
        SecurityContext sc = null;
        if (this.runAs != null) {
            ComponentInvocation ci = this.invMgr.getCurrentInvocation();
            if (ci == null) {
                throw new InvocationException();
            }
            sc = (SecurityContext)ci.getOldSecurityContext();
        } else {
            sc = SecurityContext.getCurrent();
        }
        Principal prin = sc != null ? sc.getCallerPrincipal() : SecurityContext.getDefaultCallerPrincipal();
        return prin;
    }

    public void destroy() {
        try {
            boolean wasInService = EJBSecurityManager.getPolicyFactory().inService(this.contextId);
            if (wasInService) {
                this.policy.refresh();
            }
            PermissionCacheFactory.removePermissionCache((PermissionCache)this.uncheckedMethodPermissionCache);
            this.uncheckedMethodPermissionCache = null;
            this.roleMapperFactory.removeAppNameForContext(this.contextId);
        }
        catch (PolicyContextException pce) {
            String msg = "ejbsm.could_not_delete";
            _logger.log(Level.WARNING, msg, pce);
        }
        this.probeProvider.securityManagerDestructionStartedEvent(this.ejbName);
        this.ejbSFM.getManager(this.contextId, this.ejbName, true);
        this.probeProvider.securityManagerDestructionEndedEvent(this.ejbName);
        this.probeProvider.securityManagerDestructionEvent(this.ejbName);
    }

    public Subject getCurrentSubject() {
        return SecurityContext.getCurrent().getSubject();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object doAsPrivileged(PrivilegedExceptionAction pea) throws Throwable {
        SecurityContext sc = SecurityContext.getCurrent();
        Set principalSet = sc.getPrincipalSet();
        AccessControlContext acc = (AccessControlContext)this.accessControlContextCache.get(principalSet);
        if (acc == null) {
            final ProtectionDomain[] pdArray = new ProtectionDomain[]{this.getCachedProtectionDomain(principalSet, false)};
            try {
                if (principalSet != null) {
                    final Subject s = sc.getSubject();
                    acc = (AccessControlContext)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                        public Object run() throws Exception {
                            return new AccessControlContext(new AccessControlContext(pdArray), new SubjectDomainCombiner(s));
                        }
                    });
                } else {
                    acc = new AccessControlContext(pdArray);
                }
                if (principalSet != null) {
                    this.accessControlContextCache.put(new HashSet(principalSet), acc);
                }
                _logger.fine("JACC: new AccessControlContext added to cache");
            }
            catch (Exception e) {
                _logger.log(Level.SEVERE, "java_security.security_context_exception", e);
                acc = null;
                throw e;
            }
        }
        Object rvalue = null;
        String oldContextId = EJBSecurityManager.setPolicyContext(this.contextId);
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("JACC: doAsPrivileged contextId(" + this.contextId + ")");
        }
        try {
            rvalue = AccessController.doPrivileged(pea, acc);
        }
        finally {
            EJBSecurityManager.resetPolicyContext(oldContextId, this.contextId);
        }
        return rvalue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object runMethod(Method beanClassMethod, Object obj, Object[] oa) throws Throwable {
        String oldCtxID = EJBSecurityManager.setPolicyContext(this.contextId);
        Object ret = null;
        try {
            ret = beanClassMethod.invoke(obj, oa);
        }
        finally {
            EJBSecurityManager.resetPolicyContext(oldCtxID, this.contextId);
        }
        return ret;
    }

    private static void resetPolicyContext(final String newV, String oldV) throws Throwable {
        if (!(newV == null || oldV != null && oldV.equals(newV))) {
            if (_logger.isLoggable(Level.FINE)) {
                _logger.fine("JACC: Changing Policy Context ID: oldV = " + oldV + " newV = " + newV);
            }
            try {
                AppservAccessController.doPrivileged((PrivilegedExceptionAction)new PrivilegedExceptionAction(){

                    public Object run() throws Exception {
                        PolicyContext.setContextID((String)newV);
                        return null;
                    }
                });
            }
            catch (PrivilegedActionException pae) {
                Throwable cause = pae.getCause();
                if (cause instanceof AccessControlException) {
                    _logger.log(Level.SEVERE, "jacc_policy_context_security_exception", cause);
                } else {
                    _logger.log(Level.SEVERE, "jacc_policy_context_exception", cause);
                }
                throw cause;
            }
        }
    }

    private static String setPolicyContext(String newV) throws Throwable {
        String oldV = PolicyContext.getContextID();
        EJBSecurityManager.resetPolicyContext(newV, oldV);
        return oldV;
    }

    public Object invoke(Method beanClassMethod, boolean isLocal, Object o, Object[] oa) throws Throwable {
        final Method meth = beanClassMethod;
        final Object obj = o;
        final Object[] objArr = oa;
        Object ret = null;
        if (isLocal && this.getUsesCallerIdentity() || System.getSecurityManager() == null) {
            ret = this.runMethod(meth, obj, objArr);
        } else {
            PrivilegedExceptionAction pea = new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    return meth.invoke(obj, objArr);
                }
            };
            try {
                ret = this.doAsPrivileged(pea);
            }
            catch (PrivilegedActionException pae) {
                Throwable cause = pae.getCause();
                throw cause;
            }
        }
        return ret;
    }

    public void resetPolicyContext() {
        if (System.getSecurityManager() == null) {
            ((PolicyContextHandlerImpl)PolicyContextHandlerImpl.getInstance()).reset();
            PolicyContext.setContextID(null);
            return;
        }
        try {
            AppservAccessController.doPrivileged((PrivilegedExceptionAction)new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    ((PolicyContextHandlerImpl)PolicyContextHandlerImpl.getInstance()).reset();
                    PolicyContext.setContextID(null);
                    return null;
                }
            });
        }
        catch (PrivilegedActionException pae) {
            Throwable cause = pae.getCause();
            if (cause instanceof AccessControlException) {
                _logger.log(Level.SEVERE, "jacc_policy_context_security_exception", cause);
            } else {
                _logger.log(Level.SEVERE, "jacc_policy_context_exception", cause);
            }
            throw new RuntimeException(cause);
        }
    }
}

