/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ejb.containers;

import com.sun.appserv.util.cache.CacheListener;
import com.sun.ejb.ComponentContext;
import com.sun.ejb.EJBUtils;
import com.sun.ejb.EjbInvocation;
import com.sun.ejb.InvocationInfo;
import com.sun.ejb.MethodLockInfo;
import com.sun.ejb.base.stats.HAStatefulSessionStoreMonitor;
import com.sun.ejb.base.stats.StatefulSessionStoreMonitor;
import com.sun.ejb.containers.BaseContainer;
import com.sun.ejb.containers.ContainerSynchronization;
import com.sun.ejb.containers.EJBContextImpl;
import com.sun.ejb.containers.EJBLocalObjectImpl;
import com.sun.ejb.containers.EJBLocalRemoteObject;
import com.sun.ejb.containers.EJBObjectImpl;
import com.sun.ejb.containers.EjbContainerUtilImpl;
import com.sun.ejb.containers.PeriodicTask;
import com.sun.ejb.containers.RemoteBusinessIntfInfo;
import com.sun.ejb.containers.SessionContextImpl;
import com.sun.ejb.containers.util.cache.LruSessionCache;
import com.sun.ejb.monitoring.probes.EjbCacheProbeProvider;
import com.sun.ejb.monitoring.stats.EjbCacheStatsProvider;
import com.sun.ejb.monitoring.stats.EjbMonitoringStatsProvider;
import com.sun.ejb.monitoring.stats.EjbMonitoringUtils;
import com.sun.ejb.monitoring.stats.StatefulSessionBeanStatsProvider;
import com.sun.ejb.spi.container.SFSBContainerCallback;
import com.sun.ejb.spi.container.StatefulEJBContext;
import com.sun.ejb.spi.sfsb.util.SFSBUUIDUtil;
import com.sun.ejb.spi.sfsb.util.SFSBVersionManager;
import com.sun.enterprise.admin.monitor.callflow.ComponentType;
import com.sun.enterprise.container.common.impl.EntityManagerFactoryWrapper;
import com.sun.enterprise.container.common.impl.EntityManagerWrapper;
import com.sun.enterprise.container.common.impl.PhysicalEntityManagerWrapper;
import com.sun.enterprise.container.common.spi.util.IndirectlySerializable;
import com.sun.enterprise.container.common.spi.util.SerializableObjectFactory;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.EntityManagerReferenceDescriptor;
import com.sun.enterprise.deployment.LifecycleCallbackDescriptor;
import com.sun.enterprise.deployment.MethodDescriptor;
import com.sun.enterprise.security.SecurityManager;
import com.sun.enterprise.transaction.api.JavaEETransaction;
import com.sun.enterprise.transaction.api.SimpleResource;
import com.sun.enterprise.util.Utility;
import com.sun.enterprise.util.io.FileUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.NotSerializableException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.security.AccessController;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ejb.ConcurrentAccessException;
import javax.ejb.ConcurrentAccessTimeoutException;
import javax.ejb.CreateException;
import javax.ejb.EJBException;
import javax.ejb.EJBHome;
import javax.ejb.EJBLocalHome;
import javax.ejb.EJBObject;
import javax.ejb.IllegalLoopbackException;
import javax.ejb.NoSuchObjectLocalException;
import javax.ejb.RemoveException;
import javax.ejb.SessionBean;
import javax.ejb.SessionContext;
import javax.ejb.SessionSynchronization;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.PersistenceContextType;
import javax.persistence.SynchronizationType;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import org.glassfish.api.invocation.ComponentInvocation;
import org.glassfish.api.invocation.ResourceHandler;
import org.glassfish.ejb.LogFacade;
import org.glassfish.ejb.deployment.descriptor.EjbRemovalInfo;
import org.glassfish.ejb.deployment.descriptor.EjbSessionDescriptor;
import org.glassfish.ejb.deployment.descriptor.runtime.CheckpointAtEndOfMethodDescriptor;
import org.glassfish.ejb.deployment.descriptor.runtime.IASEjbExtraDescriptors;
import org.glassfish.flashlight.provider.ProbeProviderFactory;
import org.glassfish.ha.store.api.BackingStore;
import org.glassfish.ha.store.api.BackingStoreException;
import org.glassfish.ha.store.util.SimpleMetadata;
import org.glassfish.logging.annotation.LogMessageInfo;

public final class StatefulSessionContainer
extends BaseContainer
implements CacheListener,
SFSBContainerCallback {
    private static final Logger _logger = LogFacade.getLogger();
    @LogMessageInfo(message="[SFSBContainer] Exception while  initializing SessionSynchronization methods", level="WARNING")
    private static final String EXCEPTION_WHILE_INITIALIZING_SESSION_SYNCHRONIZATION = "AS-EJB-00012";
    @LogMessageInfo(message="[SFSBContainer] Exception while  loading checkpoint info", level="WARNING")
    private static final String EXCEPTION_WHILE_LOADING_CHECKPOINT = "AS-EJB-00013";
    @LogMessageInfo(message="Exception creating ejb object : [{0}]", level="WARNING")
    private static final String CREATE_EJBOBJECT_EXCEPTION = "AS-EJB-00014";
    @LogMessageInfo(message="Exception creating ejb local object [{0}]", level="WARNING")
    private static final String CREATE_EJBLOCALOBJECT_EXCEPTION = "AS-EJB-00015";
    @LogMessageInfo(message="Couldn't update timestamp for: [{0}]; Exception: [{1}]", level="WARNING")
    private static final String COULDNT_UPDATE_TIMESTAMP_FOR_EXCEPTION = "AS-EJB-00016";
    @LogMessageInfo(message="Cannot register bean for checkpointing", level="WARNING")
    private static final String CANNOT_REGISTER_BEAN_FOR_CHECKPOINTING = "AS-EJB-00017";
    @LogMessageInfo(message="Error  during checkpoint ([{0}]. Key: [{1}]) [{2}]", level="WARNING")
    private static final String ERROR_DURING_CHECKPOINT_3PARAMs = "AS-EJB-00018";
    @LogMessageInfo(message="sfsb checkpoint error. Name: [{0}]", level="WARNING")
    private static final String SFSB_CHECKPOINT_ERROR_NAME = "AS-EJB-00019";
    @LogMessageInfo(message="sfsb checkpoint error. Key: [{0}]", level="WARNING")
    private static final String SFSB_CHECKPOINT_ERROR_KEY = "AS-EJB-00020";
    @LogMessageInfo(message="Exception in afterCompletion : [{0}]", level="INFO")
    private static final String AFTER_COMPLETION_EXCEPTION = "AS-EJB-00021";
    @LogMessageInfo(message="1. passivateEJB() returning because containerState: [{0}]", level="WARNING")
    private static final String PASSIVATE_EJB_RETURNING_BECAUSE_CONTAINER_STATE = "AS-EJB-00022";
    @LogMessageInfo(message="Extended EM not serializable. Exception: [{0}]", level="WARNING")
    private static final String EXTENDED_EM_NOT_SERIALIZABLE = "AS-EJB-00023";
    @LogMessageInfo(message="Error during passivation: [{0}]; [{1}]", level="WARNING")
    private static final String ERROR_DURING_PASSIVATION = "AS-EJB-00024";
    @LogMessageInfo(message="Error during passivation of [{0}]", level="WARNING")
    private static final String PASSIVATION_ERROR_1PARAM = "AS-EJB-00025";
    @LogMessageInfo(message="sfsb passivation error. Key: [{0}]", level="WARNING")
    private static final String SFSB_PASSIVATION_ERROR_1PARAM = "AS-EJB-00026";
    @LogMessageInfo(message="Error during Stateful Session Bean activation for key [{0}]", level="SEVERE", cause="A problem occurred while the container was activating a stateful session bean.  One possible cause is that the bean code threw a system exception from its ejbActivate method.", action="Check the stack trace to see whether the exception was thrown from the ejbActivate method and if so double-check the application code to determine what caused the exception.")
    private static final String SFSB_ACTIVATION_ERROR = "AS-EJB-00028";
    @LogMessageInfo(message="[{0}]: Error during backingStore.shutdown()", level="WARNING")
    private static final String ERROR_DURING_BACKING_STORE_SHUTDOWN = "AS-EJB-00029";
    @LogMessageInfo(message="[{0}]: Error during  onShutdown()", level="WARNING")
    private static final String ERROR_DURING_ON_SHUTDOWN = "AS-EJB-00030";
    @LogMessageInfo(message="[{0}]: Error while  undeploying ctx. Key: [{1}]", level="WARNING")
    private static final String ERROR_WHILE_UNDEPLOYING_CTX_KEY = "AS-EJB-00031";
    @LogMessageInfo(message="Cannot add idle bean cleanup task", level="WARNING")
    private static final String ADD_CLEANUP_TASK_ERROR = "AS-EJB-00032";
    @LogMessageInfo(message="Got exception during removeExpiredSessions (but the reaper thread is still alive)", level="WARNING")
    private static final String GOT_EXCEPTION_DURING_REMOVE_EXPIRED_SESSIONS = "AS-EJB-00033";
    @LogMessageInfo(message="Error during checkpoint(, but session not destroyed)", level="WARNING")
    private static final String ERROR_DURING_CHECKPOINT_SESSION_ALIVE = "AS-EJB-00034";
    @LogMessageInfo(message="Error during checkpoint", level="WARNING")
    private static final String ERROR_DURING_CHECKPOINT = "AS-EJB-00035";
    @LogMessageInfo(message="Cache is shutting down, {0} stateful session beans will not be restored after restarting since passivation is disabled", level="INFO")
    private static final String SFSB_NOT_RESTORED_AFTER_RESTART = "AS-EJB-00050";
    @LogMessageInfo(message="Exception in backingStore.size()", level="WARNING")
    private static final String ERROR_WHILE_BACKSTORE_SIZE_ACCESS = "AS-EJB-00063";
    public static final int MIN_PASSIVATION_BATCH_COUNT = 8;
    private static final long CONCURRENCY_NOT_ALLOWED = 0L;
    private static final long BLOCK_INDEFINITELY = -1L;
    private ArrayList passivationCandidates = new ArrayList();
    private Object asyncTaskSemaphore = new Object();
    private int asyncTaskCount = 0;
    private int asyncCummTaskCount = 0;
    private int passivationBatchCount = 8;
    private int containerTrimCount = 0;
    private LruSessionCache sessionBeanCache;
    private BackingStore<Serializable, SimpleMetadata> backingStore;
    private SFSBUUIDUtil uuidGenerator;
    private ArrayList scheduledTimerTasks = new ArrayList();
    private int statMethodReadyCount = 0;
    private Level TRACE_LEVEL = Level.FINE;
    private String ejbName;
    private boolean isHAEnabled;
    private int removalGracePeriodInSeconds;
    private InvocationInfo postConstructInvInfo;
    private InvocationInfo preDestroyInvInfo;
    private InvocationInfo postActivateInvInfo;
    private InvocationInfo prePassivateInvInfo;
    private StatefulSessionStoreMonitor sfsbStoreMonitor;
    private final String traceInfoPrefix;
    private SFSBVersionManager sfsbVersionManager;
    private Method afterBeginMethod;
    private Method beforeCompletionMethod;
    private Method afterCompletionMethod;
    private boolean isPassivationCapable;
    private static final Map<EntityManager, EEMRefInfo> extendedEMReferenceCountMap = new HashMap<EntityManager, EEMRefInfo>();
    private static final Map<EEMRefInfoKey, EntityManager> eemKey2EEMMap = new HashMap<EEMRefInfoKey, EntityManager>();

    public StatefulSessionContainer(org.glassfish.ejb.deployment.descriptor.EjbDescriptor desc, ClassLoader loader, SecurityManager sm) throws Exception {
        this(BaseContainer.ContainerType.STATEFUL, desc, loader, sm);
    }

    public StatefulSessionContainer(BaseContainer.ContainerType conType, org.glassfish.ejb.deployment.descriptor.EjbDescriptor desc, ClassLoader loader, SecurityManager sm) throws Exception {
        super(conType, desc, loader, sm);
        super.createCallFlowAgent(ComponentType.SFSB);
        this.ejbName = desc.getName();
        this.traceInfoPrefix = "sfsb-" + this.ejbName + ": ";
        this.postConstructInvInfo = this.getLifecycleCallbackInvInfo(this.ejbDescriptor.getPostConstructDescriptors());
        this.preDestroyInvInfo = this.getLifecycleCallbackInvInfo(this.ejbDescriptor.getPreDestroyDescriptors());
        EjbSessionDescriptor sfulDesc = (EjbSessionDescriptor)this.ejbDescriptor;
        this.postActivateInvInfo = this.getLifecycleCallbackInvInfo(sfulDesc.getPostActivateDescriptors());
        this.prePassivateInvInfo = this.getLifecycleCallbackInvInfo(sfulDesc.getPrePassivateDescriptors());
        this.isPassivationCapable = sfulDesc.isPassivationCapable();
    }

    @Override
    public boolean isPassivationCapable() {
        return this.isPassivationCapable;
    }

    private InvocationInfo getLifecycleCallbackInvInfo(Set<LifecycleCallbackDescriptor> lifecycleCallbackDescriptors) throws Exception {
        InvocationInfo inv = new InvocationInfo();
        inv.ejbName = this.ejbDescriptor.getName();
        inv.methodIntf = "LifecycleCallback";
        inv.txAttr = this.getTxAttrForLifecycleCallback(lifecycleCallbackDescriptors, -1, 1, 5);
        return inv;
    }

    @Override
    protected void initializeHome() throws Exception {
        super.initializeHome();
        this.initSessionSyncMethods();
        this.loadCheckpointInfo();
        this.registerMonitorableComponents();
    }

    private void initSessionSyncMethods() throws Exception {
        if (SessionSynchronization.class.isAssignableFrom(this.ejbClass)) {
            try {
                this.afterBeginMethod = this.ejbClass.getMethod("afterBegin", null);
                this.beforeCompletionMethod = this.ejbClass.getMethod("beforeCompletion", null);
                this.afterCompletionMethod = this.ejbClass.getMethod("afterCompletion", Boolean.TYPE);
            }
            catch (Exception e) {
                _logger.log(Level.WARNING, EXCEPTION_WHILE_INITIALIZING_SESSION_SYNCHRONIZATION, e);
            }
        } else {
            MethodDescriptor afterCompletionMethodDesc;
            MethodDescriptor beforeCompletionMethodDesc;
            EjbSessionDescriptor sessionDesc = (EjbSessionDescriptor)this.ejbDescriptor;
            MethodDescriptor afterBeginMethodDesc = sessionDesc.getAfterBeginMethod();
            if (afterBeginMethodDesc != null) {
                this.afterBeginMethod = afterBeginMethodDesc.getDeclaredMethod((EjbDescriptor)sessionDesc);
                this.processSessionSynchMethod(this.afterBeginMethod);
            }
            if ((beforeCompletionMethodDesc = sessionDesc.getBeforeCompletionMethod()) != null) {
                this.beforeCompletionMethod = beforeCompletionMethodDesc.getDeclaredMethod((EjbDescriptor)sessionDesc);
                this.processSessionSynchMethod(this.beforeCompletionMethod);
            }
            if ((afterCompletionMethodDesc = sessionDesc.getAfterCompletionMethod()) != null) {
                this.afterCompletionMethod = afterCompletionMethodDesc.getDeclaredMethod((EjbDescriptor)sessionDesc);
                if (this.afterCompletionMethod == null) {
                    this.afterCompletionMethod = afterCompletionMethodDesc.getDeclaredMethod((EjbDescriptor)sessionDesc, new Class[]{Boolean.TYPE});
                }
                this.processSessionSynchMethod(this.afterCompletionMethod);
            }
        }
    }

    private void processSessionSynchMethod(Method sessionSynchMethod) throws Exception {
        final Method methodAccessible = sessionSynchMethod;
        AccessController.doPrivileged(new PrivilegedExceptionAction(){

            public Object run() throws Exception {
                if (!methodAccessible.isAccessible()) {
                    methodAccessible.setAccessible(true);
                }
                return null;
            }
        });
    }

    @Override
    protected void checkUnfinishedTx(Transaction prevTx, EjbInvocation inv) {
        try {
            if (inv.invocationInfo.isBusinessMethod && prevTx != null && prevTx.getStatus() != 6) {
                throw new IllegalStateException("Bean is associated with a different unfinished transaction");
            }
        }
        catch (SystemException ex) {
            _logger.log(Level.FINE, "Exception in checkUnfinishedTx", ex);
            throw new EJBException((Exception)((Object)ex));
        }
    }

    protected void loadCheckpointInfo() {
        try {
            if (this.isHAEnabled) {
                for (InvocationInfo info : this.invocationInfoMap.values()) {
                    CheckpointAtEndOfMethodDescriptor cpDesc;
                    info.checkpointEnabled = false;
                    MethodDescriptor md = new MethodDescriptor(info.method, info.methodIntf);
                    IASEjbExtraDescriptors extraDesc = this.ejbDescriptor.getIASEjbExtraDescriptors();
                    if (extraDesc != null && (cpDesc = extraDesc.getCheckpointAtEndOfMethodDescriptor()) != null) {
                        info.checkpointEnabled = cpDesc.isCheckpointEnabledFor(md);
                    }
                    if (!info.checkpointEnabled || !_logger.isLoggable(Level.FINE)) continue;
                    _logger.log(Level.FINE, "[SFSBContainer] " + info.method + " MARKED for end-of-method-checkpoint");
                }
            }
        }
        catch (Exception ex) {
            _logger.log(Level.WARNING, EXCEPTION_WHILE_LOADING_CHECKPOINT, ex);
        }
    }

    @Override
    protected void registerMonitorableComponents() {
        this.registerEjbCacheProbeProvider();
        super.registerMonitorableComponents();
        this.cacheProbeListener = new EjbCacheStatsProvider(this.sessionBeanCache, this.getContainerId(), this.containerInfo.appName, this.containerInfo.modName, this.containerInfo.ejbName);
        this.cacheProbeListener.register();
        this.sfsbStoreMonitor = this.isHAEnabled ? new HAStatefulSessionStoreMonitor() : new StatefulSessionStoreMonitor();
        this.sessionBeanCache.setStatefulSessionStoreMonitor(this.sfsbStoreMonitor);
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "[SFSBContainer] registered monitorable");
        }
    }

    private void registerEjbCacheProbeProvider() {
        block5: {
            String appName = null;
            String modName = null;
            String ejbName = null;
            try {
                String string = appName = this.ejbDescriptor.getApplication().isVirtual() ? null : this.ejbDescriptor.getApplication().getRegistrationName();
                if (appName == null) {
                    modName = this.ejbDescriptor.getApplication().getRegistrationName();
                } else {
                    String archiveuri = this.ejbDescriptor.getEjbBundleDescriptor().getModuleDescriptor().getArchiveUri();
                    modName = FileUtils.makeFriendlyFilename((String)archiveuri);
                }
                ejbName = this.ejbDescriptor.getName();
                ProbeProviderFactory probeFactory = this.ejbContainerUtilImpl.getProbeProviderFactory();
                String invokerId = EjbMonitoringUtils.getInvokerId(appName, modName, ejbName);
                this.cacheProbeNotifier = (EjbCacheProbeProvider)probeFactory.getProbeProvider(EjbCacheProbeProvider.class, invokerId);
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.log(Level.FINE, "Got ProbeProvider: " + this.cacheProbeNotifier.getClass().getName());
                }
            }
            catch (Exception ex) {
                this.cacheProbeNotifier = new EjbCacheProbeProvider();
                if (!_logger.isLoggable(Level.FINE)) break block5;
                _logger.log(Level.FINE, "Error getting the EjbCacheProbeProvider");
            }
        }
    }

    public String getMonitorAttributeValues() {
        StringBuffer sbuf = new StringBuffer();
        sbuf.append(" { asyncTaskCount=").append(this.asyncTaskCount).append("; asyncCummTaskCount=").append(this.asyncCummTaskCount).append("; passivationBatchCount=").append(this.passivationBatchCount).append("; passivationQSz=").append(this.passivationCandidates.size()).append("; trimEventCount=").append(this.containerTrimCount).append(" }");
        return sbuf.toString();
    }

    @Override
    protected EjbMonitoringStatsProvider getMonitoringStatsProvider(String appName, String modName, String ejbName) {
        StatefulSessionBeanStatsProvider statsProvider = new StatefulSessionBeanStatsProvider(this, this.getContainerId(), appName, modName, ejbName);
        try {
            statsProvider.setPassiveCount(this.backingStore.size());
        }
        catch (BackingStoreException e) {
            _logger.log(Level.WARNING, ERROR_WHILE_BACKSTORE_SIZE_ACCESS, e);
        }
        return statsProvider;
    }

    private static final String convertCtxStateToString(SessionContextImpl sc) {
        switch (sc.getState()) {
            case PASSIVATED: {
                return "PASSIVE";
            }
            case READY: {
                return "READY";
            }
            case INVOKING: {
                return "INVOKING";
            }
            case INCOMPLETE_TX: {
                return "INCOMPLETE_TX";
            }
            case DESTROYED: {
                return "DESTROYED";
            }
        }
        return "UNKNOWN-STATE";
    }

    @Override
    protected boolean isIdentical(EJBObjectImpl ejbo, EJBObject other) throws RemoteException {
        if (other == ejbo.getStub()) {
            return true;
        }
        try {
            return this.getProtocolManager().isIdentical(ejbo.getStub(), (Remote)other);
        }
        catch (Exception ex) {
            _logger.log(Level.FINE, "Exception while getting stub for ejb", ex);
            throw new RemoteException("Error during isIdentical.", ex);
        }
    }

    @Override
    protected EJBObjectImpl createEJBObjectImpl() throws CreateException, RemoteException {
        try {
            SessionContextImpl context = this.createBeanInstance();
            EJBObjectImpl ejbObjImpl = this.createEJBObjectImpl(context);
            this.afterInstanceCreation(context);
            return ejbObjImpl;
        }
        catch (Exception ex) {
            _logger.log(Level.WARNING, CREATE_EJBOBJECT_EXCEPTION, new Object[]{this.ejbDescriptor.getName(), ex});
            if (ex instanceof EJBException) {
                throw (EJBException)((Object)ex);
            }
            CreateException ce = new CreateException("ERROR creating stateful SessionBean");
            ce.initCause((Throwable)ex);
            throw ce;
        }
    }

    @Override
    protected EJBObjectImpl createRemoteBusinessObjectImpl() throws CreateException, RemoteException {
        try {
            SessionContextImpl context = this.createBeanInstance();
            EJBObjectImpl ejbBusinessObjImpl = this.createRemoteBusinessObjectImpl(context);
            this.afterInstanceCreation(context);
            return ejbBusinessObjImpl;
        }
        catch (Exception ex) {
            _logger.log(Level.WARNING, CREATE_EJBOBJECT_EXCEPTION, new Object[]{this.ejbDescriptor.getName(), ex});
            if (ex instanceof EJBException) {
                throw (EJBException)((Object)ex);
            }
            CreateException ce = new CreateException("ERROR creating stateful SessionBean");
            ce.initCause((Throwable)ex);
            throw ce;
        }
    }

    @Override
    protected EJBLocalObjectImpl createEJBLocalObjectImpl() throws CreateException {
        try {
            SessionContextImpl context = this.createBeanInstance();
            EJBLocalObjectImpl localObjImpl = this.createEJBLocalObjectImpl(context);
            this.afterInstanceCreation(context);
            return localObjImpl;
        }
        catch (Exception ex) {
            _logger.log(Level.WARNING, CREATE_EJBLOCALOBJECT_EXCEPTION, new Object[]{this.ejbDescriptor.getName(), ex});
            if (ex instanceof EJBException) {
                throw (EJBException)((Object)ex);
            }
            CreateException ce = new CreateException("ERROR creating stateful SessionBean");
            ce.initCause((Throwable)ex);
            throw ce;
        }
    }

    @Override
    EJBLocalObjectImpl createEJBLocalBusinessObjectImpl(boolean localBeanView) throws CreateException {
        try {
            SessionContextImpl context = this.createBeanInstance();
            EJBLocalObjectImpl localBusinessObjImpl = localBeanView ? this.createOptionalEJBLocalBusinessObjectImpl(context) : this.createEJBLocalBusinessObjectImpl(context);
            this.afterInstanceCreation(context);
            return localBusinessObjImpl;
        }
        catch (Exception ex) {
            _logger.log(Level.WARNING, CREATE_EJBLOCALOBJECT_EXCEPTION, new Object[]{this.ejbDescriptor.getName(), ex});
            if (ex instanceof EJBException) {
                throw (EJBException)((Object)ex);
            }
            CreateException ce = new CreateException("ERROR creating stateful SessionBean");
            ce.initCause((Throwable)ex);
            throw ce;
        }
    }

    @Override
    protected EJBContextImpl _constructEJBContextImpl(Object instance) {
        return new SessionContextImpl(instance, this);
    }

    @Override
    protected Object _constructEJBInstance() throws Exception {
        return this.sfsbSerializedClass != null ? this.sfsbSerializedClass.newInstance() : this.ejbClass.newInstance();
    }

    @Override
    protected boolean suspendTransaction(EjbInvocation inv) throws Exception {
        SessionContextImpl sc = (SessionContextImpl)inv.context;
        return !inv.invocationInfo.isBusinessMethod && !sc.getInLifeCycleCallback();
    }

    @Override
    protected boolean resumeTransaction(EjbInvocation inv) throws Exception {
        SessionContextImpl sc = (SessionContextImpl)inv.context;
        return !inv.invocationInfo.isBusinessMethod && !sc.getInLifeCycleCallback();
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private SessionContextImpl createBeanInstance() throws Exception {
        SessionContextImpl sessionContextImpl;
        block8: {
            EjbInvocation ejbInv = null;
            try {
                SessionContextImpl context = (SessionContextImpl)this.createEjbInstanceAndContext();
                Object ejb = context.getEJB();
                Object sessionKey = this.uuidGenerator.createSessionKey();
                this.createExtendedEMs(context, sessionKey);
                ejbInv = super.createEjbInvocation(ejb, context);
                this.invocationManager.preInvoke((ComponentInvocation)ejbInv);
                if (ejb instanceof SessionBean) {
                    ((SessionBean)ejb).setSessionContext((SessionContext)context);
                }
                this.injectEjbInstance(context);
                context.touch();
                this.sessionBeanCache.put(sessionKey, context);
                context.setInstanceKey(sessionKey);
                if (_logger.isLoggable(this.TRACE_LEVEL)) {
                    _logger.log(this.TRACE_LEVEL, "[SFSBContainer] Created session: " + sessionKey);
                }
                sessionContextImpl = context;
                if (ejbInv == null) break block8;
            }
            catch (Exception ex) {
                try {
                    throw ex;
                    catch (Throwable t) {
                        EJBException ejbEx = new EJBException();
                        ejbEx.initCause(t);
                        throw ejbEx;
                    }
                }
                catch (Throwable throwable) {
                    if (ejbInv != null) {
                        this.invocationManager.postInvoke(ejbInv);
                    }
                    throw throwable;
                }
            }
            this.invocationManager.postInvoke((ComponentInvocation)ejbInv);
        }
        return sessionContextImpl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createExtendedEMs(SessionContextImpl ctx, Object sessionKey) {
        Set<EntityManagerReferenceDescriptor> emRefs = this.ejbDescriptor.getEntityManagerReferenceDescriptors();
        Iterator<EntityManagerReferenceDescriptor> iter = emRefs.iterator();
        HashSet<EEMRefInfo> eemRefInfos = new HashSet<EEMRefInfo>();
        while (iter.hasNext()) {
            EntityManagerReferenceDescriptor refDesc = iter.next();
            if (refDesc.getPersistenceContextType() != PersistenceContextType.EXTENDED) continue;
            String unitName = refDesc.getUnitName();
            EntityManagerFactory emf = EntityManagerFactoryWrapper.lookupEntityManagerFactory((ComponentInvocation.ComponentInvocationType)ComponentInvocation.ComponentInvocationType.EJB_INVOCATION, (String)unitName, (Object)((Object)this.ejbDescriptor));
            if (emf != null) {
                PhysicalEntityManagerWrapper physicalEntityManagerWrapper = this.findExtendedEMFromInvList(emf);
                if (physicalEntityManagerWrapper == null) {
                    try {
                        EntityManager em = emf.createEntityManager(refDesc.getSynchronizationType(), refDesc.getProperties());
                        physicalEntityManagerWrapper = new PhysicalEntityManagerWrapper(em, refDesc.getSynchronizationType());
                    }
                    catch (Throwable th) {
                        EJBException ejbEx = new EJBException("Couldn't create EntityManager for refName: " + refDesc.getName() + "; unitname: " + unitName);
                        ejbEx.initCause(th);
                        throw ejbEx;
                    }
                } else if (physicalEntityManagerWrapper.getSynchronizationType() != refDesc.getSynchronizationType()) {
                    throw new EJBException("The current invocation inherits a persistence context of synchronization type '" + physicalEntityManagerWrapper.getSynchronizationType() + "' where as it references a persistence context of synchronization type '" + refDesc.getSynchronizationType() + "' refName: " + refDesc.getName() + " unitName: " + unitName);
                }
                String emRefName = refDesc.getName();
                long containerID = this.getContainerId();
                EEMRefInfo refInfo = null;
                Map<EntityManager, EEMRefInfo> map = extendedEMReferenceCountMap;
                synchronized (map) {
                    refInfo = extendedEMReferenceCountMap.get(physicalEntityManagerWrapper.getEM());
                    if (refInfo != null) {
                        refInfo.refCount++;
                    } else {
                        refInfo = new EEMRefInfo(emRefName, refDesc.getUnitName(), refDesc.getSynchronizationType(), containerID, sessionKey, physicalEntityManagerWrapper.getEM(), emf);
                        refInfo.refCount = 1;
                        extendedEMReferenceCountMap.put(physicalEntityManagerWrapper.getEM(), refInfo);
                        eemKey2EEMMap.put(refInfo.getKey(), refInfo.getEntityManager());
                    }
                }
                ctx.addExtendedEntityManagerMapping(emf, refInfo);
                eemRefInfos.add(refInfo);
                continue;
            }
            throw new EJBException("EMF is null. Couldn't get extended EntityManager for refName: " + refDesc.getName() + "; unitname: " + unitName);
        }
        if (eemRefInfos.size() > 0) {
            ctx.setEEMRefInfos(eemRefInfos);
        }
    }

    private PhysicalEntityManagerWrapper findExtendedEMFromInvList(EntityManagerFactory emf) {
        PhysicalEntityManagerWrapper em = null;
        ComponentInvocation compInv = this.invocationManager.getCurrentInvocation();
        if (compInv != null && compInv.getInvocationType() == ComponentInvocation.ComponentInvocationType.EJB_INVOCATION) {
            EjbInvocation ejbInv = (EjbInvocation)compInv;
            if (ejbInv.context instanceof SessionContextImpl) {
                SessionContextImpl ctxImpl = (SessionContextImpl)ejbInv.context;
                if (ctxImpl.container instanceof StatefulSessionContainer) {
                    em = ctxImpl.getExtendedEntityManager(emf);
                }
            }
        }
        return em;
    }

    @Override
    public EntityManager lookupExtendedEntityManager(EntityManagerFactory emf) {
        PhysicalEntityManagerWrapper physicalEntityManagerWrapper = this.findExtendedEMFromInvList(emf);
        return physicalEntityManagerWrapper == null ? null : physicalEntityManagerWrapper.getEM();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void afterInstanceCreation(SessionContextImpl context) throws Exception {
        context.setState(EJBContextImpl.BeanState.READY);
        EjbInvocation ejbInv = null;
        boolean inTx = false;
        try {
            ejbInv = super.createEjbInvocation(context.getEJB(), context);
            this.invocationManager.preInvoke((ComponentInvocation)ejbInv);
            inTx = this.callLifecycleCallbackInTxIfUsed(ejbInv, context, this.postConstructInvInfo, LifecycleCallbackDescriptor.CallbackType.POST_CONSTRUCT);
        }
        catch (Throwable t) {
            EJBException ejbEx = new EJBException();
            ejbEx.initCause(t);
            throw ejbEx;
        }
        finally {
            block18: {
                if (ejbInv != null) {
                    try {
                        this.invocationManager.postInvoke((ComponentInvocation)ejbInv);
                        if (inTx) {
                            this.postInvokeTx(ejbInv);
                        }
                    }
                    catch (Exception pie) {
                        if (ejbInv.exception != null) {
                            _logger.log(Level.FINE, "Exception during SFSB startup postInvoke ", pie);
                            break block18;
                        }
                        ejbInv.exception = pie;
                        CreateException creEx = new CreateException("Initialization failed for Stateful Session Bean " + this.ejbDescriptor.getName());
                        creEx.initCause((Throwable)pie);
                        throw creEx;
                    }
                    finally {
                        context.setInLifeCycleCallback(false);
                    }
                }
            }
        }
        this.ejbProbeNotifier.ejbBeanCreatedEvent(this.getContainerId(), this.containerInfo.appName, this.containerInfo.modName, this.containerInfo.ejbName);
        this.incrementMethodReadyStat();
    }

    private EJBLocalObjectImpl createEJBLocalObjectImpl(SessionContextImpl context) throws Exception {
        if (context.getEJBLocalObjectImpl() != null) {
            return context.getEJBLocalObjectImpl();
        }
        EJBLocalObjectImpl localObjImpl = this.instantiateEJBLocalObjectImpl(context.getInstanceKey());
        context.setEJBLocalObjectImpl(localObjImpl);
        localObjImpl.setContext(context);
        if (this.hasLocalBusinessView) {
            this.createEJBLocalBusinessObjectImpl(context);
        }
        if (this.hasOptionalLocalBusinessView) {
            this.createOptionalEJBLocalBusinessObjectImpl(context);
        }
        if (this.hasRemoteHomeView) {
            this.createEJBObjectImpl(context);
        }
        if (this.hasRemoteBusinessView) {
            this.createRemoteBusinessObjectImpl(context);
        }
        return localObjImpl;
    }

    private EJBLocalObjectImpl createEJBLocalBusinessObjectImpl(SessionContextImpl context) throws Exception {
        if (context.getEJBLocalBusinessObjectImpl() != null) {
            return context.getEJBLocalBusinessObjectImpl();
        }
        EJBLocalObjectImpl localBusinessObjImpl = this.instantiateEJBLocalBusinessObjectImpl();
        context.setEJBLocalBusinessObjectImpl(localBusinessObjImpl);
        localBusinessObjImpl.setContext(context);
        localBusinessObjImpl.setKey(context.getInstanceKey());
        if (this.hasOptionalLocalBusinessView) {
            this.createOptionalEJBLocalBusinessObjectImpl(context);
        }
        if (this.hasLocalHomeView) {
            this.createEJBLocalObjectImpl(context);
        }
        if (this.hasRemoteHomeView) {
            this.createEJBObjectImpl(context);
        }
        if (this.hasRemoteBusinessView) {
            this.createRemoteBusinessObjectImpl(context);
        }
        return localBusinessObjImpl;
    }

    private EJBLocalObjectImpl createOptionalEJBLocalBusinessObjectImpl(SessionContextImpl context) throws Exception {
        if (context.getOptionalEJBLocalBusinessObjectImpl() != null) {
            return context.getOptionalEJBLocalBusinessObjectImpl();
        }
        EJBLocalObjectImpl optionalLocalBusinessObjImpl = this.instantiateOptionalEJBLocalBusinessObjectImpl();
        context.setOptionalEJBLocalBusinessObjectImpl(optionalLocalBusinessObjImpl);
        optionalLocalBusinessObjImpl.setContext(context);
        optionalLocalBusinessObjImpl.setKey(context.getInstanceKey());
        if (this.hasLocalBusinessView) {
            this.createEJBLocalBusinessObjectImpl(context);
        }
        if (this.hasLocalHomeView) {
            this.createEJBLocalObjectImpl(context);
        }
        if (this.hasRemoteHomeView) {
            this.createEJBObjectImpl(context);
        }
        if (this.hasRemoteBusinessView) {
            this.createRemoteBusinessObjectImpl(context);
        }
        return optionalLocalBusinessObjImpl;
    }

    private EJBObjectImpl createEJBObjectImpl(SessionContextImpl context) throws Exception {
        if (context.getEJBObjectImpl() != null) {
            return context.getEJBObjectImpl();
        }
        Object sessionKey = context.getInstanceKey();
        EJBObjectImpl ejbObjImpl = this.instantiateEJBObjectImpl(null, sessionKey);
        context.setEJBObjectImpl(ejbObjImpl);
        ejbObjImpl.setContext(context);
        byte[] sessionOID = this.uuidGenerator.keyToByteArray(sessionKey);
        EJBObject ejbStub = (EJBObject)this.remoteHomeRefFactory.createRemoteReference(sessionOID);
        context.setEJBStub(ejbStub);
        ejbObjImpl.setStub((Remote)ejbStub);
        if (this.hasRemoteBusinessView) {
            this.createRemoteBusinessObjectImpl(context);
        }
        if (this.isLocal) {
            if (this.hasLocalHomeView) {
                this.createEJBLocalObjectImpl(context);
            }
            if (this.hasLocalBusinessView) {
                this.createEJBLocalBusinessObjectImpl(context);
            }
            if (this.hasOptionalLocalBusinessView) {
                this.createOptionalEJBLocalBusinessObjectImpl(context);
            }
        }
        return ejbObjImpl;
    }

    private EJBObjectImpl createRemoteBusinessObjectImpl(SessionContextImpl context) throws Exception {
        if (context.getEJBRemoteBusinessObjectImpl() != null) {
            return context.getEJBRemoteBusinessObjectImpl();
        }
        EJBObjectImpl ejbBusinessObjImpl = this.instantiateRemoteBusinessObjectImpl();
        context.setEJBRemoteBusinessObjectImpl(ejbBusinessObjImpl);
        ejbBusinessObjImpl.setContext(context);
        Object sessionKey = context.getInstanceKey();
        ejbBusinessObjImpl.setKey(sessionKey);
        byte[] sessionOID = this.uuidGenerator.keyToByteArray(sessionKey);
        for (RemoteBusinessIntfInfo next : this.remoteBusinessIntfInfo.values()) {
            Remote stub = next.referenceFactory.createRemoteReference(sessionOID);
            ejbBusinessObjImpl.setStub(next.generatedRemoteIntf.getName(), stub);
        }
        if (this.hasRemoteHomeView) {
            this.createEJBObjectImpl(context);
        }
        if (this.isLocal) {
            if (this.hasLocalHomeView) {
                this.createEJBLocalObjectImpl(context);
            }
            if (this.hasLocalBusinessView) {
                this.createEJBLocalBusinessObjectImpl(context);
            }
            if (this.hasOptionalLocalBusinessView) {
                this.createOptionalEJBLocalBusinessObjectImpl(context);
            }
        }
        return ejbBusinessObjImpl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void removeBean(EJBLocalRemoteObject ejbo, Method removeMethod, boolean local) throws RemoveException, EJBException {
        EjbInvocation ejbInv = super.createEjbInvocation();
        ejbInv.ejbObject = ejbo;
        ejbInv.isLocal = local;
        ejbInv.isRemote = !local;
        ejbInv.method = removeMethod;
        Class<?> declaringClass = removeMethod.getDeclaringClass();
        ejbInv.isHome = declaringClass == EJBHome.class || declaringClass == EJBLocalHome.class;
        try {
            this.preInvoke(ejbInv);
            this.removeBean(ejbInv);
        }
        catch (Exception e) {
            _logger.log(Level.FINE, "Exception while running pre-invoke : ejbName = [{0}]", e);
            ejbInv.exception = e;
        }
        finally {
            this.postInvoke(ejbInv);
        }
        if (ejbInv.exception != null) {
            if (ejbInv.exception instanceof RemoveException) {
                throw (RemoveException)ejbInv.exception;
            }
            if (ejbInv.exception instanceof RuntimeException) {
                throw (RuntimeException)ejbInv.exception;
            }
            if (ejbInv.exception instanceof Exception) {
                throw new EJBException((Exception)ejbInv.exception);
            }
            EJBException ejbEx = new EJBException();
            ejbEx.initCause(ejbInv.exception);
            throw ejbEx;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeBean(EjbInvocation inv) throws RemoveException {
        try {
            this.ejbProbeNotifier.ejbBeanDestroyedEvent(this.getContainerId(), this.containerInfo.appName, this.containerInfo.modName, this.containerInfo.ejbName);
            SessionContextImpl sc = (SessionContextImpl)inv.context;
            Transaction tc = sc.getTransaction();
            if (tc != null && tc.getStatus() != 6) {
                throw new RemoveException("Cannot remove EJB: transaction in progress");
            }
            if (_logger.isLoggable(this.TRACE_LEVEL)) {
                _logger.log(this.TRACE_LEVEL, "[SFSBContainer] Removing session: " + sc.getInstanceKey());
            }
            sc.setInEjbRemove(true);
            try {
                this.destroyBean(inv, sc);
            }
            catch (Throwable t) {
                _logger.log(Level.FINE, "exception thrown from SFSB PRE_DESTROY", t);
            }
            finally {
                sc.setInEjbRemove(false);
            }
            this.forceDestroyBean(sc);
        }
        catch (EJBException ex) {
            _logger.log(Level.FINE, "EJBException in removing bean", ex);
            throw ex;
        }
        catch (RemoveException ex) {
            _logger.log(Level.FINE, "Remove exception while removing bean", ex);
            throw ex;
        }
        catch (Exception ex) {
            _logger.log(Level.FINE, "Some exception while removing bean", ex);
            throw new EJBException(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void forceDestroyBean(EJBContextImpl ctx) {
        SessionContextImpl sc;
        SessionContextImpl sessionContextImpl = sc = (SessionContextImpl)ctx;
        synchronized (sessionContextImpl) {
            if (sc.getState() == EJBContextImpl.BeanState.DESTROYED) {
                return;
            }
            sc.setState(EJBContextImpl.BeanState.DESTROYED);
            this.cleanupInstance(ctx);
            if (_logger.isLoggable(this.TRACE_LEVEL)) {
                _logger.log(this.TRACE_LEVEL, "[SFSBContainer] (Force)Destroying session: " + sc.getInstanceKey());
            }
            Transaction prevTx = sc.getTransaction();
            try {
                if (prevTx != null && prevTx.getStatus() != 6) {
                    prevTx.setRollbackOnly();
                }
            }
            catch (SystemException ex) {
                throw new EJBException((Exception)((Object)ex));
            }
            catch (IllegalStateException ex) {
                throw new EJBException((Exception)ex);
            }
            Object sessionKey = sc.getInstanceKey();
            this.sessionBeanCache.remove(sessionKey, sc.existsInStore());
            if (this.isRemote) {
                if (this.hasRemoteHomeView) {
                    EJBObjectImpl ejbObjImpl = sc.getEJBObjectImpl();
                    ejbObjImpl.clearContext();
                    ejbObjImpl.setRemoved(true);
                    sc.setEJBObjectImpl(null);
                    this.remoteHomeRefFactory.destroyReference(ejbObjImpl.getStub(), ejbObjImpl.getEJBObject());
                }
                if (this.hasRemoteBusinessView) {
                    EJBObjectImpl ejbBusinessObjImpl = sc.getEJBRemoteBusinessObjectImpl();
                    ejbBusinessObjImpl.clearContext();
                    ejbBusinessObjImpl.setRemoved(true);
                    sc.setEJBRemoteBusinessObjectImpl(null);
                    for (RemoteBusinessIntfInfo next : this.remoteBusinessIntfInfo.values()) {
                        next.referenceFactory.destroyReference(ejbBusinessObjImpl.getStub(next.generatedRemoteIntf.getName()), ejbBusinessObjImpl.getEJBObject(next.generatedRemoteIntf.getName()));
                    }
                }
            }
            if (this.isLocal) {
                if (this.hasLocalHomeView) {
                    EJBLocalObjectImpl localObjImpl = sc.getEJBLocalObjectImpl();
                    localObjImpl.clearContext();
                    localObjImpl.setRemoved(true);
                    sc.setEJBLocalObjectImpl(null);
                }
                if (this.hasLocalBusinessView) {
                    EJBLocalObjectImpl localBusinessObjImpl = sc.getEJBLocalBusinessObjectImpl();
                    localBusinessObjImpl.clearContext();
                    localBusinessObjImpl.setRemoved(true);
                    sc.setEJBLocalBusinessObjectImpl(null);
                }
                if (this.hasOptionalLocalBusinessView) {
                    EJBLocalObjectImpl optionalLocalBusinessObjImpl = sc.getOptionalEJBLocalBusinessObjectImpl();
                    optionalLocalBusinessObjImpl.clearContext();
                    optionalLocalBusinessObjImpl.setRemoved(true);
                    sc.setOptionalEJBLocalBusinessObjectImpl(null);
                }
            }
            this.destroyExtendedEMsForContext(sc);
            this.transactionManager.componentDestroyed((ResourceHandler)sc);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void destroyExtendedEMsForContext(SessionContextImpl sc) {
        for (PhysicalEntityManagerWrapper emWrapper : sc.getExtendedEntityManagers()) {
            Map<EntityManager, EEMRefInfo> map = extendedEMReferenceCountMap;
            synchronized (map) {
                EntityManager em = emWrapper.getEM();
                if (extendedEMReferenceCountMap.containsKey(em)) {
                    EEMRefInfo refInfo = extendedEMReferenceCountMap.get(em);
                    if (refInfo.refCount > 1) {
                        refInfo.refCount--;
                        _logger.log(Level.FINE, "Decremented RefCount ExtendedEM em: " + em);
                    } else {
                        _logger.log(Level.FINE, "DESTROYED ExtendedEM em: " + em);
                        refInfo = extendedEMReferenceCountMap.remove(em);
                        eemKey2EEMMap.remove(refInfo.getKey());
                        try {
                            em.close();
                        }
                        catch (Throwable th) {
                            _logger.log(Level.FINE, "Exception during em.close()", th);
                        }
                    }
                }
            }
        }
    }

    @Override
    public boolean userTransactionMethodsAllowed(ComponentInvocation inv) {
        boolean utMethodsAllowed = false;
        if (this.isBeanManagedTran) {
            SessionContextImpl sc;
            utMethodsAllowed = inv instanceof EjbInvocation ? (sc = (SessionContextImpl)((EjbInvocation)inv).context).getInstanceKey() != null : true;
        }
        return utMethodsAllowed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeTimedoutBean(EJBContextImpl ctx) {
        EJBContextImpl eJBContextImpl = ctx;
        synchronized (eJBContextImpl) {
            if (ctx.getState() != EJBContextImpl.BeanState.INVOKING) {
                try {
                    ctx.setInEjbRemove(true);
                    this.destroyBean(null, ctx);
                }
                catch (Throwable t) {
                    _logger.log(Level.FINE, "ejbRemove exception", t);
                }
                finally {
                    ctx.setInEjbRemove(false);
                }
                if (_logger.isLoggable(this.TRACE_LEVEL)) {
                    SessionContextImpl sc = (SessionContextImpl)ctx;
                    _logger.log(this.TRACE_LEVEL, "[SFSBContainer] Removing TIMEDOUT session: " + sc.getInstanceKey());
                }
                this.forceDestroyBean(ctx);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SessionContextImpl _getContextForInstance(byte[] instanceKey) {
        Serializable sessionKey = (Serializable)this.uuidGenerator.byteArrayToKey(instanceKey, 0, -1);
        if (_logger.isLoggable(this.TRACE_LEVEL)) {
            _logger.log(this.TRACE_LEVEL, "[SFSBContainer] Got request for: " + sessionKey);
        }
        while (true) {
            SessionContextImpl sc;
            if ((sc = (SessionContextImpl)this.sessionBeanCache.lookupEJB(sessionKey, this, null)) == null) {
                throw new NoSuchObjectLocalException("Invalid Session Key ( " + sessionKey + ")");
            }
            SessionContextImpl sessionContextImpl = sc;
            synchronized (sessionContextImpl) {
                switch (sc.getState()) {
                    case PASSIVATED: 
                    case DESTROYED: {
                        break;
                    }
                    default: {
                        return sc;
                    }
                }
            }
        }
    }

    @Override
    protected EJBObjectImpl getEJBObjectImpl(byte[] instanceKey) {
        SessionContextImpl sc = this._getContextForInstance(instanceKey);
        return sc.getEJBObjectImpl();
    }

    @Override
    EJBObjectImpl getEJBRemoteBusinessObjectImpl(byte[] instanceKey) {
        SessionContextImpl sc = this._getContextForInstance(instanceKey);
        return sc.getEJBRemoteBusinessObjectImpl();
    }

    @Override
    protected EJBLocalObjectImpl getEJBLocalObjectImpl(Object sessionKey) {
        EJBLocalObjectImpl localObjImpl;
        try {
            localObjImpl = this.instantiateEJBLocalObjectImpl(sessionKey);
        }
        catch (Exception ex) {
            EJBException ejbEx = new EJBException();
            ejbEx.initCause((Throwable)ex);
            throw ejbEx;
        }
        return localObjImpl;
    }

    @Override
    EJBLocalObjectImpl getEJBLocalBusinessObjectImpl(Object sessionKey) {
        EJBLocalObjectImpl localBusinessObjImpl;
        try {
            localBusinessObjImpl = this.instantiateEJBLocalBusinessObjectImpl();
            localBusinessObjImpl.setKey(sessionKey);
        }
        catch (Exception ex) {
            EJBException ejbEx = new EJBException();
            ejbEx.initCause((Throwable)ex);
            throw ejbEx;
        }
        return localBusinessObjImpl;
    }

    @Override
    EJBLocalObjectImpl getOptionalEJBLocalBusinessObjectImpl(Object sessionKey) {
        EJBLocalObjectImpl localBusinessObjImpl;
        try {
            localBusinessObjImpl = this.instantiateOptionalEJBLocalBusinessObjectImpl();
            localBusinessObjImpl.setKey(sessionKey);
        }
        catch (Exception ex) {
            EJBException ejbEx = new EJBException();
            ejbEx.initCause((Throwable)ex);
            throw ejbEx;
        }
        return localBusinessObjImpl;
    }

    @Override
    protected void checkExists(EJBLocalRemoteObject ejbObj) {
        if (ejbObj.isRemoved()) {
            throw new NoSuchObjectLocalException("Bean has been removed");
        }
    }

    private final void logTraceInfo(EjbInvocation inv, Object key, String message) {
        _logger.log(this.TRACE_LEVEL, this.traceInfoPrefix + message + " for " + inv.method.getName() + "; key: " + key);
    }

    private final void logTraceInfo(SessionContextImpl sc, String message) {
        _logger.log(this.TRACE_LEVEL, this.traceInfoPrefix + message + " for key: " + sc.getInstanceKey() + "; " + System.identityHashCode(sc));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ComponentContext _getContext(EjbInvocation inv) {
        boolean allowSerializedAccess;
        EJBLocalRemoteObject ejbo = inv.ejbObject;
        SessionContextImpl sc = ejbo.getContext();
        Serializable sessionKey = (Serializable)ejbo.getKey();
        if (_logger.isLoggable(this.TRACE_LEVEL)) {
            this.logTraceInfo(inv, sessionKey, "Trying to get context");
        }
        if (sc == null) {
            sc = (SessionContextImpl)this.sessionBeanCache.lookupEJB(sessionKey, this, ejbo);
        }
        if (sc == null || sc.getState() == EJBContextImpl.BeanState.DESTROYED) {
            if (_logger.isLoggable(this.TRACE_LEVEL)) {
                this.logTraceInfo(inv, sessionKey, "Context already destroyed");
            }
            throw new NoSuchObjectLocalException("The EJB does not exist. session-key: " + sessionKey);
        }
        MethodLockInfo lockInfo = inv.invocationInfo.methodLockInfo;
        boolean bl = allowSerializedAccess = lockInfo == null || lockInfo.getTimeout() != 0L;
        if (allowSerializedAccess) {
            block30: {
                boolean blockWithTimeout;
                boolean bl2 = blockWithTimeout = lockInfo != null && lockInfo.getTimeout() != -1L;
                if (blockWithTimeout) {
                    try {
                        boolean acquired = sc.getStatefulWriteLock().tryLock(lockInfo.getTimeout(), lockInfo.getTimeUnit());
                        if (!acquired) {
                            String msg = "Serialized access attempt on method " + inv.beanMethod + " for ejb " + this.ejbDescriptor.getName() + " timed out after " + lockInfo.getTimeout() + " " + (Object)((Object)lockInfo.getTimeUnit());
                            throw new ConcurrentAccessTimeoutException(msg);
                        }
                        break block30;
                    }
                    catch (InterruptedException ie) {
                        String msg = "Serialized access attempt on method " + inv.beanMethod + " for ejb " + this.ejbDescriptor.getName() + " was interrupted within " + lockInfo.getTimeout() + " " + (Object)((Object)lockInfo.getTimeUnit());
                        ConcurrentAccessTimeoutException cae = new ConcurrentAccessTimeoutException(msg);
                        cae.initCause((Throwable)ie);
                        throw cae;
                    }
                }
                sc.getStatefulWriteLock().lock();
            }
            inv.setHoldingSFSBSerializedLock(true);
        }
        SessionContextImpl context = null;
        try {
            SessionContextImpl ie = sc;
            synchronized (ie) {
                SessionContextImpl newSC = sc;
                if (sc.getState() == EJBContextImpl.BeanState.PASSIVATED) {
                    newSC = (SessionContextImpl)this.sessionBeanCache.lookupEJB(sessionKey, this, ejbo);
                    if (newSC == null) {
                        if (_logger.isLoggable(this.TRACE_LEVEL)) {
                            this.logTraceInfo(inv, sessionKey, "Context does not exist");
                        }
                        throw new NoSuchObjectLocalException("The EJB does not exist. key: " + sessionKey);
                    }
                    newSC.setStatefulWriteLock(sc);
                }
                SessionContextImpl cae = newSC;
                synchronized (cae) {
                    if (newSC.getState() == EJBContextImpl.BeanState.DESTROYED) {
                        if (_logger.isLoggable(this.TRACE_LEVEL)) {
                            this.logTraceInfo(inv, sessionKey, "Got destroyed context");
                        }
                        throw new NoSuchObjectLocalException("The EJB does not exist. session-key: " + sessionKey);
                    }
                    if (newSC.getState() == EJBContextImpl.BeanState.INVOKING) {
                        this.handleConcurrentInvocation(allowSerializedAccess, inv, newSC, sessionKey);
                    }
                    if (newSC.getState() == EJBContextImpl.BeanState.READY) {
                        this.decrementMethodReadyStat();
                    }
                    if (this.isHAEnabled) {
                        this.doVersionCheck(inv, sessionKey, sc);
                    }
                    newSC.setState(EJBContextImpl.BeanState.INVOKING);
                    context = newSC;
                }
            }
            context.touch();
            if (context.existsInStore() && this.removalGracePeriodInSeconds > 0) {
                long now = System.currentTimeMillis();
                long threshold = now - (long)this.removalGracePeriodInSeconds * 1000L;
                if (context.getLastPersistedAt() <= threshold) {
                    try {
                        this.backingStore.updateTimestamp(sessionKey, now);
                        context.setLastPersistedAt(System.currentTimeMillis());
                    }
                    catch (BackingStoreException sfsbEx) {
                        _logger.log(Level.WARNING, COULDNT_UPDATE_TIMESTAMP_FOR_EXCEPTION, new Object[]{sessionKey, sfsbEx});
                        _logger.log(Level.FINE, "Couldn't update timestamp for: " + sessionKey, sfsbEx);
                    }
                }
            }
            if (_logger.isLoggable(this.TRACE_LEVEL)) {
                this.logTraceInfo(inv, context, "Got Context!!");
            }
        }
        catch (RuntimeException t) {
            this.releaseSFSBSerializedLock(inv, sc);
            throw t;
        }
        return context;
    }

    @Override
    public boolean isHAEnabled() {
        return this.isHAEnabled;
    }

    private void doVersionCheck(EjbInvocation inv, Object sessionKey, SessionContextImpl sc) {
        EJBLocalRemoteObject ejbLRO = inv.ejbObject;
        long clientVersion = -404L;
        if (!inv.isLocal && this.sfsbVersionManager != null) {
            clientVersion = this.sfsbVersionManager.getRequestClientVersion();
            this.sfsbVersionManager.clearRequestClientVersion();
            this.sfsbVersionManager.clearResponseClientVersion();
        }
        if (ejbLRO != null) {
            if (clientVersion == -404L) {
                clientVersion = ejbLRO.getSfsbClientVersion();
            }
            long ctxVersion = sc.getVersion();
            if (_logger.isLoggable(this.TRACE_LEVEL)) {
                _logger.log(this.TRACE_LEVEL, "doVersionCheck(): for: {" + this.ejbDescriptor.getName() + "." + inv.method.getName() + " <=> " + sessionKey + "} clientVersion: " + clientVersion + " == " + ctxVersion);
            }
            if (clientVersion > ctxVersion) {
                throw new NoSuchObjectLocalException("Found only a stale version  clientVersion: " + clientVersion + " contextVersion: " + ctxVersion);
            }
        }
    }

    private void handleConcurrentInvocation(boolean allowSerializedAccess, EjbInvocation inv, SessionContextImpl sc, Object sessionKey) {
        if (_logger.isLoggable(this.TRACE_LEVEL)) {
            this.logTraceInfo(inv, sessionKey, "Another invocation in progress");
        }
        if (allowSerializedAccess) {
            if (sc.getStatefulWriteLock().getHoldCount() > 1) {
                throw new IllegalLoopbackException("Illegal Reentrant Access : Attempt to make a loopback call on method '" + inv.beanMethod + " for stateful session bean " + this.ejbDescriptor.getName());
            }
        } else {
            String errMsg = "Concurrent Access attempt on method " + inv.beanMethod + " of SessionBean " + this.ejbDescriptor.getName() + " is prohibited.  SFSB instance is executing another request. [session-key: " + sessionKey + "]";
            ConcurrentAccessException conEx = new ConcurrentAccessException(errMsg);
            if (inv.isBusinessInterface) {
                throw conEx;
            }
            throw new EJBException((Exception)conEx);
        }
    }

    @Override
    protected void postInvokeTx(EjbInvocation inv) throws Exception {
        if (inv.invocationInfo.removalInfo != null) {
            SessionContextImpl sc;
            Transaction tx;
            InvocationInfo invInfo = inv.invocationInfo;
            EjbRemovalInfo removeInfo = invInfo.removalInfo;
            if (!this.retainAfterRemoveMethod(inv, removeInfo) && (tx = (sc = (SessionContextImpl)inv.context).getTransaction()) != null) {
                ContainerSynchronization sync = this.ejbContainerUtilImpl.getContainerSync(tx);
                sync.removeBean(sc);
            }
        }
        super.postInvokeTx(inv);
    }

    private boolean retainAfterRemoveMethod(EjbInvocation inv, EjbRemovalInfo rInfo) {
        boolean retain = rInfo.getRetainIfException() && inv.exceptionFromBeanMethod != null && this.isApplicationException(inv.exceptionFromBeanMethod);
        return retain;
    }

    @Override
    public void releaseContext(EjbInvocation inv) {
        SessionContextImpl sc = (SessionContextImpl)inv.context;
        try {
            if (sc.getState() == EJBContextImpl.BeanState.DESTROYED) {
                return;
            }
            Transaction tx = sc.getTransaction();
            if (inv.invocationInfo.removalInfo != null) {
                InvocationInfo invInfo = inv.invocationInfo;
                EjbRemovalInfo removeInfo = invInfo.removalInfo;
                if (this.retainAfterRemoveMethod(inv, removeInfo)) {
                    _logger.log(Level.FINE, "Skipping destruction of SFSB " + invInfo.ejbName + " after @Remove method " + invInfo.method + " due to (retainIfException == true) and exception " + inv.exception);
                } else {
                    try {
                        this.destroyBean(inv, sc);
                    }
                    catch (Throwable t) {
                        _logger.log(Level.FINE, "@Remove.preDestroy exception", t);
                    }
                    sc.setTransaction(null);
                    this.forceDestroyBean(sc);
                    return;
                }
            }
            if (tx == null || tx.getStatus() == 6) {
                if (sc.getState() != EJBContextImpl.BeanState.READY) {
                    if (sc.isAfterCompletionDelayed()) {
                        if (_logger.isLoggable(this.TRACE_LEVEL)) {
                            this.logTraceInfo(inv, sc, "Calling delayed afterCompletion");
                        }
                        this.callEjbAfterCompletion(sc, sc.getCompletedTxStatus());
                    }
                    if (sc.getState() != EJBContextImpl.BeanState.DESTROYED) {
                        sc.setState(EJBContextImpl.BeanState.READY);
                        this.handleEndOfMethodCheckpoint(sc, inv);
                    }
                }
                if (sc.getState() != EJBContextImpl.BeanState.DESTROYED && this.isHAEnabled) {
                    this.syncClientVersion(inv, sc);
                }
            } else {
                if (sc.getState() != EJBContextImpl.BeanState.DESTROYED && this.isHAEnabled) {
                    this.syncClientVersion(inv, sc);
                }
                sc.setState(EJBContextImpl.BeanState.INCOMPLETE_TX);
                if (_logger.isLoggable(this.TRACE_LEVEL)) {
                    this.logTraceInfo(inv, sc, "Marking state == INCOMPLETE_TX");
                }
            }
        }
        catch (SystemException ex) {
            throw new EJBException((Exception)((Object)ex));
        }
        finally {
            this.releaseSFSBSerializedLock(inv, sc);
        }
    }

    private void releaseSFSBSerializedLock(EjbInvocation inv, SessionContextImpl sc) {
        if (inv.holdingSFSBSerializedLock()) {
            inv.setHoldingSFSBSerializedLock(false);
            sc.getStatefulWriteLock().unlock();
        }
    }

    @Override
    protected void afterBegin(EJBContextImpl context) {
        if (this.isBeanManagedTran || ((SessionContextImpl)context).getInLifeCycleCallback()) {
            return;
        }
        Object ejb = context.getEJB();
        if (this.afterBeginMethod != null) {
            try {
                this.afterBeginMethod.invoke(ejb, null);
            }
            catch (Exception ex) {
                this.forceDestroyBean(context);
                throw new EJBException("Error during SessionSynchronization..afterBegin(), EJB instance discarded", ex);
            }
        }
        if (this.isHAEnabled) {
            ContainerSynchronization cSync = null;
            try {
                cSync = this.ejbContainerUtilImpl.getContainerSync(context.getTransaction());
                cSync.registerForTxCheckpoint((SessionContextImpl)context);
            }
            catch (RollbackException rollEx) {
                _logger.log(Level.WARNING, CANNOT_REGISTER_BEAN_FOR_CHECKPOINTING, rollEx);
            }
            catch (SystemException sysEx) {
                _logger.log(Level.WARNING, CANNOT_REGISTER_BEAN_FOR_CHECKPOINTING, sysEx);
            }
        }
    }

    @Override
    protected void beforeCompletion(EJBContextImpl context) {
        if (this.isBeanManagedTran || this.beforeCompletionMethod == null || ((SessionContextImpl)context).getInLifeCycleCallback()) {
            return;
        }
        Object ejb = context.getEJB();
        EjbInvocation inv = super.createEjbInvocation(ejb, context);
        this.invocationManager.preInvoke((ComponentInvocation)inv);
        try {
            this.transactionManager.enlistComponentResources();
            this.beforeCompletionMethod.invoke(ejb, null);
        }
        catch (Exception ex) {
            try {
                this.forceDestroyBean(context);
            }
            catch (Exception e) {
                _logger.log(Level.FINE, "error destroying bean", e);
            }
            throw new EJBException("Error during SessionSynchronization.beforeCompletion, EJB instance discarded", ex);
        }
        finally {
            this.invocationManager.postInvoke((ComponentInvocation)inv);
        }
    }

    @Override
    protected void afterCompletion(EJBContextImpl context, int status) {
        if (context.getState() == EJBContextImpl.BeanState.DESTROYED) {
            return;
        }
        SessionContextImpl sc = (SessionContextImpl)context;
        boolean committed = status == 3 || status == 6;
        sc.setTransaction(null);
        if (sc.getInLifeCycleCallback()) {
            return;
        }
        if (!this.isBeanManagedTran && this.afterCompletionMethod != null) {
            if (sc.getState() == EJBContextImpl.BeanState.INVOKING && !sc.isTxCompleting()) {
                sc.setAfterCompletionDelayed(true);
                sc.setCompletedTxStatus(committed);
                if (_logger.isLoggable(this.TRACE_LEVEL)) {
                    this.logTraceInfo(sc, "AfterCompletion delayed");
                }
                return;
            }
            this.callEjbAfterCompletion(sc, committed);
        }
        if (sc.getState() != EJBContextImpl.BeanState.DESTROYED) {
            if (this.isHAEnabled) {
                if (this.isBeanManagedTran) {
                    sc.setTxCheckpointDelayed(true);
                    if (_logger.isLoggable(this.TRACE_LEVEL)) {
                        this.logTraceInfo(sc, "(BMT)Checkpoint delayed");
                    }
                }
            } else if (!this.isBeanManagedTran) {
                if (_logger.isLoggable(this.TRACE_LEVEL)) {
                    this.logTraceInfo(sc, "Released context");
                }
                sc.setState(EJBContextImpl.BeanState.READY);
                this.incrementMethodReadyStat();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    SimpleMetadata getSFSBBeanState(SessionContextImpl sc) {
        SimpleMetadata simpleMetadata = null;
        try {
            if (this.containerState != 0 && this.containerState != 1) {
                _logger.log(Level.FINE, "getSFSBBeanState() returning because containerState: " + this.containerState);
                return null;
            }
            if (sc.getState() == EJBContextImpl.BeanState.DESTROYED) {
                return null;
            }
            Object ejb = sc.getEJB();
            EjbInvocation ejbInv = this.createEjbInvocation(ejb, sc);
            this.invocationManager.preInvoke((ComponentInvocation)ejbInv);
            boolean needToDoPostInvokeTx = false;
            boolean destroyBean = false;
            SessionContextImpl sessionContextImpl = sc;
            synchronized (sessionContextImpl) {
                try {
                    needToDoPostInvokeTx = this.callLifecycleCallbackInTxIfUsed(ejbInv, sc, this.prePassivateInvInfo, LifecycleCallbackDescriptor.CallbackType.PRE_PASSIVATE);
                    sc.setLastPersistedAt(System.currentTimeMillis());
                    long newCtxVersion = sc.incrementAndGetVersion();
                    byte[] serializedState = this.serializeContext(sc);
                    simpleMetadata = new SimpleMetadata(sc.getVersion(), System.currentTimeMillis(), (long)this.removalGracePeriodInSeconds * 1000L, serializedState);
                    simpleMetadata.setVersion(newCtxVersion);
                    needToDoPostInvokeTx = this.callLifecycleCallbackInTxIfUsed(ejbInv, sc, this.postActivateInvInfo, LifecycleCallbackDescriptor.CallbackType.POST_ACTIVATE);
                }
                catch (NotSerializableException serEx) {
                    _logger.log(Level.WARNING, ERROR_DURING_CHECKPOINT_3PARAMs, new Object[]{this.ejbDescriptor.getName(), sc.getInstanceKey(), serEx});
                    _logger.log(Level.FINE, "sfsb checkpoint error. Key: " + sc.getInstanceKey(), serEx);
                    destroyBean = true;
                }
                catch (Throwable ex) {
                    _logger.log(Level.WARNING, SFSB_CHECKPOINT_ERROR_NAME, new Object[]{this.ejbDescriptor.getName()});
                    _logger.log(Level.WARNING, SFSB_CHECKPOINT_ERROR_KEY, new Object[]{sc.getInstanceKey(), ex});
                    destroyBean = true;
                }
                finally {
                    this.invocationManager.postInvoke((ComponentInvocation)ejbInv);
                    this.completeLifecycleCallbackTxIfUsed(ejbInv, sc, needToDoPostInvokeTx);
                    if (destroyBean) {
                        try {
                            this.forceDestroyBean(sc);
                        }
                        catch (Exception e) {
                            _logger.log(Level.FINE, "error destroying bean", e);
                        }
                    }
                }
            }
        }
        catch (Throwable th) {
            _logger.log(Level.WARNING, SFSB_CHECKPOINT_ERROR_NAME, new Object[]{this.ejbDescriptor.getName(), th});
        }
        return simpleMetadata;
    }

    void txCheckpointCompleted(SessionContextImpl sc) {
        if (sc.getState() != EJBContextImpl.BeanState.DESTROYED) {
            sc.setExistsInStore(true);
            sc.setState(EJBContextImpl.BeanState.READY);
            this.incrementMethodReadyStat();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void callEjbAfterCompletion(SessionContextImpl context, boolean status) {
        if (this.afterCompletionMethod != null) {
            Object ejb = context.getEJB();
            EjbInvocation ejbInv = this.createEjbInvocation(ejb, context);
            this.invocationManager.preInvoke((ComponentInvocation)ejbInv);
            try {
                context.setInAfterCompletion(true);
                this.afterCompletionMethod.invoke(ejb, status);
                context.setAfterCompletionDelayed(false);
                context.setTxCompleting(false);
            }
            catch (Exception ex) {
                Throwable realException = ex;
                if (ex instanceof InvocationTargetException) {
                    realException = ((InvocationTargetException)ex).getTargetException();
                }
                try {
                    this.forceDestroyBean(context);
                }
                catch (Exception e) {
                    _logger.log(Level.FINE, "error destroying bean", e);
                }
                _logger.log(Level.INFO, AFTER_COMPLETION_EXCEPTION, realException);
            }
            finally {
                context.setInAfterCompletion(false);
                this.invocationManager.postInvoke((ComponentInvocation)ejbInv);
            }
        }
    }

    public final boolean canPassivateEJB(ComponentContext context) {
        SessionContextImpl sc = (SessionContextImpl)context;
        return sc.getState() == EJBContextImpl.BeanState.READY;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public final boolean passivateEJB(ComponentContext context) {
        SessionContextImpl sc = (SessionContextImpl)context;
        boolean success = false;
        try {
            if (!this.ejbDescriptor.getApplication().getKeepStateResolved() && this.containerState != 0 && this.containerState != 1) {
                _logger.log(Level.WARNING, PASSIVATE_EJB_RETURNING_BECAUSE_CONTAINER_STATE, this.containerState);
                return false;
            }
            if (sc.getState() == EJBContextImpl.BeanState.DESTROYED) {
                return false;
            }
            if (_logger.isLoggable(this.TRACE_LEVEL)) {
                _logger.log(this.TRACE_LEVEL, this.traceInfoPrefix + "Passivating context " + sc.getInstanceKey() + "; current-state = " + StatefulSessionContainer.convertCtxStateToString(sc));
            }
            Object ejb = sc.getEJB();
            long passStartTime = -1L;
            EjbInvocation ejbInv = this.createEjbInvocation(ejb, sc);
            this.invocationManager.preInvoke((ComponentInvocation)ejbInv);
            boolean failed = false;
            success = false;
            boolean needToDoPostInvokeTx = false;
            boolean destroyBean = false;
            SessionContextImpl sessionContextImpl = sc;
            synchronized (sessionContextImpl) {
                try {
                    if (!sc.canBePassivated()) {
                        boolean bl = false;
                        return bl;
                    }
                    Serializable instanceKey = (Serializable)sc.getInstanceKey();
                    if (this.sessionBeanCache.eligibleForRemovalFromCache(sc, instanceKey)) {
                        sc.setState(EJBContextImpl.BeanState.DESTROYED);
                        needToDoPostInvokeTx = this.callLifecycleCallbackInTxIfUsed(ejbInv, sc, this.preDestroyInvInfo, LifecycleCallbackDescriptor.CallbackType.PRE_DESTROY);
                        this.sessionBeanCache.remove(instanceKey, sc.existsInStore());
                    } else {
                        sc.setState(EJBContextImpl.BeanState.PASSIVATED);
                        this.decrementMethodReadyStat();
                        needToDoPostInvokeTx = this.callLifecycleCallbackInTxIfUsed(ejbInv, sc, this.prePassivateInvInfo, LifecycleCallbackDescriptor.CallbackType.PRE_PASSIVATE);
                        sc.setLastPersistedAt(System.currentTimeMillis());
                        boolean saved = false;
                        try {
                            saved = this.sessionBeanCache.passivateEJB(sc, instanceKey);
                        }
                        catch (EMNotSerializableException emNotSerEx) {
                            _logger.log(Level.WARNING, EXTENDED_EM_NOT_SERIALIZABLE, emNotSerEx);
                            _logger.log(Level.FINE, "Extended EM not serializable", emNotSerEx);
                            saved = false;
                        }
                        if (!saved) {
                            this.completeLifecycleCallbackTxIfUsed(ejbInv, sc, needToDoPostInvokeTx);
                            needToDoPostInvokeTx = this.callLifecycleCallbackInTxIfUsed(ejbInv, sc, this.postActivateInvInfo, LifecycleCallbackDescriptor.CallbackType.POST_ACTIVATE);
                            sc.setState(EJBContextImpl.BeanState.READY);
                            this.incrementMethodReadyStat();
                            boolean bl = false;
                            return bl;
                        }
                    }
                    this.cacheProbeNotifier.ejbBeanPassivatedEvent(this.getContainerId(), this.containerInfo.appName, this.containerInfo.modName, this.containerInfo.ejbName, true);
                    this.transactionManager.componentDestroyed((ResourceHandler)sc);
                    this.decrementRefCountsForEEMs(sc);
                    if (this.isRemote) {
                        if (this.hasRemoteHomeView) {
                            EJBObjectImpl ejbObjImpl = sc.getEJBObjectImpl();
                            ejbObjImpl.clearContext();
                            sc.setEJBObjectImpl(null);
                            this.remoteHomeRefFactory.destroyReference(ejbObjImpl.getStub(), ejbObjImpl.getEJBObject());
                        }
                        if (this.hasRemoteBusinessView) {
                            EJBObjectImpl ejbBusinessObjImpl = sc.getEJBRemoteBusinessObjectImpl();
                            ejbBusinessObjImpl.clearContext();
                            sc.setEJBRemoteBusinessObjectImpl(null);
                            for (RemoteBusinessIntfInfo next : this.remoteBusinessIntfInfo.values()) {
                                next.referenceFactory.destroyReference(ejbBusinessObjImpl.getStub(), ejbBusinessObjImpl.getEJBObject(next.generatedRemoteIntf.getName()));
                            }
                        }
                    }
                    if (this.isLocal) {
                        long version = sc.getVersion();
                        if (this.hasLocalHomeView) {
                            EJBLocalObjectImpl localObjImpl = sc.getEJBLocalObjectImpl();
                            localObjImpl.setSfsbClientVersion(version);
                            localObjImpl.clearContext();
                            sc.setEJBLocalObjectImpl(null);
                        }
                        if (this.hasLocalBusinessView) {
                            EJBLocalObjectImpl localBusinessObjImpl = sc.getEJBLocalBusinessObjectImpl();
                            localBusinessObjImpl.setSfsbClientVersion(version);
                            localBusinessObjImpl.clearContext();
                            sc.setEJBLocalBusinessObjectImpl(null);
                        }
                        if (this.hasOptionalLocalBusinessView) {
                            EJBLocalObjectImpl optLocalBusObjImpl = sc.getOptionalEJBLocalBusinessObjectImpl();
                            optLocalBusObjImpl.setSfsbClientVersion(version);
                            optLocalBusObjImpl.clearContext();
                            sc.setOptionalEJBLocalBusinessObjectImpl(null);
                        }
                    }
                    if (!_logger.isLoggable(this.TRACE_LEVEL)) return success;
                    this.logTraceInfo(sc, "Successfully passivated");
                }
                catch (NotSerializableException nsEx) {
                    this.cacheProbeNotifier.ejbBeanPassivatedEvent(this.getContainerId(), this.containerInfo.appName, this.containerInfo.modName, this.containerInfo.ejbName, false);
                    _logger.log(Level.WARNING, ERROR_DURING_PASSIVATION, new Object[]{sc, nsEx});
                    _logger.log(Level.FINE, "sfsb passivation error", nsEx);
                    destroyBean = true;
                }
                catch (Throwable ex) {
                    this.cacheProbeNotifier.ejbBeanPassivatedEvent(this.getContainerId(), this.containerInfo.appName, this.containerInfo.modName, this.containerInfo.ejbName, false);
                    _logger.log(Level.WARNING, PASSIVATION_ERROR_1PARAM, new Object[]{this.ejbDescriptor.getName() + " <==> " + sc});
                    _logger.log(Level.WARNING, SFSB_PASSIVATION_ERROR_1PARAM, new Object[]{sc.getInstanceKey(), ex});
                    destroyBean = true;
                }
                finally {
                    this.invocationManager.postInvoke((ComponentInvocation)ejbInv);
                    this.completeLifecycleCallbackTxIfUsed(ejbInv, sc, needToDoPostInvokeTx);
                    if (destroyBean) {
                        try {
                            this.forceDestroyBean(sc);
                        }
                        catch (Exception e) {
                            _logger.log(Level.FINE, "error destroying bean", e);
                        }
                    }
                    if (passStartTime != -1L) {
                        long e = System.currentTimeMillis() - passStartTime;
                    }
                }
                return success;
            }
        }
        catch (Exception ex) {
            _logger.log(Level.WARNING, PASSIVATION_ERROR_1PARAM, new Object[]{this.ejbDescriptor.getName(), ex});
        }
        return success;
    }

    @Override
    public final int getPassivationBatchCount() {
        return this.passivationBatchCount;
    }

    public final void setPassivationBatchCount(int count) {
        this.passivationBatchCount = count;
    }

    @Override
    public final boolean passivateEJB(StatefulEJBContext sfsbCtx) {
        return this.passivateEJB((ComponentContext)sfsbCtx.getSessionContext());
    }

    public long getMethodReadyCount() {
        return this.statMethodReadyCount;
    }

    public long getPassiveCount() {
        return this.sfsbStoreMonitor == null ? 0L : (long)this.sfsbStoreMonitor.getNumPassivations();
    }

    @Override
    public void activateEJB(Object sessionKey, StatefulEJBContext sfsbCtx, Object cookie) {
        SessionContextImpl context = (SessionContextImpl)sfsbCtx.getSessionContext();
        if (_logger.isLoggable(this.TRACE_LEVEL)) {
            this.logTraceInfo(context, "Attempting to activate");
        }
        EJBLocalRemoteObject ejbObject = (EJBLocalRemoteObject)cookie;
        Object ejb = context.getEJB();
        EjbInvocation ejbInv = this.createEjbInvocation(ejb, context);
        this.invocationManager.preInvoke((ComponentInvocation)ejbInv);
        boolean needToDoPostInvokeTx = false;
        try {
            context.touch();
            context.setContainer(this);
            context.setState(EJBContextImpl.BeanState.READY);
            this.incrementMethodReadyStat();
            context.setInstanceKey(sessionKey);
            context.setExistsInStore(true);
            context.initializeStatefulWriteLock();
            if (ejbObject == null) {
                if (this.hasRemoteHomeView) {
                    this.createEJBObjectImpl(context);
                } else {
                    this.createRemoteBusinessObjectImpl(context);
                }
            } else if (ejbObject instanceof EJBObjectImpl) {
                EJBObjectImpl eo = (EJBObjectImpl)ejbObject;
                ejbObject.setContext(context);
                ejbObject.setKey(sessionKey);
                byte[] sessionOID = this.uuidGenerator.keyToByteArray(sessionKey);
                if (eo.isRemoteHomeView()) {
                    context.setEJBObjectImpl(eo);
                    EJBObject ejbStub = (EJBObject)this.remoteHomeRefFactory.createRemoteReference(sessionOID);
                    eo.setStub((Remote)ejbStub);
                    context.setEJBStub(ejbStub);
                    if (this.hasRemoteBusinessView) {
                        this.createRemoteBusinessObjectImpl(context);
                    }
                } else {
                    context.setEJBRemoteBusinessObjectImpl(eo);
                    for (RemoteBusinessIntfInfo next : this.remoteBusinessIntfInfo.values()) {
                        Remote stub = next.referenceFactory.createRemoteReference(sessionOID);
                        eo.setStub(next.generatedRemoteIntf.getName(), stub);
                    }
                    if (this.hasRemoteHomeView) {
                        this.createEJBObjectImpl(context);
                    }
                }
                if (this.isLocal) {
                    if (this.hasLocalHomeView) {
                        this.createEJBLocalObjectImpl(context);
                    }
                    if (this.hasLocalBusinessView) {
                        this.createEJBLocalBusinessObjectImpl(context);
                    }
                    if (this.hasOptionalLocalBusinessView) {
                        this.createOptionalEJBLocalBusinessObjectImpl(context);
                    }
                }
            } else if (ejbObject instanceof EJBLocalObjectImpl) {
                EJBLocalObjectImpl elo = (EJBLocalObjectImpl)ejbObject;
                ejbObject.setContext(context);
                ejbObject.setKey(sessionKey);
                if (elo.isLocalHomeView()) {
                    context.setEJBLocalObjectImpl(elo);
                    if (this.hasLocalBusinessView) {
                        this.createEJBLocalBusinessObjectImpl(context);
                    }
                    if (this.hasOptionalLocalBusinessView) {
                        this.createOptionalEJBLocalBusinessObjectImpl(context);
                    }
                } else if (elo.isOptionalLocalBusinessView()) {
                    context.setOptionalEJBLocalBusinessObjectImpl(elo);
                    if (this.hasLocalBusinessView) {
                        this.createEJBLocalBusinessObjectImpl(context);
                    }
                    if (this.hasLocalHomeView) {
                        this.createEJBLocalObjectImpl(context);
                    }
                } else {
                    context.setEJBLocalBusinessObjectImpl(elo);
                    if (this.hasLocalHomeView) {
                        this.createEJBLocalObjectImpl(context);
                    }
                    if (this.hasOptionalLocalBusinessView) {
                        this.createOptionalEJBLocalBusinessObjectImpl(context);
                    }
                }
                if (this.hasRemoteHomeView) {
                    this.createEJBObjectImpl(context);
                }
                if (this.hasRemoteBusinessView) {
                    this.createRemoteBusinessObjectImpl(context);
                }
            }
            this.repopulateEEMMapsInContext(sessionKey, context);
            try {
                needToDoPostInvokeTx = this.callLifecycleCallbackInTxIfUsed(ejbInv, context, this.postActivateInvInfo, LifecycleCallbackDescriptor.CallbackType.POST_ACTIVATE);
            }
            catch (Throwable th) {
                EJBException ejbEx = new EJBException("Error during activation" + sessionKey);
                ejbEx.initCause(th);
                throw ejbEx;
            }
            long now = System.currentTimeMillis();
            try {
                this.backingStore.updateTimestamp((Serializable)sessionKey, now);
                context.setLastPersistedAt(now);
            }
            catch (BackingStoreException sfsbEx) {
                _logger.log(Level.WARNING, COULDNT_UPDATE_TIMESTAMP_FOR_EXCEPTION, new Object[]{sessionKey, sfsbEx});
                _logger.log(Level.FINE, "Couldn't update timestamp for: " + sessionKey, sfsbEx);
            }
            if (_logger.isLoggable(this.TRACE_LEVEL)) {
                this.logTraceInfo(context, "Successfully activated");
            }
            _logger.log(Level.FINE, "Activated: " + sessionKey);
        }
        catch (Exception ex) {
            if (_logger.isLoggable(this.TRACE_LEVEL)) {
                this.logTraceInfo(context, "Failed to activate");
            }
            _logger.log(Level.SEVERE, SFSB_ACTIVATION_ERROR, new Object[]{sessionKey, ex});
            _logger.log(Level.SEVERE, "", ex);
            throw new EJBException("Unable to activate EJB for key: " + sessionKey, ex);
        }
        finally {
            this.invocationManager.postInvoke((ComponentInvocation)ejbInv);
            this.completeLifecycleCallbackTxIfUsed(ejbInv, context, needToDoPostInvokeTx);
        }
    }

    @Override
    public byte[] serializeContext(StatefulEJBContext ctx) throws IOException {
        return this.serializeContext((SessionContextImpl)ctx.getSessionContext());
    }

    @Override
    public Object deserializeData(byte[] data) throws Exception {
        Object o = this.ejbContainerUtilImpl.getJavaEEIOUtils().deserializeObject(data, true, this.getClassLoader());
        if (o instanceof SessionContextImpl) {
            SessionContextImpl ctx = (SessionContextImpl)o;
            Object ejb = ctx.getEJB();
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, "StatefulSessionContainer.deserializeData: " + (ejb == null ? null : ejb.getClass()));
            }
            if (ejb instanceof SerializableEJB) {
                SerializableEJB sejb = (SerializableEJB)ejb;
                try (ByteArrayInputStream bis = new ByteArrayInputStream(sejb.serializedFields);
                     ObjectInputStream ois = this.ejbContainerUtilImpl.getJavaEEIOUtils().createObjectInputStream((InputStream)bis, true, this.getClassLoader());){
                    ejb = this.ejbClass.newInstance();
                    EJBUtils.deserializeObjectFields(ejb, ois, o, false);
                    ctx.setEJB(ejb);
                }
            }
        }
        return o;
    }

    private byte[] serializeContext(SessionContextImpl ctx) throws IOException {
        Object ejb = ctx.getEJB();
        if (!(ejb instanceof Serializable) && !ejb.getClass().getName().equals(EJBUtils.getGeneratedSerializableClassName(this.ejbName))) {
            ctx.setEJB(null);
            ctx.setEJB(new SerializableEJB(ejb));
        }
        return this.ejbContainerUtilImpl.getJavaEEIOUtils().serializeObject((Object)ctx, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void decrementRefCountsForEEMs(SessionContextImpl context) {
        Collection<EEMRefInfo> allRefInfos = context.getAllEEMRefInfos();
        for (EEMRefInfo refInfo : allRefInfos) {
            EEMRefInfoKey key = refInfo.getKey();
            Map<EntityManager, EEMRefInfo> map = extendedEMReferenceCountMap;
            synchronized (map) {
                EEMRefInfo cachedRefInfo = extendedEMReferenceCountMap.get(refInfo.eem);
                if (cachedRefInfo != null) {
                    cachedRefInfo.refCount--;
                    if (cachedRefInfo.refCount == 0) {
                        extendedEMReferenceCountMap.remove(refInfo.eem);
                        eemKey2EEMMap.remove(key);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void repopulateEEMMapsInContext(Object sessionKey, SessionContextImpl context) {
        Collection<EEMRefInfo> allRefInfos = context.getAllEEMRefInfos();
        for (EEMRefInfo refInfo : allRefInfos) {
            EEMRefInfoKey key = refInfo.getKey();
            Map<EntityManager, EEMRefInfo> map = extendedEMReferenceCountMap;
            synchronized (map) {
                EEMRefInfo newRefInfo;
                block33: {
                    EntityManager eMgr = eemKey2EEMMap.get(key);
                    newRefInfo = null;
                    if (eMgr != null) {
                        EEMRefInfo cachedRefInfo = extendedEMReferenceCountMap.get(eMgr);
                        context.addExtendedEntityManagerMapping(cachedRefInfo.getEntityManagerFactory(), cachedRefInfo);
                        cachedRefInfo.refCount++;
                        newRefInfo = cachedRefInfo;
                    } else {
                        String emRefName = key.emRefName;
                        String unitName = refInfo.getUnitName();
                        EntityManagerFactory emf = EntityManagerFactoryWrapper.lookupEntityManagerFactory((ComponentInvocation.ComponentInvocationType)ComponentInvocation.ComponentInvocationType.EJB_INVOCATION, (String)unitName, (Object)((Object)this.ejbDescriptor));
                        if (emf != null) {
                            try (ByteArrayInputStream bis = new ByteArrayInputStream(refInfo.serializedEEM);
                                 ObjectInputStream ois = new ObjectInputStream(bis);){
                                eMgr = (EntityManager)ois.readObject();
                                newRefInfo = new EEMRefInfo(emRefName, unitName, refInfo.getSynchronizationType(), super.getContainerId(), sessionKey, eMgr, emf);
                                newRefInfo.refCount = 1;
                                extendedEMReferenceCountMap.put(eMgr, newRefInfo);
                                eemKey2EEMMap.put(newRefInfo.getKey(), newRefInfo.getEntityManager());
                                break block33;
                            }
                            catch (Throwable th) {
                                EJBException ejbEx = new EJBException("Couldn't create EntityManager for refName: " + emRefName);
                                ejbEx.initCause(th);
                                throw ejbEx;
                            }
                        }
                        throw new EJBException("EMF is null. Couldn't get extended EntityManager for refName: " + emRefName);
                    }
                }
                context.addExtendedEntityManagerMapping(newRefInfo.getEntityManagerFactory(), newRefInfo);
            }
        }
    }

    @Override
    protected void validateEMForClientTx(EjbInvocation inv, JavaEETransaction clientJ2EETx) throws EJBException {
        SessionContextImpl sessionCtx = (SessionContextImpl)inv.context;
        Map<EntityManagerFactory, PhysicalEntityManagerWrapper> entityManagerMap = sessionCtx.getExtendedEntityManagerMap();
        for (Map.Entry<EntityManagerFactory, PhysicalEntityManagerWrapper> entry : entityManagerMap.entrySet()) {
            EntityManagerFactory emf = entry.getKey();
            if (clientJ2EETx.getTxEntityManagerResource(emf) != null) {
                throw new EJBException("There is an active transactional persistence context for the same EntityManagerFactory as the current stateful session bean's extended persistence context");
            }
            PhysicalEntityManagerWrapper physicalEM = (PhysicalEntityManagerWrapper)clientJ2EETx.getExtendedEntityManagerResource(emf);
            if (physicalEM == null || entry.getValue().getEM() == physicalEM.getEM()) continue;
            throw new EJBException("Detected two different extended persistence contexts for the same EntityManagerFactory within a transaction");
        }
    }

    @Override
    protected void enlistExtendedEntityManagers(ComponentContext ctx) {
        if (ctx.getTransaction() != null) {
            JavaEETransaction j2eeTx = (JavaEETransaction)ctx.getTransaction();
            SessionContextImpl sessionCtx = (SessionContextImpl)ctx;
            Map<EntityManagerFactory, PhysicalEntityManagerWrapper> entityManagerMap = sessionCtx.getExtendedEntityManagerMap();
            for (Map.Entry<EntityManagerFactory, PhysicalEntityManagerWrapper> entry : entityManagerMap.entrySet()) {
                EntityManagerFactory emf = entry.getKey();
                PhysicalEntityManagerWrapper extendedEm = entry.getValue();
                PhysicalEntityManagerWrapper extendedEmAssociatedWithTx = EntityManagerWrapper.getExtendedEntityManager((JavaEETransaction)j2eeTx, (EntityManagerFactory)emf);
                if (extendedEmAssociatedWithTx != null) continue;
                j2eeTx.addExtendedEntityManagerMapping(emf, (SimpleResource)extendedEm);
                sessionCtx.setEmfRegisteredWithTx(emf, true);
                if (extendedEm.getSynchronizationType() != SynchronizationType.SYNCHRONIZED) continue;
                extendedEm.getEM().joinTransaction();
            }
        }
    }

    @Override
    protected void delistExtendedEntityManagers(ComponentContext ctx) {
        if (ctx.getTransaction() != null) {
            SessionContextImpl sessionCtx = (SessionContextImpl)ctx;
            JavaEETransaction j2eeTx = (JavaEETransaction)sessionCtx.getTransaction();
            Map<EntityManagerFactory, PhysicalEntityManagerWrapper> entityManagerMap = sessionCtx.getExtendedEntityManagerMap();
            for (Map.Entry<EntityManagerFactory, PhysicalEntityManagerWrapper> entry : entityManagerMap.entrySet()) {
                EntityManagerFactory emf = entry.getKey();
                if (!sessionCtx.isEmfRegisteredWithTx(emf)) continue;
                j2eeTx.removeExtendedEntityManagerMapping(emf);
                sessionCtx.setEmfRegisteredWithTx(emf, false);
            }
        }
    }

    @Override
    public void invokePeriodically(long delay, long periodicity, Runnable target) {
        Timer timer = this.ejbContainerUtilImpl.getTimer();
        PeriodicTask timerTask = new PeriodicTask(this.loader, target, this.ejbContainerUtilImpl);
        timer.scheduleAtFixedRate((TimerTask)timerTask, delay, periodicity);
        this.scheduledTimerTasks.add(timerTask);
    }

    public void onUndeploy(StatefulEJBContext sfsbCtx) {
        this.undeploy((SessionContextImpl)sfsbCtx.getSessionContext());
    }

    @Override
    protected String[] getPre30LifecycleMethodNames() {
        return new String[]{null, null, "ejbRemove", "ejbPassivate", "ejbActivate"};
    }

    @Override
    protected void doConcreteContainerShutdown(boolean appBeingUndeployed) {
        this.cancelAllTimerTasks();
        if (appBeingUndeployed && !this.ejbDescriptor.getApplication().getKeepStateResolved()) {
            this.removeBeansOnUndeploy();
        } else {
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, "StatefulSessionContainer.doConcreteContainerShutdown() called with --keepstate=" + this.ejbDescriptor.getApplication().getKeepStateResolved());
            }
            this.passivateBeansOnShutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void passivateBeansOnShutdown() {
        ClassLoader origLoader = Utility.setContextClassLoader((ClassLoader)this.loader);
        try {
            _logger.log(Level.FINE, "Passivating SFSBs before container shutdown");
            if (!this.isPassivationCapable() && _logger.isLoggable(Level.INFO)) {
                _logger.log(Level.INFO, SFSB_NOT_RESTORED_AFTER_RESTART);
            }
            this.sessionBeanCache.shutdown();
            while (true) {
                ComponentContext ctx = null;
                Object object = this.asyncTaskSemaphore;
                synchronized (object) {
                    int sz = this.passivationCandidates.size();
                    if (sz <= 0) {
                        break;
                    }
                    ctx = (ComponentContext)this.passivationCandidates.remove(sz - 1);
                }
                this.passivateEJB(ctx);
            }
            this.sessionBeanCache.destroy();
            this.cacheProbeListener.unregister();
            try {
                if (this.backingStore != null) {
                    this.backingStore.close();
                }
            }
            catch (BackingStoreException sfsbEx) {
                _logger.log(Level.WARNING, ERROR_DURING_BACKING_STORE_SHUTDOWN, new Object[]{this.ejbName, sfsbEx});
            }
        }
        catch (Throwable th) {
            _logger.log(Level.WARNING, ERROR_DURING_ON_SHUTDOWN, new Object[]{this.ejbName, th});
        }
        finally {
            Utility.setContextClassLoader((ClassLoader)origLoader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeBeansOnUndeploy() {
        ClassLoader origLoader = Utility.setContextClassLoader((ClassLoader)this.loader);
        long myContainerId = 0L;
        try {
            SessionContextImpl ctx;
            myContainerId = this.getContainerId();
            _logger.log(Level.FINE, "Removing SFSBs during application undeploy");
            this.sessionBeanCache.setUndeployedState();
            Iterator iter = this.sessionBeanCache.values();
            while (iter.hasNext()) {
                ctx = (SessionContextImpl)iter.next();
                this.invokePreDestroyAndUndeploy(ctx);
            }
            while (true) {
                ctx = null;
                Object object = this.asyncTaskSemaphore;
                synchronized (object) {
                    int sz = this.passivationCandidates.size();
                    if (sz <= 0) {
                        break;
                    }
                    ctx = (SessionContextImpl)this.passivationCandidates.remove(sz - 1);
                    this.invokePreDestroyAndUndeploy(ctx);
                }
            }
            this.sessionBeanCache.destroy();
            try {
                if (this.backingStore != null) {
                    this.backingStore.destroy();
                }
            }
            catch (BackingStoreException sfsbEx) {
                _logger.log(Level.WARNING, ERROR_DURING_BACKING_STORE_SHUTDOWN, new Object[]{this.ejbName, sfsbEx});
            }
        }
        finally {
            if (this.sfsbVersionManager != null) {
                this.sfsbVersionManager.removeAll(myContainerId);
            }
            if (origLoader != null) {
                Utility.setContextClassLoader((ClassLoader)origLoader);
            }
        }
    }

    private void invokePreDestroyAndUndeploy(SessionContextImpl ctx) {
        try {
            ctx.setInEjbRemove(true);
            this.destroyBean(null, ctx);
        }
        catch (Throwable t) {
            _logger.log(Level.FINE, "exception thrown from SFSB PRE_DESTROY", t);
        }
        finally {
            ctx.setInEjbRemove(false);
        }
        try {
            this.undeploy(ctx);
        }
        catch (Exception ex) {
            _logger.log(Level.WARNING, ERROR_WHILE_UNDEPLOYING_CTX_KEY, new Object[]{this.ejbName, ctx.getInstanceKey()});
            _logger.log(Level.FINE, "[" + this.ejbName + "]: Error while  undeploying ctx. Key: " + ctx.getInstanceKey(), ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cancelAllTimerTasks() {
        try {
            int size = this.scheduledTimerTasks.size();
            for (int i = 0; i < size; ++i) {
                TimerTask task = (TimerTask)this.scheduledTimerTasks.get(i);
                task.cancel();
            }
        }
        catch (Exception exception) {
        }
        finally {
            this.scheduledTimerTasks.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void destroyBean(EjbInvocation ejbInv, EJBContextImpl ctx) {
        if (ejbInv == null) {
            ejbInv = this.createEjbInvocation(ctx.getEJB(), ctx);
        }
        boolean inTx = false;
        try {
            this.invocationManager.preInvoke((ComponentInvocation)ejbInv);
            inTx = this.callLifecycleCallbackInTxIfUsed(ejbInv, ctx, this.preDestroyInvInfo, LifecycleCallbackDescriptor.CallbackType.PRE_DESTROY);
        }
        catch (Throwable t) {
            _logger.log(Level.FINE, "exception thrown from SFSB PRE_DESTROY", t);
        }
        finally {
            this.invocationManager.postInvoke((ComponentInvocation)ejbInv);
            this.completeLifecycleCallbackTxIfUsed(ejbInv, ctx, inTx);
        }
    }

    private boolean callLifecycleCallbackInTxIfUsed(EjbInvocation ejbInv, EJBContextImpl ctx, InvocationInfo invInfo, LifecycleCallbackDescriptor.CallbackType callbackType) throws Throwable {
        boolean inTx;
        boolean bl = inTx = invInfo.txAttr != -1 && invInfo.txAttr != 2;
        if (inTx) {
            ((SessionContextImpl)ctx).setInLifeCycleCallback(true);
            ejbInv.transactionAttribute = invInfo.txAttr;
            ejbInv.invocationInfo = invInfo;
            this.preInvokeTx(ejbInv);
            this.enlistExtendedEntityManagers(ctx);
        }
        this.intercept(callbackType, ctx);
        return inTx;
    }

    private void completeLifecycleCallbackTxIfUsed(EjbInvocation ejbInv, EJBContextImpl ctx, boolean usedTx) {
        if (usedTx) {
            this.delistExtendedEntityManagers(ctx);
            try {
                this.postInvokeTx(ejbInv);
            }
            catch (Exception pie) {
                _logger.log(Level.FINE, "SFSB postInvokeTx exception", pie);
            }
            ((SessionContextImpl)ctx).setInLifeCycleCallback(false);
        }
    }

    public void undeploy(SessionContextImpl ctx) {
        if (ctx.getContainer() == this) {
            EJBObjectImpl ejbBusinessObjectImpl;
            EJBObjectImpl ejbObjectImpl;
            if (this.hasRemoteHomeView && (ejbObjectImpl = ctx.getEJBObjectImpl()) != null) {
                this.remoteHomeRefFactory.destroyReference(ejbObjectImpl.getStub(), ejbObjectImpl.getEJBObject());
            }
            if (this.hasRemoteBusinessView && (ejbBusinessObjectImpl = ctx.getEJBRemoteBusinessObjectImpl()) != null) {
                for (RemoteBusinessIntfInfo next : this.remoteBusinessIntfInfo.values()) {
                    next.referenceFactory.destroyReference(ejbBusinessObjectImpl.getStub(next.generatedRemoteIntf.getName()), ejbBusinessObjectImpl.getEJBObject(next.generatedRemoteIntf.getName()));
                }
            }
            this.sessionBeanCache.remove(ctx.getInstanceKey(), ctx.existsInStore());
            this.destroyExtendedEMsForContext(ctx);
            this.transactionManager.componentDestroyed((ResourceHandler)ctx);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void trimEvent(Object primaryKey, Object context) {
        boolean addTask = false;
        Object object = this.asyncTaskSemaphore;
        synchronized (object) {
            ++this.containerTrimCount;
            this.passivationCandidates.add(context);
            int requiredTaskCount = this.passivationCandidates.size() / this.passivationBatchCount;
            boolean bl = addTask = this.asyncTaskCount < requiredTaskCount;
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, "qSize: " + this.passivationCandidates.size() + "; batchCount: " + this.passivationBatchCount + "; asyncTaskCount: " + this.asyncTaskCount + "; requiredTaskCount: " + requiredTaskCount + "; ADDED TASK ==> " + addTask);
            }
            if (!addTask) {
                return;
            }
            ++this.asyncTaskCount;
            ++this.asyncCummTaskCount;
        }
        try {
            ASyncPassivator work = new ASyncPassivator();
            this.ejbContainerUtilImpl.addWork(work);
        }
        catch (Exception ex) {
            Object object2 = this.asyncTaskSemaphore;
            synchronized (object2) {
                --this.asyncTaskCount;
            }
            _logger.log(Level.WARNING, ADD_CLEANUP_TASK_ERROR, ex);
        }
    }

    public void setSFSBUUIDUtil(SFSBUUIDUtil util) {
        this.uuidGenerator = util;
    }

    public void setHAEnabled(boolean isHAEnabled) {
        this.isHAEnabled = isHAEnabled;
    }

    public void setSessionCache(LruSessionCache cache) {
        this.sessionBeanCache = cache;
    }

    public void setRemovalGracePeriodInSeconds(int val) {
        this.removalGracePeriodInSeconds = val;
    }

    public void removeExpiredSessions() {
        try {
            _logger.log(Level.FINE, "StatefulContainer Removing expired sessions....");
            long val = 0L;
            if (this.backingStore != null) {
                val = this.backingStore.removeExpired((long)this.removalGracePeriodInSeconds * 1000L);
            }
            if (this.cacheProbeNotifier != null) {
                this.cacheProbeNotifier.ejbExpiredSessionsRemovedEvent(this.getContainerId(), this.containerInfo.appName, this.containerInfo.modName, this.containerInfo.ejbName, val);
            }
            _logger.log(Level.FINE, "StatefulContainer Removed " + val + " sessions....");
        }
        catch (Exception sfsbEx) {
            _logger.log(Level.WARNING, GOT_EXCEPTION_DURING_REMOVE_EXPIRED_SESSIONS, sfsbEx);
        }
    }

    public void setSFSBVersionManager(SFSBVersionManager sfsbVersionManager) {
        this.sfsbVersionManager = sfsbVersionManager;
    }

    private void handleEndOfMethodCheckpoint(SessionContextImpl sc, EjbInvocation inv) {
        int txAttr = inv.invocationInfo.txAttr;
        switch (txAttr) {
            case 1: 
            case 4: 
            case 7: {
                if (!inv.invocationInfo.checkpointEnabled) break;
                this.checkpointEJB(sc);
                break;
            }
            case 2: {
                if (!sc.isTxCheckpointDelayed() && !inv.invocationInfo.checkpointEnabled) break;
                this.checkpointEJB(sc);
                sc.setTxCheckpointDelayed(false);
                break;
            }
            default: {
                if (!inv.invocationInfo.isCreateHomeFinder || !inv.invocationInfo.checkpointEnabled) break;
                this.checkpointEJB(sc);
            }
        }
        if (sc.getState() != EJBContextImpl.BeanState.DESTROYED) {
            sc.setState(EJBContextImpl.BeanState.READY);
            this.incrementMethodReadyStat();
            if (_logger.isLoggable(this.TRACE_LEVEL)) {
                this.logTraceInfo(inv, sc.getInstanceKey(), "Released context");
            }
        }
    }

    private void syncClientVersion(EjbInvocation inv, SessionContextImpl sc) {
        EJBLocalRemoteObject ejbLRO = inv.ejbObject;
        if (ejbLRO != null) {
            ejbLRO.setSfsbClientVersion(sc.getVersion());
        }
        if (!inv.isLocal && this.isHAEnabled) {
            long version = sc.getVersion();
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, "Added [synced] version: " + version + " for key: " + sc.getInstanceKey());
            }
        }
    }

    public int getMaxCacheSize() {
        return this.sessionBeanCache.getMaxCacheSize();
    }

    public BackingStore<Serializable, SimpleMetadata> getBackingStore() {
        return this.backingStore;
    }

    public void setBackingStore(BackingStore<Serializable, SimpleMetadata> store) {
        this.backingStore = store;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean checkpointEJB(SessionContextImpl sc) {
        boolean checkpointed = false;
        try {
            if (this.containerState != 0 && this.containerState != 1) {
                _logger.log(Level.FINE, "passivateEJB() returning because containerState: " + this.containerState);
                return false;
            }
            if (sc.getState() == EJBContextImpl.BeanState.DESTROYED) {
                return false;
            }
            Object ejb = sc.getEJB();
            long checkpointStartTime = -1L;
            if (this.sfsbStoreMonitor != null && this.sfsbStoreMonitor.isMonitoringOn()) {
                checkpointStartTime = System.currentTimeMillis();
            }
            EjbInvocation ejbInv = this.createEjbInvocation(ejb, sc);
            this.invocationManager.preInvoke((ComponentInvocation)ejbInv);
            boolean needToDoPostInvokeTx = false;
            boolean destroyBean = false;
            SessionContextImpl sessionContextImpl = sc;
            synchronized (sessionContextImpl) {
                try {
                    if (sc.getState() != EJBContextImpl.BeanState.READY) {
                        boolean bl = false;
                        return bl;
                    }
                    sc.setState(EJBContextImpl.BeanState.PASSIVATED);
                    this.decrementMethodReadyStat();
                    needToDoPostInvokeTx = this.callLifecycleCallbackInTxIfUsed(ejbInv, sc, this.prePassivateInvInfo, LifecycleCallbackDescriptor.CallbackType.PRE_PASSIVATE);
                    sc.setLastPersistedAt(System.currentTimeMillis());
                    byte[] serializedState = null;
                    try {
                        long newCtxVersion = sc.incrementAndGetVersion();
                        serializedState = this.serializeContext(sc);
                        SimpleMetadata beanState = new SimpleMetadata(sc.getVersion(), sc.getLastAccessTime(), (long)this.removalGracePeriodInSeconds * 1000L, serializedState);
                        beanState.setVersion(newCtxVersion);
                        this.backingStore.save((Serializable)sc.getInstanceKey(), (Serializable)beanState, !sc.existsInStore());
                        sc.setLastPersistedAt(System.currentTimeMillis());
                        sc.setExistsInStore(true);
                        checkpointed = true;
                    }
                    catch (EMNotSerializableException emNotSerEx) {
                        _logger.log(Level.WARNING, ERROR_DURING_CHECKPOINT_SESSION_ALIVE, emNotSerEx);
                    }
                    catch (NotSerializableException notSerEx) {
                        throw notSerEx;
                    }
                    catch (Exception ignorableEx) {
                        _logger.log(Level.WARNING, ERROR_DURING_CHECKPOINT, ignorableEx);
                    }
                    this.completeLifecycleCallbackTxIfUsed(ejbInv, sc, needToDoPostInvokeTx);
                    needToDoPostInvokeTx = this.callLifecycleCallbackInTxIfUsed(ejbInv, sc, this.postActivateInvInfo, LifecycleCallbackDescriptor.CallbackType.POST_ACTIVATE);
                    sc.setState(EJBContextImpl.BeanState.READY);
                    this.incrementMethodReadyStat();
                    if (this.sfsbStoreMonitor == null) return checkpointed;
                    this.sfsbStoreMonitor.setCheckpointSize(serializedState.length);
                    this.sfsbStoreMonitor.incrementCheckpointCount(true);
                }
                catch (Throwable ex) {
                    if (this.sfsbStoreMonitor != null) {
                        this.sfsbStoreMonitor.incrementCheckpointCount(false);
                    }
                    _logger.log(Level.WARNING, SFSB_CHECKPOINT_ERROR_NAME, new Object[]{this.ejbDescriptor.getName()});
                    _logger.log(Level.WARNING, SFSB_CHECKPOINT_ERROR_KEY, new Object[]{sc.getInstanceKey(), ex});
                    destroyBean = true;
                }
                finally {
                    this.invocationManager.postInvoke((ComponentInvocation)ejbInv);
                    this.completeLifecycleCallbackTxIfUsed(ejbInv, sc, needToDoPostInvokeTx);
                    if (destroyBean) {
                        try {
                            this.forceDestroyBean(sc);
                        }
                        catch (Exception e) {
                            _logger.log(Level.FINE, "error destroying bean", e);
                        }
                    }
                    if (checkpointStartTime != -1L) {
                        long timeSpent = System.currentTimeMillis() - checkpointStartTime;
                        if (this.sfsbStoreMonitor != null) {
                            this.sfsbStoreMonitor.setCheckpointTime(timeSpent);
                        }
                    }
                }
                return checkpointed;
            }
        }
        catch (Exception ex) {
            _logger.log(Level.WARNING, PASSIVATION_ERROR_1PARAM, new Object[]{this.ejbDescriptor.getName(), ex});
        }
        return checkpointed;
    }

    public void incrementMethodReadyStat() {
        ++this.statMethodReadyCount;
        this.ejbProbeNotifier.methodReadyAddEvent(this.getContainerId(), this.containerInfo.appName, this.containerInfo.modName, this.containerInfo.ejbName);
    }

    public void decrementMethodReadyStat() {
        --this.statMethodReadyCount;
        this.ejbProbeNotifier.methodReadyRemoveEvent(this.getContainerId(), this.containerInfo.appName, this.containerInfo.modName, this.containerInfo.ejbName);
    }

    static /* synthetic */ Object access$600(StatefulSessionContainer x0) {
        return x0.asyncTaskSemaphore;
    }

    static /* synthetic */ ArrayList access$700(StatefulSessionContainer x0) {
        return x0.passivationCandidates;
    }

    static /* synthetic */ int access$810(StatefulSessionContainer x0) {
        return x0.asyncTaskCount--;
    }

    static class SerializableEJB
    implements IndirectlySerializable,
    SerializableObjectFactory {
        private byte[] serializedFields;

        SerializableEJB(Object ejb) throws IOException {
            try (ByteArrayOutputStream bos = new ByteArrayOutputStream();
                 ObjectOutputStream oos = EjbContainerUtilImpl.getInstance().getJavaEEIOUtils().createObjectOutputStream((OutputStream)bos, true);){
                EJBUtils.serializeObjectFields(ejb, oos, false);
                oos.flush();
                bos.flush();
                this.serializedFields = bos.toByteArray();
            }
        }

        public SerializableObjectFactory getSerializableObjectFactory() throws IOException {
            return this;
        }

        public Object createObject() throws IOException {
            return this;
        }
    }

    static class EMNotSerializableException
    extends NotSerializableException {
        public EMNotSerializableException(String className, Throwable th) {
            super(className);
            super.initCause(th);
        }
    }

    static class EEMRefInfo
    implements IndirectlySerializable,
    SerializableObjectFactory {
        private transient int refCount = 0;
        private String unitName;
        private SynchronizationType synchronizationType;
        private EEMRefInfoKey eemRefInfoKey;
        private byte[] serializedEEM;
        private transient EntityManager eem;
        private transient EntityManagerFactory emf;
        private int hc;

        EEMRefInfo(String emRefName, String uName, SynchronizationType synchronizationType, long containerID, Object instanceKey, EntityManager eem, EntityManagerFactory emf) {
            this.eemRefInfoKey = new EEMRefInfoKey(emRefName, containerID, instanceKey);
            this.eem = eem;
            this.emf = emf;
            this.unitName = uName;
            this.synchronizationType = synchronizationType;
        }

        EntityManager getEntityManager() {
            return this.eem;
        }

        EntityManagerFactory getEntityManagerFactory() {
            return this.emf;
        }

        EEMRefInfoKey getKey() {
            return this.eemRefInfoKey;
        }

        Object getSessionKey() {
            return this.eemRefInfoKey.instanceKey;
        }

        String getUnitName() {
            return this.unitName;
        }

        SynchronizationType getSynchronizationType() {
            return this.synchronizationType;
        }

        public SerializableObjectFactory getSerializableObjectFactory() throws IOException {
            try (ByteArrayOutputStream bos = new ByteArrayOutputStream();
                 ObjectOutputStream oos = new ObjectOutputStream(bos);){
                oos.writeObject(this.eem);
                oos.flush();
                bos.flush();
                this.serializedEEM = bos.toByteArray();
            }
            catch (NotSerializableException notSerEx) {
                throw new EMNotSerializableException(notSerEx.toString(), notSerEx);
            }
            catch (IOException ioEx) {
                throw new EMNotSerializableException(ioEx.toString(), ioEx);
            }
            return this;
        }

        public Object createObject() throws IOException {
            return this;
        }
    }

    static class EEMRefInfoKey
    implements Serializable {
        private String emRefName;
        private long containerID;
        private Object instanceKey;
        private int hc;

        EEMRefInfoKey(String en, long cid, Object ikey) {
            this.emRefName = en;
            this.containerID = cid;
            this.instanceKey = ikey;
            this.hc = this.instanceKey.hashCode();
        }

        public int hashCode() {
            return this.hc;
        }

        public boolean equals(Object obj) {
            boolean result = false;
            if (obj instanceof EEMRefInfoKey) {
                EEMRefInfoKey other = (EEMRefInfoKey)obj;
                result = this.containerID == other.containerID && this.emRefName.equals(other.emRefName) && this.instanceKey.equals(other.instanceKey);
            }
            return result;
        }

        public String toString() {
            return "<" + this.instanceKey + ":" + this.emRefName + ":" + this.containerID + ">";
        }
    }

    private class ASyncPassivator
    implements Runnable {
        private ASyncPassivator() {
        }

        /*
         * Exception decompiling
         */
        @Override
        public void run() {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 18[UNCONDITIONALDOLOOP]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }
    }
}

