/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.monitor.jvm;

import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import org.glassfish.gmbal.AMXMetadata;
import org.glassfish.gmbal.Description;
import org.glassfish.gmbal.ManagedAttribute;
import org.glassfish.gmbal.ManagedObject;

@AMXMetadata(type="server-runtime-mon", group="monitoring", isSingleton=true)
@ManagedObject
@Description(value="Server Runtime Statistics")
public class ServerRuntimeStatsProvider {
    private final RuntimeMXBean rtBean = ManagementFactory.getRuntimeMXBean();
    public static final int STARTING_STATE = 0;
    public static final int RUNNING_STATE = 1;
    public static final int STOPPING_STATE = 2;
    public static final int STOPPED_STATE = 3;
    public static final int FAILED_STATE = 4;
    private int state = 3;

    @ManagedAttribute(id="uptime")
    @Description(value="uptime of the Java virtual machine in milliseconds")
    public long getUptime() {
        return this.rtBean.getUptime();
    }

    @ManagedAttribute(id="starttime")
    @Description(value="start time of the Java virtual machine")
    public long getStartTime() {
        return this.rtBean.getStartTime();
    }

    @ManagedAttribute(id="state")
    @Description(value="state of the server such as Running, Stopped, Failed")
    public synchronized long getState() {
        if (this.rtBean != null) {
            return 1L;
        }
        return this.state;
    }

    public synchronized void setState(int state) {
        this.state = state;
    }
}

