/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.sessions.serializers;

import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import org.eclipse.persistence.sessions.Session;
import org.eclipse.persistence.sessions.serializers.XMLSerializer;

public class JSONSerializer
extends XMLSerializer {
    public JSONSerializer() {
    }

    public JSONSerializer(String packageName) {
        super(packageName);
    }

    public JSONSerializer(JAXBContext context) {
        super(context);
    }

    @Override
    public Object serialize(Object object, Session session) {
        try {
            Marshaller marshaller = this.context.createMarshaller();
            marshaller.setProperty("eclipselink.media-type", (Object)"application/json");
            StringWriter writer = new StringWriter();
            marshaller.marshal(object, (Writer)writer);
            return writer.toString();
        }
        catch (JAXBException exception) {
            throw new RuntimeException(exception);
        }
    }

    @Override
    public Object deserialize(Object json, Session session) {
        try {
            Unmarshaller unmarshaller = this.context.createUnmarshaller();
            unmarshaller.setProperty("eclipselink.media-type", (Object)"application/json");
            StringReader reader = new StringReader((String)json);
            return unmarshaller.unmarshal((Reader)reader);
        }
        catch (JAXBException exception) {
            throw new RuntimeException(exception);
        }
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName();
    }
}

