/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.lib.deliverable.cts.deploy;

import com.sun.ts.lib.util.TestUtil;
import java.util.ArrayList;
import javax.enterprise.deploy.spi.Target;
import javax.enterprise.deploy.spi.TargetModuleID;
import javax.enterprise.deploy.spi.status.ProgressObject;

public class OperationStatus {
    private boolean failed;
    private String progressMessage;
    private Target[] failedTargets;
    private TargetModuleID[] deployedTargetIDs;
    private ProgressObject progress;

    public OperationStatus(ProgressObject progress, Target[] failedTargets) {
        this(progress, failedTargets, progress.getDeploymentStatus().isFailed());
    }

    public OperationStatus(ProgressObject progress, Target[] failedTargets, boolean failed) {
        this.progress = progress;
        this.failed = failed;
        this.progressMessage = progress.getDeploymentStatus().getMessage();
        this.failedTargets = failedTargets;
        this.deployedTargetIDs = this.filterNonRootTargetModuleIDs(progress.getResultTargetModuleIDs());
    }

    public boolean isFailed() {
        return this.failed;
    }

    public String getProgressMessage() {
        return this.progressMessage;
    }

    public Target[] getFailedTargets() {
        return this.findErrors();
    }

    public TargetModuleID[] getDeployedTargetIDs() {
        return this.deployedTargetIDs;
    }

    public ProgressObject getProgressObject() {
        return this.progress;
    }

    private TargetModuleID[] filterNonRootTargetModuleIDs(TargetModuleID[] ids) {
        ArrayList<TargetModuleID> result = new ArrayList<TargetModuleID>();
        for (int i = 0; i < ids.length; ++i) {
            TargetModuleID id = ids[i];
            if (id.getParentTargetModuleID() != null) continue;
            result.add(id);
        }
        return result.toArray(new TargetModuleID[result.size()]);
    }

    private boolean targetInList(Target target, TargetModuleID[] list) {
        boolean result = false;
        for (int i = 0; i < list.length; ++i) {
            Target t = list[i].getTarget();
            if (!t.getName().equals(target.getName())) continue;
            result = true;
            break;
        }
        return result;
    }

    private Target[] findErrors() {
        ArrayList<Target> failed = new ArrayList<Target>();
        for (int i = 0; i < this.failedTargets.length; ++i) {
            if (this.targetInList(this.failedTargets[i], this.deployedTargetIDs)) continue;
            failed.add(this.failedTargets[i]);
        }
        return failed.toArray(new Target[failed.size()]);
    }

    public String errMessage() {
        StringBuffer buf = new StringBuffer("Failed targets: ");
        int numFailures = this.failedTargets == null ? 0 : this.failedTargets.length;
        for (int i = 0; i < numFailures; ++i) {
            buf.append(this.failedTargets[i].getName() + "  ");
        }
        buf.append(TestUtil.NEW_LINE + "DeploymentStatus...");
        buf.append(TestUtil.NEW_LINE + "Message             = " + this.progress.getDeploymentStatus().getMessage());
        buf.append(TestUtil.NEW_LINE + "State               = " + this.progress.getDeploymentStatus().getState());
        buf.append(TestUtil.NEW_LINE + "Command             = " + this.progress.getDeploymentStatus().getCommand());
        buf.append(TestUtil.NEW_LINE + "Action              = " + this.progress.getDeploymentStatus().getAction());
        buf.append(TestUtil.NEW_LINE + "Additional info     = " + this.progress.getDeploymentStatus().toString() + TestUtil.NEW_LINE);
        return buf.toString();
    }
}

