/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security.authorize;

import com.sun.enterprise.security.authorize.HandlerData;
import java.security.SecurityPermission;
import javax.security.jacc.PolicyContextHandler;

public class PolicyContextHandlerImpl
implements PolicyContextHandler {
    public static final String HTTP_SERVLET_REQUEST = "javax.servlet.http.HttpServletRequest";
    public static final String SOAP_MESSAGE = "javax.xml.soap.SOAPMessage";
    public static final String ENTERPRISE_BEAN = "javax.ejb.EnterpriseBean";
    public static final String EJB_ARGUMENTS = "javax.ejb.arguments";
    public static final String SUBJECT = "javax.security.auth.Subject.container";
    public static final String REUSE = "java.security.Policy.supportsReuse";
    private static PolicyContextHandlerImpl pchimpl = null;
    private ThreadLocal thisHandlerData = new ThreadLocal();

    private PolicyContextHandlerImpl() {
    }

    private static synchronized PolicyContextHandlerImpl _getInstance() {
        if (pchimpl == null) {
            pchimpl = new PolicyContextHandlerImpl();
        }
        return pchimpl;
    }

    public static PolicyContextHandler getInstance() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new SecurityPermission("setPolicy"));
        }
        return PolicyContextHandlerImpl._getInstance();
    }

    public boolean supports(String key) {
        String[] s = this.getKeys();
        for (int i = 0; i < s.length; ++i) {
            if (!s[i].equalsIgnoreCase(key)) continue;
            return true;
        }
        return false;
    }

    public String[] getKeys() {
        String[] s = new String[]{HTTP_SERVLET_REQUEST, SOAP_MESSAGE, ENTERPRISE_BEAN, SUBJECT, EJB_ARGUMENTS, REUSE};
        return s;
    }

    public Object getContext(String key, Object data) {
        return this.getHandlerData().get(key);
    }

    public HandlerData getHandlerData() {
        HandlerData handlerData = (HandlerData)this.thisHandlerData.get();
        if (handlerData == null) {
            handlerData = HandlerData.getInstance();
            this.thisHandlerData.set(handlerData);
        }
        return handlerData;
    }

    public void reset() {
        HandlerData handlerData = (HandlerData)this.thisHandlerData.get();
        if (handlerData != null) {
            handlerData.reset();
        }
        this.thisHandlerData.set(null);
    }
}

