/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.impl.ior.iiop;

import com.sun.corba.ee.impl.encoding.EncapsOutputStream;
import com.sun.corba.ee.impl.encoding.OutputStreamFactory;
import com.sun.corba.ee.impl.ior.EncapsulationUtility;
import com.sun.corba.ee.impl.ior.iiop.IIOPAddressImpl;
import com.sun.corba.ee.spi.ior.ObjectId;
import com.sun.corba.ee.spi.ior.ObjectKeyTemplate;
import com.sun.corba.ee.spi.ior.TaggedComponent;
import com.sun.corba.ee.spi.ior.TaggedProfile;
import com.sun.corba.ee.spi.ior.TaggedProfileTemplate;
import com.sun.corba.ee.spi.ior.TaggedProfileTemplateBase;
import com.sun.corba.ee.spi.ior.iiop.GIOPVersion;
import com.sun.corba.ee.spi.ior.iiop.IIOPAddress;
import com.sun.corba.ee.spi.ior.iiop.IIOPFactories;
import com.sun.corba.ee.spi.ior.iiop.IIOPProfileTemplate;
import com.sun.corba.ee.spi.orb.ORB;
import java.util.Iterator;
import org.omg.CORBA_2_3.portable.InputStream;
import org.omg.CORBA_2_3.portable.OutputStream;

public class IIOPProfileTemplateImpl
extends TaggedProfileTemplateBase
implements IIOPProfileTemplate {
    private ORB orb;
    private GIOPVersion giopVersion;
    private IIOPAddress primary;

    @Override
    public Iterator<TaggedComponent> getTaggedComponents() {
        return this.iterator();
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("IIOPProfileTemplateImpl[giopVersion=");
        sb.append(this.giopVersion.getMajor()).append('.').append(this.giopVersion.getMinor());
        sb.append(" primary=");
        sb.append(this.primary.getHost()).append(':').append(this.primary.getPort());
        sb.append(']');
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof IIOPProfileTemplateImpl)) {
            return false;
        }
        IIOPProfileTemplateImpl other = (IIOPProfileTemplateImpl)obj;
        return super.equals(obj) && this.giopVersion.equals(other.giopVersion) && this.primary.equals(other.primary);
    }

    @Override
    public int hashCode() {
        return super.hashCode() ^ this.giopVersion.hashCode() ^ this.primary.hashCode();
    }

    @Override
    public TaggedProfile create(ObjectKeyTemplate oktemp, ObjectId id) {
        return IIOPFactories.makeIIOPProfile(this.orb, oktemp, id, this);
    }

    @Override
    public GIOPVersion getGIOPVersion() {
        return this.giopVersion;
    }

    @Override
    public IIOPAddress getPrimaryAddress() {
        return this.primary;
    }

    public IIOPProfileTemplateImpl(ORB orb, GIOPVersion version, IIOPAddress primary) {
        this.orb = orb;
        this.giopVersion = version;
        this.primary = primary;
        if (this.giopVersion.getMinor() == 0) {
            this.makeImmutable();
        }
    }

    public IIOPProfileTemplateImpl(InputStream istr) {
        byte major = istr.read_octet();
        byte minor = istr.read_octet();
        this.giopVersion = GIOPVersion.getInstance(major, minor);
        this.primary = new IIOPAddressImpl(istr);
        this.orb = (ORB)istr.orb();
        if (minor > 0) {
            EncapsulationUtility.readIdentifiableSequence(this, this.orb.getTaggedComponentFactoryFinder(), istr);
        }
        this.makeImmutable();
    }

    @Override
    public void write(ObjectKeyTemplate okeyTemplate, ObjectId id, OutputStream os) {
        this.giopVersion.write((org.omg.CORBA.portable.OutputStream)os);
        this.primary.write(os);
        EncapsOutputStream encapsulatedOS = OutputStreamFactory.newEncapsOutputStream((ORB)os.orb());
        okeyTemplate.write(id, encapsulatedOS);
        EncapsulationUtility.writeOutputStream(encapsulatedOS, os);
        if (this.giopVersion.getMinor() > 0) {
            EncapsulationUtility.writeIdentifiableSequence(this, os);
        }
    }

    @Override
    public void writeContents(OutputStream os) {
        this.giopVersion.write((org.omg.CORBA.portable.OutputStream)os);
        this.primary.write(os);
        if (this.giopVersion.getMinor() > 0) {
            EncapsulationUtility.writeIdentifiableSequence(this, os);
        }
    }

    @Override
    public int getId() {
        return 0;
    }

    @Override
    public boolean isEquivalent(TaggedProfileTemplate temp) {
        if (!(temp instanceof IIOPProfileTemplateImpl)) {
            return false;
        }
        IIOPProfileTemplateImpl tempimp = (IIOPProfileTemplateImpl)temp;
        return this.primary.equals(tempimp.primary);
    }
}

