/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.webservices.node;

import com.sun.enterprise.deployment.InjectionTarget;
import com.sun.enterprise.deployment.ServiceRefPortInfo;
import com.sun.enterprise.deployment.ServiceReferenceDescriptor;
import com.sun.enterprise.deployment.node.DisplayableComponentNode;
import com.sun.enterprise.deployment.node.InjectionTargetNode;
import com.sun.enterprise.deployment.node.JndiEnvRefNode;
import com.sun.enterprise.deployment.node.XMLElement;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import org.glassfish.deployment.common.Descriptor;
import org.glassfish.hk2.api.PerLookup;
import org.glassfish.webservices.connector.LogUtils;
import org.glassfish.webservices.node.AddressingNode;
import org.glassfish.webservices.node.RespectBindingNode;
import org.glassfish.webservices.node.WebServiceHandlerChainNode;
import org.glassfish.webservices.node.WebServiceHandlerNode;
import org.jvnet.hk2.annotations.Service;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

@Service(name="service-ref")
@PerLookup
public class ServiceReferenceNode
extends DisplayableComponentNode
implements JndiEnvRefNode<ServiceReferenceDescriptor> {
    private static final Logger logger = LogUtils.getLogger();
    private ServiceRefPortInfo portInfo = null;

    public ServiceReferenceNode() {
        this.registerElementHandler(new XMLElement("handler"), WebServiceHandlerNode.class, "addHandler");
        this.registerElementHandler(new XMLElement("handler-chain"), WebServiceHandlerChainNode.class, "addHandlerChain");
        this.registerElementHandler(new XMLElement("addressing"), AddressingNode.class, "setAddressing");
        this.registerElementHandler(new XMLElement("respect-binding"), RespectBindingNode.class, "setRespectBinding");
        this.registerElementHandler(new XMLElement("injection-target"), InjectionTargetNode.class, "addInjectionTarget");
    }

    protected Map getDispatchTable() {
        Map table = super.getDispatchTable();
        table.put("service-ref-name", "setName");
        table.put("service-interface", "setServiceInterface");
        table.put("wsdl-file", "setWsdlFileUri");
        table.put("jaxrpc-mapping-file", "setMappingFileUri");
        table.put("mapped-name", "setMappedName");
        table.put("lookup-name", "setLookupName");
        table.put("service-ref-type", "setInjectionTargetType");
        return table;
    }

    private ServiceReferenceDescriptor getServiceReferenceDescriptor() {
        return this.getDescriptor();
    }

    public void setElementValue(XMLElement element, String value) {
        String qname = element.getQName();
        if ("service-endpoint-interface".equals(qname)) {
            this.portInfo = this.getServiceReferenceDescriptor().getPortInfoBySEI(value);
            if (this.portInfo == null) {
                this.portInfo = this.getServiceReferenceDescriptor().addContainerManagedPort(value);
            }
        } else if ("service-qname".equals(qname)) {
            String prefix = this.getPrefixFromQName(value);
            String localPart = this.getLocalPartFromQName(value);
            String namespaceUri = this.resolvePrefix(element, prefix);
            if (namespaceUri == null) {
                logger.log(Level.SEVERE, "AS-WSCONNECTOR-00046", new Object[]{prefix, this.getServiceReferenceDescriptor().getName()});
            } else {
                QName serviceName = new QName(namespaceUri, localPart);
                this.getServiceReferenceDescriptor().setServiceName(serviceName, prefix);
            }
        } else if ("enable-mtom".equals(qname)) {
            this.portInfo.setMtomEnabled(value);
        } else if ("port-component-link".equals(qname)) {
            this.portInfo.setPortComponentLinkName(value);
            this.portInfo = null;
        } else {
            super.setElementValue(element, value);
        }
    }

    public Node writeDeploymentDescriptor(Node parent, ServiceReferenceDescriptor descriptor) {
        Node serviceRefNode = super.writeDescriptor(parent, "service-ref", (Object)descriptor);
        this.writeDisplayableComponentInfo(serviceRefNode, (Descriptor)descriptor);
        ServiceReferenceNode.appendTextChild((Node)serviceRefNode, (String)"service-ref-name", (String)descriptor.getName());
        ServiceReferenceNode.appendTextChild((Node)serviceRefNode, (String)"service-interface", (String)descriptor.getServiceInterface());
        ServiceReferenceNode.appendTextChild((Node)serviceRefNode, (String)"lookup-name", (String)descriptor.getLookupName());
        ServiceReferenceNode.appendTextChild((Node)serviceRefNode, (String)"service-ref-type", (String)descriptor.getInjectionTargetType());
        ServiceReferenceNode.appendTextChild((Node)serviceRefNode, (String)"wsdl-file", (String)descriptor.getWsdlFileUri());
        ServiceReferenceNode.appendTextChild((Node)serviceRefNode, (String)"jaxrpc-mapping-file", (String)descriptor.getMappingFileUri());
        if (descriptor.hasServiceName()) {
            QName serviceName = descriptor.getServiceName();
            this.appendQNameChild("service-qname", serviceRefNode, serviceName.getNamespaceURI(), serviceName.getLocalPart(), descriptor.getServiceNameNamespacePrefix());
        }
        for (ServiceRefPortInfo next : descriptor.getPortsInfo()) {
            String sei = next.getServiceEndpointInterface();
            Element portComponentRefNode = ServiceReferenceNode.appendChild((Node)serviceRefNode, (String)"port-component-ref");
            ServiceReferenceNode.appendTextChild((Node)portComponentRefNode, (String)"service-endpoint-interface", (String)sei);
            ServiceReferenceNode.appendTextChild((Node)portComponentRefNode, (String)"enable-mtom", (String)next.getMtomEnabled());
            if (descriptor.getAddressing() != null) {
                AddressingNode adNode = new AddressingNode();
                adNode.writeDescriptor(portComponentRefNode, "addressing", descriptor.getAddressing());
            }
            ServiceReferenceNode.appendTextChild((Node)portComponentRefNode, (String)"port-component-link", (String)next.getPortComponentLinkName());
        }
        WebServiceHandlerNode handlerNode = new WebServiceHandlerNode();
        handlerNode.writeWebServiceHandlers(serviceRefNode, descriptor.getHandlers());
        WebServiceHandlerChainNode handlerChainNode = new WebServiceHandlerChainNode();
        handlerChainNode.writeWebServiceHandlerChains(serviceRefNode, descriptor.getHandlerChain());
        ServiceReferenceNode.appendTextChild((Node)serviceRefNode, (String)"mapped-name", (String)descriptor.getMappedName());
        if (descriptor.isInjectable()) {
            InjectionTargetNode ijNode = new InjectionTargetNode();
            for (InjectionTarget target : descriptor.getInjectionTargets()) {
                ijNode.writeDescriptor(serviceRefNode, "injection-target", target);
            }
        }
        return serviceRefNode;
    }

    public ServiceReferenceDescriptor getDescriptor() {
        return (ServiceReferenceDescriptor)super.getDescriptor();
    }

    public String getTagName() {
        return "service-ref";
    }
}

